/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import org.elasticsearch.search.facet.histogram.HistogramFacet;

public class HistogramScriptFacetBuilder
extends AbstractFacetBuilder {
    private String lang;
    private String keyFieldName;
    private String keyScript;
    private String valueScript;
    private Map<String, Object> params;
    private long interval = -1L;
    private HistogramFacet.ComparatorType comparatorType;
    private Object from;
    private Object to;

    public HistogramScriptFacetBuilder(String name2) {
        super(name2);
    }

    public HistogramScriptFacetBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public HistogramScriptFacetBuilder keyField(String keyFieldName) {
        this.keyFieldName = keyFieldName;
        return this;
    }

    public HistogramScriptFacetBuilder keyScript(String keyScript) {
        this.keyScript = keyScript;
        return this;
    }

    public HistogramScriptFacetBuilder valueScript(String valueScript) {
        this.valueScript = valueScript;
        return this;
    }

    public HistogramScriptFacetBuilder interval(long interval) {
        this.interval = interval;
        return this;
    }

    public HistogramScriptFacetBuilder param(String name2, Object value2) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name2, value2);
        return this;
    }

    public HistogramScriptFacetBuilder comparator(HistogramFacet.ComparatorType comparatorType) {
        this.comparatorType = comparatorType;
        return this;
    }

    @Override
    public HistogramScriptFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public HistogramScriptFacetBuilder scope(String scope) {
        super.scope(scope);
        return this;
    }

    public HistogramScriptFacetBuilder bounds(Object from, Object to) {
        this.from = from;
        this.to = to;
        return this;
    }

    @Override
    public HistogramScriptFacetBuilder facetFilter(FilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    @Override
    public HistogramScriptFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        if (this.keyScript == null && this.keyFieldName == null) {
            throw new SearchSourceBuilderException("key_script or key_field must be set on histogram script facet for facet [" + this.name + "]");
        }
        if (this.valueScript == null) {
            throw new SearchSourceBuilderException("value_script must be set on histogram script facet for facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("histogram");
        if (this.keyFieldName != null) {
            builder.field("key_field", this.keyFieldName);
        } else if (this.keyScript != null) {
            builder.field("key_script", this.keyScript);
        }
        builder.field("value_script", this.valueScript);
        if (this.from != null && this.to != null) {
            builder.field("from", this.from);
            builder.field("to", this.to);
        }
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        if (this.interval > 0L) {
            builder.field("interval", this.interval);
        }
        if (this.params != null) {
            builder.field("params", this.params);
        }
        if (this.comparatorType != null) {
            builder.field("comparator", this.comparatorType.description());
        }
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params2);
        builder.endObject();
        return builder;
    }
}

