/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.facet.statistical.ScriptStatisticalFacetCollector;
import org.elasticsearch.search.facet.statistical.StatisticalFacetCollector;
import org.elasticsearch.search.facet.statistical.StatisticalFieldsFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class StatisticalFacetProcessor
extends AbstractComponent
implements FacetProcessor {
    @Inject
    public StatisticalFacetProcessor(Settings settings) {
        super(settings);
        InternalStatisticalFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"statistical"};
    }

    @Override
    public FacetCollector parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String field2 = null;
        String[] fieldsNames = null;
        String script = null;
        String scriptLang = null;
        Map<String, Object> params2 = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(currentFieldName)) continue;
                params2 = parser.map();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!"fields".equals(currentFieldName)) continue;
                ArrayList<String> fields2 = Lists.newArrayListWithCapacity(4);
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    fields2.add(parser.text());
                }
                fieldsNames = fields2.toArray(new String[fields2.size()]);
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(currentFieldName)) {
                field2 = parser.text();
                continue;
            }
            if ("script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if (!"lang".equals(currentFieldName)) continue;
            scriptLang = parser.text();
        }
        if (fieldsNames != null) {
            return new StatisticalFieldsFacetCollector(facetName, fieldsNames, context);
        }
        if (script == null && field2 == null) {
            throw new FacetPhaseExecutionException(facetName, "statistical facet requires either [script] or [field] to be set");
        }
        if (field2 != null) {
            return new StatisticalFacetCollector(facetName, field2, context);
        }
        return new ScriptStatisticalFacetCollector(facetName, scriptLang, script, params2, context);
    }

    @Override
    public Facet reduce(String name2, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        double min2 = Double.NaN;
        double max2 = Double.NaN;
        double total2 = 0.0;
        double sumOfSquares = 0.0;
        long count2 = 0L;
        for (Facet facet : facets) {
            if (!facet.name().equals(name2)) continue;
            InternalStatisticalFacet statsFacet = (InternalStatisticalFacet)facet;
            if (statsFacet.min() < min2 || Double.isNaN(min2)) {
                min2 = statsFacet.min();
            }
            if (statsFacet.max() > max2 || Double.isNaN(max2)) {
                max2 = statsFacet.max();
            }
            total2 += statsFacet.total();
            sumOfSquares += statsFacet.sumOfSquares();
            count2 += statsFacet.count();
        }
        return new InternalStatisticalFacet(name2, min2, max2, total2, sumOfSquares, count2);
    }
}

