/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.internal.SearchContext;

public class StatisticalFieldsFacetCollector
extends AbstractFacetCollector {
    private final String[] indexFieldsNames;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType[] fieldsDataType;
    private NumericFieldData[] fieldsData;
    private final StatsProc statsProc = new StatsProc();

    public StatisticalFieldsFacetCollector(String facetName, String[] fieldsNames, SearchContext context) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.fieldsDataType = new FieldDataType[fieldsNames.length];
        this.fieldsData = new NumericFieldData[fieldsNames.length];
        this.indexFieldsNames = new String[fieldsNames.length];
        for (int i2 = 0; i2 < fieldsNames.length; ++i2) {
            FieldMapper mapper = context.smartNameFieldMapper(fieldsNames[i2]);
            if (mapper == null) {
                throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldsNames[i2] + "]");
            }
            this.indexFieldsNames[i2] = mapper.names().indexName();
            this.fieldsDataType[i2] = mapper.fieldDataType();
        }
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        for (NumericFieldData fieldData : this.fieldsData) {
            fieldData.forEachValueInDoc(doc, this.statsProc);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        for (int i2 = 0; i2 < this.indexFieldsNames.length; ++i2) {
            this.fieldsData[i2] = (NumericFieldData)this.fieldDataCache.cache(this.fieldsDataType[i2], reader, this.indexFieldsNames[i2]);
        }
    }

    @Override
    public Facet facet() {
        return new InternalStatisticalFacet(this.facetName, this.statsProc.min(), this.statsProc.max(), this.statsProc.total(), this.statsProc.sumOfSquares(), this.statsProc.count());
    }

    public static class StatsProc
    implements NumericFieldData.MissingDoubleValueInDocProc {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double total = 0.0;
        double sumOfSquares = 0.0;
        long count;
        int missing;

        @Override
        public void onValue(int docId, double value2) {
            if (value2 < this.min) {
                this.min = value2;
            }
            if (value2 > this.max) {
                this.max = value2;
            }
            this.sumOfSquares += value2 * value2;
            this.total += value2;
            ++this.count;
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public final double min() {
            return this.min;
        }

        public final double max() {
            return this.max;
        }

        public final double total() {
            return this.total;
        }

        public final long count() {
            return this.count;
        }

        public final double sumOfSquares() {
            return this.sumOfSquares;
        }
    }
}

