/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.trove.iterator.TObjectIntIterator;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptTermsStringFieldFacetCollector
extends AbstractFacetCollector {
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int numberOfShards;
    private final SearchScript script;
    private final Matcher matcher;
    private final ImmutableSet<String> excluded;
    private final TObjectIntHashMap<String> facets;
    private int missing;
    private int total;

    public ScriptTermsStringFieldFacetCollector(String facetName, int size2, TermsFacet.ComparatorType comparatorType, SearchContext context, ImmutableSet<String> excluded, Pattern pattern, String scriptLang, String script, Map<String, Object> params2) {
        super(facetName);
        this.size = size2;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        this.script = context.scriptService().search(context.lookup(), scriptLang, script, params2);
        this.excluded = excluded;
        this.matcher = pattern != null ? pattern.matcher("") : null;
        this.facets = CacheRecycler.popObjectIntMap();
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.script.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.script.setNextReader(reader);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.script.setNextDocId(doc);
        Object o = this.script.run();
        if (o == null) {
            ++this.missing;
            return;
        }
        if (o instanceof Iterable) {
            boolean found = false;
            for (Object o1 : (Iterable)o) {
                String value2 = o1.toString();
                if (!this.match(value2)) continue;
                found = true;
                this.facets.adjustOrPutValue(value2, 1, 1);
                ++this.total;
            }
            if (!found) {
                ++this.missing;
            }
        } else if (o instanceof Object[]) {
            boolean found = false;
            for (Object o1 : (Object[])o) {
                String value3 = o1.toString();
                if (!this.match(value3)) continue;
                found = true;
                this.facets.adjustOrPutValue(value3, 1, 1);
                ++this.total;
            }
            if (!found) {
                ++this.missing;
            }
        } else {
            String value4 = o.toString();
            if (this.match(value4)) {
                this.facets.adjustOrPutValue(value4, 1, 1);
                ++this.total;
            } else {
                ++this.missing;
            }
        }
    }

    private boolean match(String value2) {
        if (this.excluded != null && this.excluded.contains(value2)) {
            return false;
        }
        return this.matcher == null || this.matcher.reset(value2).matches();
    }

    @Override
    public Facet facet() {
        if (this.facets.isEmpty()) {
            CacheRecycler.pushObjectIntMap(this.facets);
            return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, ImmutableList.<InternalStringTermsFacet.StringEntry>of(), this.missing, this.total);
        }
        if (this.size < 5000) {
            EntryPriorityQueue ordered = new EntryPriorityQueue(this.size, this.comparatorType.comparator());
            TObjectIntIterator<String> it = this.facets.iterator();
            while (it.hasNext()) {
                it.advance();
                ordered.insertWithOverflow(new InternalStringTermsFacet.StringEntry(it.key(), it.value()));
            }
            InternalStringTermsFacet.StringEntry[] list2 = new InternalStringTermsFacet.StringEntry[ordered.size()];
            for (int i2 = ordered.size() - 1; i2 >= 0; --i2) {
                list2[i2] = (InternalStringTermsFacet.StringEntry)ordered.pop();
            }
            CacheRecycler.pushObjectIntMap(this.facets);
            return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, Arrays.asList(list2), this.missing, this.total);
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size);
        TObjectIntIterator<String> it = this.facets.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new InternalStringTermsFacet.StringEntry(it.key(), it.value()));
        }
        CacheRecycler.pushObjectIntMap(this.facets);
        return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, ordered, this.missing, this.total);
    }
}

