/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;

public class TermsStatsFacetBuilder
extends AbstractFacetBuilder {
    private String keyField;
    private String valueField;
    private int size = -1;
    private TermsStatsFacet.ComparatorType comparatorType;
    private String script;
    private String lang;
    private Map<String, Object> params;

    public TermsStatsFacetBuilder(String name2) {
        super(name2);
    }

    public TermsStatsFacetBuilder keyField(String keyField) {
        this.keyField = keyField;
        return this;
    }

    public TermsStatsFacetBuilder valueField(String valueField) {
        this.valueField = valueField;
        return this;
    }

    public TermsStatsFacetBuilder order(TermsStatsFacet.ComparatorType comparatorType) {
        this.comparatorType = comparatorType;
        return this;
    }

    public TermsStatsFacetBuilder size(int size2) {
        this.size = size2;
        return this;
    }

    public TermsStatsFacetBuilder allTerms() {
        this.size = 0;
        return this;
    }

    public TermsStatsFacetBuilder valueScript(String script) {
        this.script = script;
        return this;
    }

    public TermsStatsFacetBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public TermsStatsFacetBuilder param(String name2, Object value2) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name2, value2);
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        if (this.keyField == null) {
            throw new SearchSourceBuilderException("key field must be set on terms facet for facet [" + this.name + "]");
        }
        if (this.valueField == null && this.script == null) {
            throw new SearchSourceBuilderException("value field or value script must be set on terms facet for facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("terms_stats");
        builder.field("key_field", this.keyField);
        if (this.valueField != null) {
            builder.field("value_field", this.valueField);
        }
        if (this.script != null) {
            builder.field("value_script", this.script);
            if (this.lang != null) {
                builder.field("lang", this.lang);
            }
            if (this.params != null) {
                builder.field("params", this.params);
            }
        }
        if (this.comparatorType != null) {
            builder.field("order", this.comparatorType.name().toLowerCase());
        }
        if (this.size != -1) {
            builder.field("size", this.size);
        }
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params2);
        builder.endObject();
        return builder;
    }
}

