/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats.strings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.ExtTHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.termsstats.InternalTermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;

public class InternalTermsStatsStringFacet
extends InternalTermsStatsFacet {
    private static final String STREAM_TYPE = "tTS";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type2, StreamInput in) throws IOException {
            return InternalTermsStatsStringFacet.readTermsStatsFacet(in);
        }
    };
    private String name;
    int requiredSize;
    long missing;
    Collection<StringEntry> entries = ImmutableList.of();
    TermsStatsFacet.ComparatorType comparatorType;

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    public InternalTermsStatsStringFacet() {
    }

    public InternalTermsStatsStringFacet(String name2, TermsStatsFacet.ComparatorType comparatorType, int requiredSize, Collection<StringEntry> entries2, long missing) {
        this.name = name2;
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries2;
        this.missing = missing;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String type() {
        return "terms_stats";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<StringEntry> entries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    List<StringEntry> mutableList() {
        if (!(this.entries instanceof List)) {
            this.entries = new ArrayList<StringEntry>(this.entries);
        }
        return (List)this.entries;
    }

    public List<StringEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<TermsStatsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long missingCount() {
        return this.missing;
    }

    @Override
    public long getMissingCount() {
        return this.missingCount();
    }

    @Override
    public Facet reduce(String name2, List<Facet> facets) {
        StringEntry value2;
        if (facets.size() == 1) {
            if (this.requiredSize == 0) {
                InternalTermsStatsStringFacet tsFacet = (InternalTermsStatsStringFacet)facets.get(0);
                if (!tsFacet.entries.isEmpty()) {
                    List<StringEntry> entries2 = tsFacet.mutableList();
                    Collections.sort(entries2, this.comparatorType.comparator());
                }
            }
            return facets.get(0);
        }
        int missing = 0;
        ExtTHashMap<String, StringEntry> map = CacheRecycler.popHashMap();
        for (Facet facet : facets) {
            InternalTermsStatsStringFacet tsFacet = (InternalTermsStatsStringFacet)facet;
            missing = (int)((long)missing + tsFacet.missing);
            for (TermsStatsFacet.Entry entry : tsFacet) {
                StringEntry stringEntry = (StringEntry)entry;
                StringEntry current2 = (StringEntry)map.get(stringEntry.term());
                if (current2 != null) {
                    current2.count += stringEntry.count;
                    current2.totalCount += stringEntry.totalCount;
                    current2.total += stringEntry.total;
                    if (stringEntry.min < current2.min) {
                        current2.min = stringEntry.min;
                    }
                    if (!(stringEntry.max > current2.max)) continue;
                    current2.max = stringEntry.max;
                    continue;
                }
                map.put(stringEntry.term(), stringEntry);
            }
        }
        if (this.requiredSize == 0) {
            StringEntry[] entries1 = map.values().toArray(new StringEntry[map.size()]);
            Arrays.sort(entries1, this.comparatorType.comparator());
            CacheRecycler.pushHashMap(map);
            return new InternalTermsStatsStringFacet(name2, this.comparatorType, this.requiredSize, Arrays.asList(entries1), missing);
        }
        Object[] values2 = map.internalValues();
        Arrays.sort(values2, this.comparatorType.comparator());
        ArrayList<StringEntry> ordered = new ArrayList<StringEntry>(map.size());
        for (int i2 = 0; i2 < this.requiredSize && (value2 = (StringEntry)values2[i2]) != null; ++i2) {
            ordered.add(value2);
        }
        CacheRecycler.pushHashMap(map);
        return new InternalTermsStatsStringFacet(name2, this.comparatorType, this.requiredSize, ordered, missing);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "terms_stats");
        builder.field(Fields.MISSING, this.missing);
        builder.startArray(Fields.TERMS);
        for (StringEntry entry : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, entry.term());
            builder.field(Fields.COUNT, entry.count());
            builder.field(Fields.TOTAL_COUNT, entry.totalCount());
            builder.field(Fields.MIN, entry.min());
            builder.field(Fields.MAX, entry.max());
            builder.field(Fields.TOTAL, entry.total());
            builder.field(Fields.MEAN, entry.mean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalTermsStatsStringFacet readTermsStatsFacet(StreamInput in) throws IOException {
        InternalTermsStatsStringFacet facet = new InternalTermsStatsStringFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = TermsStatsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        int size2 = in.readVInt();
        this.entries = new ArrayList<StringEntry>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.entries.add(new StringEntry(in.readUTF(), in.readVLong(), in.readVLong(), in.readDouble(), in.readDouble(), in.readDouble()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVInt(this.entries.size());
        for (StringEntry entry : this.entries) {
            out.writeUTF(entry.term());
            out.writeVLong(entry.count());
            out.writeVLong(entry.totalCount());
            out.writeDouble(entry.total());
            out.writeDouble(entry.min());
            out.writeDouble(entry.max());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");

        Fields() {
        }
    }

    public static class StringEntry
    implements TermsStatsFacet.Entry {
        String term;
        long count;
        long totalCount;
        double total;
        double min;
        double max;

        public StringEntry(String term, long count2, long totalCount, double total2, double min2, double max2) {
            this.term = term;
            this.count = count2;
            this.totalCount = totalCount;
            this.total = total2;
            this.min = min2;
            this.max = max2;
        }

        @Override
        public String term() {
            return this.term;
        }

        @Override
        public String getTerm() {
            return this.term();
        }

        @Override
        public Number termAsNumber() {
            return Double.parseDouble(this.term);
        }

        @Override
        public Number getTermAsNumber() {
            return this.termAsNumber();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public long getCount() {
            return this.count();
        }

        @Override
        public long totalCount() {
            return this.totalCount;
        }

        @Override
        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public double min() {
            return this.min;
        }

        @Override
        public double getMin() {
            return this.min();
        }

        @Override
        public double max() {
            return this.max;
        }

        @Override
        public double getMax() {
            return this.max();
        }

        @Override
        public double total() {
            return this.total;
        }

        @Override
        public double getTotal() {
            return this.total();
        }

        @Override
        public double mean() {
            if (this.totalCount == 0L) {
                return 0.0;
            }
            return this.total / (double)this.totalCount;
        }

        @Override
        public double getMean() {
            return this.mean();
        }

        @Override
        public int compareTo(TermsStatsFacet.Entry o) {
            return this.term.compareTo(o.term());
        }
    }
}

