/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats.strings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.trove.ExtTHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.strings.InternalTermsStatsStringFacet;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStatsStringFacetCollector
extends AbstractFacetCollector {
    private final TermsStatsFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final String keyFieldName;
    private final String valueFieldName;
    private final int size;
    private final int numberOfShards;
    private final FieldDataType keyFieldDataType;
    private FieldData keyFieldData;
    private final FieldDataType valueFieldDataType;
    private final SearchScript script;
    private final Aggregator aggregator;

    public TermsStatsStringFacetCollector(String facetName, String keyFieldName, String valueFieldName, int size2, TermsStatsFacet.ComparatorType comparatorType, SearchContext context, String scriptLang, String script, Map<String, Object> params2) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.size = size2;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        MapperService.SmartNameFieldMappers smartMappers = context.smartFieldMappers(keyFieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            this.keyFieldName = keyFieldName;
            this.keyFieldDataType = FieldDataType.DefaultTypes.STRING;
        } else {
            if (smartMappers.explicitTypeInNameWithDocMapper()) {
                this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
            }
            this.keyFieldName = smartMappers.mapper().names().indexName();
            this.keyFieldDataType = smartMappers.mapper().fieldDataType();
        }
        if (script == null) {
            smartMappers = context.smartFieldMappers(valueFieldName);
            if (smartMappers == null || !smartMappers.hasMapper()) {
                throw new ElasticSearchIllegalArgumentException("failed to find mappings for [" + valueFieldName + "]");
            }
            this.valueFieldName = smartMappers.mapper().names().indexName();
            this.valueFieldDataType = smartMappers.mapper().fieldDataType();
            this.script = null;
            this.aggregator = new Aggregator();
        } else {
            this.valueFieldName = null;
            this.valueFieldDataType = null;
            this.script = context.scriptService().search(context.lookup(), scriptLang, script, params2);
            this.aggregator = new ScriptAggregator(this.script);
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (this.script != null) {
            this.script.setScorer(scorer);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyFieldData = this.fieldDataCache.cache(this.keyFieldDataType, reader, this.keyFieldName);
        if (this.script != null) {
            this.script.setNextReader(reader);
        } else {
            this.aggregator.valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.valueFieldName);
        }
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.keyFieldData.forEachValueInDoc(doc, this.aggregator);
    }

    @Override
    public Facet facet() {
        InternalTermsStatsStringFacet.StringEntry value2;
        if (this.aggregator.entries.isEmpty()) {
            return new InternalTermsStatsStringFacet(this.facetName, this.comparatorType, this.size, ImmutableList.<InternalTermsStatsStringFacet.StringEntry>of(), this.aggregator.missing);
        }
        if (this.size == 0) {
            return new InternalTermsStatsStringFacet(this.facetName, this.comparatorType, 0, this.aggregator.entries.values(), this.aggregator.missing);
        }
        Object[] values2 = this.aggregator.entries.internalValues();
        Arrays.sort(values2, this.comparatorType.comparator());
        ArrayList<InternalTermsStatsStringFacet.StringEntry> ordered = Lists.newArrayList();
        int limit2 = this.size;
        for (int i2 = 0; i2 < limit2 && (value2 = (InternalTermsStatsStringFacet.StringEntry)values2[i2]) != null; ++i2) {
            ordered.add(value2);
        }
        CacheRecycler.pushHashMap(this.aggregator.entries);
        return new InternalTermsStatsStringFacet(this.facetName, this.comparatorType, this.size, ordered, this.aggregator.missing);
    }

    public static class ScriptAggregator
    extends Aggregator {
        private final SearchScript script;

        public ScriptAggregator(SearchScript script) {
            this.script = script;
        }

        @Override
        public void onValue(int docId, String value2) {
            InternalTermsStatsStringFacet.StringEntry stringEntry = (InternalTermsStatsStringFacet.StringEntry)this.entries.get(value2);
            if (stringEntry == null) {
                stringEntry = new InternalTermsStatsStringFacet.StringEntry(value2, 1L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(value2, stringEntry);
            } else {
                ++stringEntry.count;
            }
            this.script.setNextDocId(docId);
            double valueValue = this.script.runAsDouble();
            if (valueValue < stringEntry.min) {
                stringEntry.min = valueValue;
            }
            if (valueValue > stringEntry.max) {
                stringEntry.max = valueValue;
            }
            stringEntry.total += valueValue;
            ++stringEntry.totalCount;
        }
    }

    public static class Aggregator
    implements FieldData.StringValueInDocProc {
        final ExtTHashMap<String, InternalTermsStatsStringFacet.StringEntry> entries = CacheRecycler.popHashMap();
        int missing = 0;
        NumericFieldData valueFieldData;
        ValueAggregator valueAggregator = new ValueAggregator();

        @Override
        public void onValue(int docId, String value2) {
            InternalTermsStatsStringFacet.StringEntry stringEntry = (InternalTermsStatsStringFacet.StringEntry)this.entries.get(value2);
            if (stringEntry == null) {
                stringEntry = new InternalTermsStatsStringFacet.StringEntry(value2, 0L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(value2, stringEntry);
            }
            ++stringEntry.count;
            this.valueAggregator.stringEntry = stringEntry;
            this.valueFieldData.forEachValueInDoc(docId, this.valueAggregator);
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public static class ValueAggregator
        implements NumericFieldData.DoubleValueInDocProc {
            InternalTermsStatsStringFacet.StringEntry stringEntry;

            @Override
            public void onValue(int docId, double value2) {
                if (value2 < this.stringEntry.min) {
                    this.stringEntry.min = value2;
                }
                if (value2 > this.stringEntry.max) {
                    this.stringEntry.max = value2;
                }
                this.stringEntry.total += value2;
                ++this.stringEntry.totalCount;
            }
        }
    }
}

