/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public class FieldsParseElement
implements SearchParseElement {
    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            boolean added = false;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                String name2 = parser.text();
                if (name2.contains("_source.") || name2.contains("doc[")) {
                    SearchScript searchScript = context.scriptService().search(context.lookup(), "mvel", name2, null);
                    context.scriptFields().add(new ScriptFieldsContext.ScriptField(name2, searchScript, true));
                    continue;
                }
                added = true;
                context.fieldNames().add(name2);
            }
            if (!added) {
                context.emptyFieldNames();
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            String name3 = parser.text();
            if (name3.contains("_source.") || name3.contains("doc[")) {
                SearchScript searchScript = context.scriptService().search(context.lookup(), "mvel", name3, null);
                context.scriptFields().add(new ScriptFieldsContext.ScriptField(name3, searchScript, true));
            } else {
                context.fieldNames().add(name3);
            }
        }
    }
}

