/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.vectorhighlight.AbstractFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.CustomFieldQuery;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;
import org.apache.lucene.search.vectorhighlight.SingleFragListBuilder;
import org.apache.lucene.search.vectorhighlight.XScoreOrderFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.XSimpleFragmentsBuilder;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.lucene.document.SingleFieldSelector;
import org.elasticsearch.common.lucene.search.vectorhighlight.SimpleBoundaryScanner2;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.highlight.CustomQueryScorer;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlighterParseElement;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.highlight.vectorhighlight.SourceScoreOrderFragmentsBuilder;
import org.elasticsearch.search.highlight.vectorhighlight.SourceSimpleFragmentsBuilder;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class HighlightPhase
extends AbstractComponent
implements FetchSubPhase {
    private final boolean termVectorMultiValue;

    @Inject
    public HighlightPhase(Settings settings) {
        super(settings);
        this.termVectorMultiValue = this.componentSettings.getAsBoolean("term_vector_multi_value", true);
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("highlight", new HighlighterParseElement());
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticSearchException {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.highlight() != null;
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticSearchException {
        HighlighterEntry cache = (HighlighterEntry)hitContext.cache().get("highlight");
        if (cache == null) {
            cache = new HighlighterEntry();
            hitContext.cache().put("highlight", cache);
        }
        DocumentMapper documentMapper = context.mapperService().documentMapper(hitContext.hit().type());
        HashMap<String, HighlightField> highlightFields = Maps.newHashMap();
        for (SearchContextHighlight.Field field2 : context.highlight().fields()) {
            Encoder encoder = field2.encoder().equals("html") ? Encoders.HTML : Encoders.DEFAULT;
            Set<String> fieldNamesToHighlight = Regex.isSimpleMatchPattern(field2.field()) ? documentMapper.mappers().simpleMatchToFullName(field2.field()) : ImmutableSet.of(field2.field());
            for (String fieldName : fieldNamesToHighlight) {
                MapperHighlightEntry entry;
                boolean useFastVectorHighlighter;
                MapperService.SmartNameFieldMappers fullMapper;
                FieldMapper mapper = documentMapper.mappers().smartNameFieldMapper(fieldName);
                if (mapper == null && ((fullMapper = context.mapperService().smartName(fieldName)) == null || !fullMapper.hasDocMapper() || !fullMapper.docMapper().type().equals(hitContext.hit().type()) || (mapper = fullMapper.mapper()) == null)) continue;
                if (field2.highlighterType() == null) {
                    useFastVectorHighlighter = mapper.termVector() == Field.TermVector.WITH_POSITIONS_OFFSETS;
                } else if (field2.highlighterType().equals("fast-vector-highlighter") || field2.highlighterType().equals("fvh")) {
                    if (mapper.termVector() != Field.TermVector.WITH_POSITIONS_OFFSETS) {
                        throw new ElasticSearchIllegalArgumentException("the field [" + fieldName + "] should be indexed with term vector with position offsets to be used with fast vector highlighter");
                    }
                    useFastVectorHighlighter = true;
                } else if (field2.highlighterType().equals("highlighter") || field2.highlighterType().equals("plain")) {
                    useFastVectorHighlighter = false;
                } else {
                    throw new ElasticSearchIllegalArgumentException("unknown highlighter type [" + field2.highlighterType() + "] for the field [" + fieldName + "]");
                }
                if (!useFastVectorHighlighter) {
                    int i2;
                    List<Object> textsToHighlight;
                    entry = cache.mappers.get(mapper);
                    if (entry == null) {
                        Fragmenter fragmenter;
                        Query query = context.parsedQuery().query();
                        CustomQueryScorer queryScorer = new CustomQueryScorer(query, field2.requireFieldMatch() != false ? mapper.names().indexName() : null);
                        queryScorer.setExpandMultiTermQuery(true);
                        if (field2.numberOfFragments() == 0) {
                            fragmenter = new NullFragmenter();
                        } else if (field2.fragmenter() == null) {
                            fragmenter = new SimpleSpanFragmenter(queryScorer, field2.fragmentCharSize());
                        } else if ("simple".equals(field2.fragmenter())) {
                            fragmenter = new SimpleFragmenter(field2.fragmentCharSize());
                        } else if ("span".equals(field2.fragmenter())) {
                            fragmenter = new SimpleSpanFragmenter(queryScorer, field2.fragmentCharSize());
                        } else {
                            throw new ElasticSearchIllegalArgumentException("unknown fragmenter option [" + field2.fragmenter() + "] for the field [" + fieldName + "]");
                        }
                        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(field2.preTags()[0], field2.postTags()[0]);
                        entry = new MapperHighlightEntry();
                        entry.highlighter = new Highlighter(formatter, encoder, queryScorer);
                        entry.highlighter.setTextFragmenter(fragmenter);
                        entry.highlighter.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
                        cache.mappers.put(mapper, entry);
                    }
                    if (mapper.stored()) {
                        try {
                            Document doc = hitContext.reader().document(hitContext.docId(), new SingleFieldSelector(mapper.names().indexName()));
                            textsToHighlight = new ArrayList<Object>(doc.getFields().size());
                            for (Fieldable docField : doc.getFields()) {
                                if (docField.stringValue() == null) continue;
                                textsToHighlight.add(docField.stringValue());
                            }
                        }
                        catch (Exception e) {
                            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + fieldName + "]", (Throwable)e);
                        }
                    } else {
                        SearchLookup lookup = context.lookup();
                        lookup.setNextReader(hitContext.reader());
                        lookup.setNextDocId(hitContext.docId());
                        textsToHighlight = lookup.source().extractRawValues(mapper.names().sourcePath());
                    }
                    int numberOfFragments = field2.numberOfFragments() == 0 ? 1 : field2.numberOfFragments();
                    ArrayList<TextFragment> fragsList = new ArrayList<TextFragment>();
                    try {
                        for (Object textToHighlight : textsToHighlight) {
                            TextFragment[] bestTextFragments;
                            String text = textToHighlight.toString();
                            Analyzer analyzer = context.mapperService().documentMapper(hitContext.hit().type()).mappers().indexAnalyzer();
                            TokenStream tokenStream = analyzer.reusableTokenStream(mapper.names().indexName(), new FastStringReader(text));
                            for (TextFragment bestTextFragment : bestTextFragments = entry.highlighter.getBestTextFragments(tokenStream, text, false, numberOfFragments)) {
                                if (bestTextFragment == null || !(bestTextFragment.getScore() > 0.0f)) continue;
                                fragsList.add(bestTextFragment);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + fieldName + "]", (Throwable)e);
                    }
                    if (field2.scoreOrdered().booleanValue()) {
                        Collections.sort(fragsList, new Comparator<TextFragment>(){

                            @Override
                            public int compare(TextFragment o1, TextFragment o2) {
                                return Math.round(o2.getScore() - o1.getScore());
                            }
                        });
                    }
                    String[] fragments = null;
                    if (field2.numberOfFragments() == 0 && textsToHighlight.size() > 1 && fragsList.size() > 0) {
                        fragments = new String[fragsList.size()];
                        for (i2 = 0; i2 < fragsList.size(); ++i2) {
                            fragments[i2] = ((TextFragment)fragsList.get(i2)).toString();
                        }
                    } else {
                        numberOfFragments = fragsList.size() < numberOfFragments ? fragsList.size() : numberOfFragments;
                        fragments = new String[numberOfFragments];
                        for (i2 = 0; i2 < fragments.length; ++i2) {
                            fragments[i2] = ((TextFragment)fragsList.get(i2)).toString();
                        }
                    }
                    if (fragments == null || fragments.length <= 0) continue;
                    HighlightField highlightField = new HighlightField(fieldName, StringText.convertFromStringArray(fragments));
                    highlightFields.put(highlightField.name(), highlightField);
                    continue;
                }
                try {
                    int fragmentCharSize;
                    entry = cache.mappers.get(mapper);
                    FieldQuery fieldQuery = null;
                    if (entry == null) {
                        AbstractFragmentsBuilder fragmentsBuilder;
                        FragListBuilder fragListBuilder;
                        SimpleBoundaryScanner2 boundaryScanner = SimpleBoundaryScanner2.DEFAULT;
                        if (field2.boundaryMaxScan() != 20 || field2.boundaryChars() != SimpleBoundaryScanner2.DEFAULT_BOUNDARY_CHARS) {
                            boundaryScanner = new SimpleBoundaryScanner2(field2.boundaryMaxScan(), field2.boundaryChars());
                        }
                        if (field2.numberOfFragments() == 0) {
                            fragListBuilder = new SingleFragListBuilder();
                            fragmentsBuilder = mapper.stored() ? new XSimpleFragmentsBuilder(field2.preTags(), field2.postTags(), boundaryScanner) : new SourceSimpleFragmentsBuilder(mapper, context, field2.preTags(), field2.postTags(), boundaryScanner);
                        } else {
                            fragListBuilder = field2.fragmentOffset() == -1 ? new SimpleFragListBuilder() : new SimpleFragListBuilder(field2.fragmentOffset());
                            fragmentsBuilder = field2.scoreOrdered().booleanValue() ? (mapper.stored() ? new XScoreOrderFragmentsBuilder(field2.preTags(), field2.postTags(), boundaryScanner) : new SourceScoreOrderFragmentsBuilder(mapper, context, field2.preTags(), field2.postTags(), boundaryScanner)) : (mapper.stored() ? new XSimpleFragmentsBuilder(field2.preTags(), field2.postTags(), boundaryScanner) : new SourceSimpleFragmentsBuilder(mapper, context, field2.preTags(), field2.postTags(), boundaryScanner));
                        }
                        fragmentsBuilder.setDiscreteMultiValueHighlighting(this.termVectorMultiValue);
                        entry = new MapperHighlightEntry();
                        entry.fragListBuilder = fragListBuilder;
                        entry.fragmentsBuilder = fragmentsBuilder;
                        if (cache.fvh == null) {
                            cache.fvh = new FastVectorHighlighter();
                        }
                        CustomFieldQuery.highlightFilters.set(field2.highlightFilter());
                        if (field2.requireFieldMatch().booleanValue()) {
                            if (cache.fieldMatchFieldQuery == null) {
                                cache.fieldMatchFieldQuery = new CustomFieldQuery(context.parsedQuery().query(), hitContext.topLevelReader(), true, field2.requireFieldMatch());
                            }
                            fieldQuery = cache.fieldMatchFieldQuery;
                        } else {
                            if (cache.noFieldMatchFieldQuery == null) {
                                cache.noFieldMatchFieldQuery = new CustomFieldQuery(context.parsedQuery().query(), hitContext.topLevelReader(), true, field2.requireFieldMatch());
                            }
                            fieldQuery = cache.noFieldMatchFieldQuery;
                        }
                        cache.mappers.put(mapper, entry);
                    }
                    int numberOfFragments = field2.numberOfFragments() == 0 ? Integer.MAX_VALUE : field2.numberOfFragments();
                    int n = fragmentCharSize = field2.numberOfFragments() == 0 ? Integer.MAX_VALUE : field2.fragmentCharSize();
                    String[] fragments = cache.fvh.getBestFragments(fieldQuery, hitContext.reader(), hitContext.docId(), mapper.names().indexName(), fragmentCharSize, numberOfFragments, entry.fragListBuilder, entry.fragmentsBuilder, field2.preTags(), field2.postTags(), encoder);
                    if (fragments == null || fragments.length <= 0) continue;
                    HighlightField highlightField = new HighlightField(fieldName, StringText.convertFromStringArray(fragments));
                    highlightFields.put(highlightField.name(), highlightField);
                }
                catch (Exception e) {
                    throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + fieldName + "]", (Throwable)e);
                }
            }
        }
        hitContext.hit().highlightFields(highlightFields);
    }

    static class HighlighterEntry {
        public FastVectorHighlighter fvh;
        public FieldQuery noFieldMatchFieldQuery;
        public FieldQuery fieldMatchFieldQuery;
        public Map<FieldMapper, MapperHighlightEntry> mappers = Maps.newHashMap();

        HighlighterEntry() {
        }
    }

    static class MapperHighlightEntry {
        public FragListBuilder fragListBuilder;
        public FragmentsBuilder fragmentsBuilder;
        public Highlighter highlighter;

        MapperHighlightEntry() {
        }
    }

    public static class Encoders {
        public static Encoder DEFAULT = new DefaultEncoder();
        public static Encoder HTML = new SimpleHTMLEncoder();
    }
}

