/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.ExtendedIndexSearcher;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.lucene.MinimumScoreCollector;
import org.elasticsearch.common.lucene.MultiCollector;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.common.lucene.search.FilteredCollector;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.search.dfs.CachedDfSource;
import org.elasticsearch.search.internal.SearchContext;

public class ContextIndexSearcher
extends ExtendedIndexSearcher {
    private final SearchContext searchContext;
    private final IndexReader reader;
    private CachedDfSource dfSource;
    private Map<String, List<Collector>> scopeCollectors;
    private String processingScope;

    public ContextIndexSearcher(SearchContext searchContext, Engine.Searcher searcher) {
        super(searcher.searcher());
        this.searchContext = searchContext;
        this.reader = searcher.searcher().getIndexReader();
    }

    public void dfSource(CachedDfSource dfSource) {
        this.dfSource = dfSource;
    }

    public void addCollector(String scope, Collector collector) {
        List<Collector> collectors;
        if (this.scopeCollectors == null) {
            this.scopeCollectors = Maps.newHashMap();
        }
        if ((collectors = this.scopeCollectors.get(scope)) == null) {
            collectors = Lists.newArrayList();
            this.scopeCollectors.put(scope, collectors);
        }
        collectors.add(collector);
    }

    public List<Collector> removeCollectors(String scope) {
        if (this.scopeCollectors == null) {
            return null;
        }
        return this.scopeCollectors.remove(scope);
    }

    public boolean hasCollectors(String scope) {
        if (this.scopeCollectors == null) {
            return false;
        }
        if (!this.scopeCollectors.containsKey(scope)) {
            return false;
        }
        return !this.scopeCollectors.get(scope).isEmpty();
    }

    public void processingScope(String scope) {
        this.processingScope = scope;
    }

    public void processedScope() {
        if (this.scopeCollectors != null) {
            this.scopeCollectors.remove(this.processingScope);
        }
        this.processingScope = "_na_";
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        if (original == this.searchContext.query() || original == this.searchContext.parsedQuery().query()) {
            if (this.searchContext.queryRewritten()) {
                return this.searchContext.query();
            }
            Query rewriteQuery = super.rewrite(original);
            this.searchContext.updateRewriteQuery(rewriteQuery);
            return rewriteQuery;
        }
        return super.rewrite(original);
    }

    @Override
    public Weight createNormalizedWeight(Query query) throws IOException {
        if (this.dfSource != null && (query == this.searchContext.query() || query == this.searchContext.parsedQuery().query())) {
            return this.dfSource.createNormalizedWeight(query);
        }
        return super.createNormalizedWeight(query);
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort2, boolean fillFields) throws IOException {
        int limit2 = this.reader.maxDoc();
        if (limit2 == 0) {
            limit2 = 1;
        }
        nDocs = Math.min(nDocs, limit2);
        TopFieldCollector collector = TopFieldCollector.create(sort2, nDocs, fillFields, this.searchContext.trackScores(), this.searchContext.trackScores(), !weight.scoresDocsOutOfOrder());
        this.search(weight, filter, (Collector)collector);
        return (TopFieldDocs)collector.topDocs();
    }

    @Override
    public void search(Weight weight, Filter filter, Collector collector) throws IOException {
        List<Collector> collectors;
        if (this.searchContext.parsedFilter() != null && "_main_".equals(this.processingScope)) {
            collector = new FilteredCollector(collector, this.searchContext.parsedFilter());
        }
        if (this.searchContext.timeoutInMillis() != -1L) {
            collector = new TimeLimitingCollector(collector, TimeLimitingCollector.getGlobalCounter(), this.searchContext.timeoutInMillis());
        }
        if (this.scopeCollectors != null && (collectors = this.scopeCollectors.get(this.processingScope)) != null && !collectors.isEmpty()) {
            collector = new MultiCollector(collector, collectors.toArray(new Collector[collectors.size()]));
        }
        if (this.searchContext.minimumScore() != null) {
            collector = new MinimumScoreCollector(collector, this.searchContext.minimumScore().floatValue());
        }
        Filter combinedFilter = filter == null ? this.searchContext.aliasFilter() : (this.searchContext.aliasFilter() != null ? new AndFilter(ImmutableList.of(filter, this.searchContext.aliasFilter())) : filter);
        if (this.searchContext.timeoutInMillis() != -1L) {
            try {
                super.search(weight, combinedFilter, collector);
            }
            catch (TimeLimitingCollector.TimeExceededException e) {
                this.searchContext.queryResult().searchTimedOut(true);
            }
        } else {
            super.search(weight, combinedFilter, collector);
        }
    }

    @Override
    public Explanation explain(Query query, int doc) throws IOException {
        if (this.searchContext.aliasFilter() == null) {
            return super.explain(query, doc);
        }
        FilteredQuery filteredQuery = new FilteredQuery(query, this.searchContext.aliasFilter());
        return super.explain(filteredQuery, doc);
    }

    public static final class Scopes {
        public static final String MAIN = "_main_";
        public static final String GLOBAL = "_global_";
        public static final String NA = "_na_";
    }
}

