/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.facet.Facets;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;

public class InternalSearchResponse
implements Streamable,
ToXContent {
    private InternalSearchHits hits;
    private InternalFacets facets;
    private boolean timedOut;
    public static final InternalSearchResponse EMPTY = new InternalSearchResponse(new InternalSearchHits(new InternalSearchHit[0], 0L, 0.0f), null, false);

    private InternalSearchResponse() {
    }

    public InternalSearchResponse(InternalSearchHits hits, InternalFacets facets, boolean timedOut) {
        this.hits = hits;
        this.facets = facets;
        this.timedOut = timedOut;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public SearchHits hits() {
        return this.hits;
    }

    public Facets facets() {
        return this.facets;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        this.hits.toXContent(builder, params2);
        if (this.facets != null) {
            this.facets.toXContent(builder, params2);
        }
        return builder;
    }

    public static InternalSearchResponse readInternalSearchResponse(StreamInput in) throws IOException {
        InternalSearchResponse response = new InternalSearchResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.hits = InternalSearchHits.readSearchHits(in);
        if (in.readBoolean()) {
            this.facets = InternalFacets.readFacets(in);
        }
        this.timedOut = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.hits.writeTo(out);
        if (this.facets == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.facets.writeTo(out);
        }
        out.writeBoolean(this.timedOut);
    }
}

