/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import org.apache.lucene.search.SortField;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.index.search.geo.GeoDistanceDataComparator;
import org.elasticsearch.index.search.geo.GeoHashUtils;
import org.elasticsearch.index.search.geo.GeoUtils;
import org.elasticsearch.index.search.geo.Point;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortParser;

public class GeoDistanceSortParser
implements SortParser {
    @Override
    public String[] names() {
        return new String[]{"_geo_distance", "_geoDistance"};
    }

    @Override
    public SortField parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token;
        String fieldName = null;
        double lat = Double.NaN;
        double lon = Double.NaN;
        DistanceUnit unit = DistanceUnit.KILOMETERS;
        GeoDistance geoDistance = GeoDistance.ARC;
        boolean reverse2 = false;
        boolean normalizeLon = true;
        boolean normalizeLat = true;
        String currentName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                token = parser.nextToken();
                lon = parser.doubleValue();
                token = parser.nextToken();
                lat = parser.doubleValue();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                }
                fieldName = currentName;
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if (currentName.equals("lat")) {
                        lat = parser.doubleValue();
                        continue;
                    }
                    if (currentName.equals("lon")) {
                        lon = parser.doubleValue();
                        continue;
                    }
                    if (!currentName.equals("geohash")) continue;
                    double[] values2 = GeoHashUtils.decode(parser.text());
                    lat = values2[0];
                    lon = values2[1];
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("reverse".equals(currentName)) {
                reverse2 = parser.booleanValue();
                continue;
            }
            if ("order".equals(currentName)) {
                reverse2 = "desc".equals(parser.text());
                continue;
            }
            if (currentName.equals("unit")) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (currentName.equals("distance_type") || currentName.equals("distanceType")) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if ("normalize".equals(currentName)) {
                normalizeLat = parser.booleanValue();
                normalizeLon = parser.booleanValue();
                continue;
            }
            String value2 = parser.text();
            int comma = value2.indexOf(44);
            if (comma != -1) {
                lat = Double.parseDouble(value2.substring(0, comma).trim());
                lon = Double.parseDouble(value2.substring(comma + 1).trim());
            } else {
                double[] values3 = GeoHashUtils.decode(value2);
                lat = values3[0];
                lon = values3[1];
            }
            fieldName = currentName;
        }
        if (normalizeLat || normalizeLon) {
            Point point = new Point(lat, lon);
            GeoUtils.normalizePoint(point, normalizeLat, normalizeLon);
            lat = point.lat;
            lon = point.lon;
        }
        return new SortField(fieldName, GeoDistanceDataComparator.comparatorSource(fieldName, lat, lon, unit, geoDistance, context.fieldDataCache(), context.mapperService()), reverse2);
    }
}

