/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.GeoDistanceSortParser;
import org.elasticsearch.search.sort.ScriptSortParser;
import org.elasticsearch.search.sort.SortParser;

public class SortParseElement
implements SearchParseElement {
    private static final SortField SORT_SCORE = new SortField(null, 0);
    private static final SortField SORT_SCORE_REVERSE = new SortField(null, 0, true);
    private static final SortField SORT_DOC = new SortField(null, 1);
    private static final SortField SORT_DOC_REVERSE = new SortField(null, 1, true);
    public static final String SCORE_FIELD_NAME = "_score";
    public static final String DOC_FIELD_NAME = "_doc";
    private final ImmutableMap<String, SortParser> parsers;

    public SortParseElement() {
        ImmutableMap.Builder<String, SortParser> builder = ImmutableMap.builder();
        this.addParser(builder, new ScriptSortParser());
        this.addParser(builder, new GeoDistanceSortParser());
        this.parsers = builder.build();
    }

    private void addParser(ImmutableMap.Builder<String, SortParser> parsers, SortParser parser) {
        for (String name2 : parser.names()) {
            parsers.put(name2, parser);
        }
    }

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        SortField sortField;
        boolean sort2;
        XContentParser.Token token = parser.currentToken();
        ArrayList<SortField> sortFields = Lists.newArrayListWithCapacity(2);
        if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.START_OBJECT) {
                    this.addCompoundSortField(parser, context, sortFields);
                    continue;
                }
                if (token != XContentParser.Token.VALUE_STRING) continue;
                this.addSortField(context, sortFields, parser.text(), false, false, null);
            }
        } else {
            this.addCompoundSortField(parser, context, sortFields);
        }
        if (!sortFields.isEmpty() && (sort2 = sortFields.size() > 1 ? true : (sortField = (SortField)sortFields.get(0)).getType() != 0 || sortField.getReverse())) {
            context.sort(new Sort(sortFields.toArray(new SortField[sortFields.size()])));
        }
    }

    private void addCompoundSortField(XContentParser parser, SearchContext context, List<SortField> sortFields) throws Exception {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            boolean reverse2 = false;
            String missing = null;
            String innerJsonName = null;
            boolean ignoreUnmapped = false;
            token = parser.nextToken();
            if (token == XContentParser.Token.VALUE_STRING) {
                String direction = parser.text();
                if (direction.equals("asc")) {
                    reverse2 = SCORE_FIELD_NAME.equals(fieldName);
                } else if (direction.equals("desc")) {
                    reverse2 = !SCORE_FIELD_NAME.equals(fieldName);
                }
                this.addSortField(context, sortFields, fieldName, reverse2, ignoreUnmapped, missing);
                continue;
            }
            if (this.parsers.containsKey(fieldName)) {
                sortFields.add(this.parsers.get(fieldName).parse(parser, context));
                continue;
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    innerJsonName = parser.currentName();
                    continue;
                }
                if (!token.isValue()) continue;
                if ("reverse".equals(innerJsonName)) {
                    reverse2 = parser.booleanValue();
                    continue;
                }
                if ("order".equals(innerJsonName)) {
                    if ("asc".equals(parser.text())) {
                        reverse2 = SCORE_FIELD_NAME.equals(fieldName);
                        continue;
                    }
                    if (!"desc".equals(parser.text())) continue;
                    reverse2 = !SCORE_FIELD_NAME.equals(fieldName);
                    continue;
                }
                if ("missing".equals(innerJsonName)) {
                    missing = parser.textOrNull();
                    continue;
                }
                if (!"ignore_unmapped".equals(innerJsonName) && !"ignoreUnmapped".equals(innerJsonName)) continue;
                ignoreUnmapped = parser.booleanValue();
            }
            this.addSortField(context, sortFields, fieldName, reverse2, ignoreUnmapped, missing);
        }
    }

    private void addSortField(SearchContext context, List<SortField> sortFields, String fieldName, boolean reverse2, boolean ignoreUnmapped, @Nullable String missing) {
        if (SCORE_FIELD_NAME.equals(fieldName)) {
            if (reverse2) {
                sortFields.add(SORT_SCORE_REVERSE);
            } else {
                sortFields.add(SORT_SCORE);
            }
        } else if (DOC_FIELD_NAME.equals(fieldName)) {
            if (reverse2) {
                sortFields.add(SORT_DOC_REVERSE);
            } else {
                sortFields.add(SORT_DOC);
            }
        } else {
            FieldMapper fieldMapper = context.smartNameFieldMapper(fieldName);
            if (fieldMapper == null) {
                if (ignoreUnmapped) {
                    return;
                }
                throw new SearchParseException(context, "No mapping found for [" + fieldName + "] in order to sort on");
            }
            sortFields.add(new SortField(fieldMapper.names().indexName(), fieldMapper.fieldDataType().newFieldComparatorSource(context.fieldDataCache(), missing), reverse2));
        }
    }
}

