/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.ThrowableObjectInputStream;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.SimpleChannelUpstreamHandler;
import org.elasticsearch.common.netty.channel.WriteCompletionEvent;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportSerializationException;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.netty.ChannelBufferStreamInputFactory;
import org.elasticsearch.transport.netty.NettyTransport;
import org.elasticsearch.transport.netty.NettyTransportChannel;
import org.elasticsearch.transport.support.TransportStatus;

public class MessageChannelHandler
extends SimpleChannelUpstreamHandler {
    private final ESLogger logger;
    private final ThreadPool threadPool;
    private final TransportServiceAdapter transportServiceAdapter;
    private final NettyTransport transport;

    public MessageChannelHandler(NettyTransport transport, ESLogger logger) {
        this.threadPool = transport.threadPool();
        this.transportServiceAdapter = transport.transportServiceAdapter();
        this.transport = transport;
        this.logger = logger;
    }

    @Override
    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        this.transportServiceAdapter.sent(e.getWrittenAmount());
        super.writeComplete(ctx, e);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        HandlesStreamInput wrappedStream;
        Object m = e.getMessage();
        if (!(m instanceof ChannelBuffer)) {
            ctx.sendUpstream(e);
            return;
        }
        ChannelBuffer buffer = (ChannelBuffer)m;
        int size2 = buffer.getInt(buffer.readerIndex() - 4);
        this.transportServiceAdapter.received(size2 + 6);
        boolean hasMessageBytesToRead = size2 - 13 != 0;
        int markedReaderIndex = buffer.readerIndex();
        int expectedIndexReader = markedReaderIndex + size2;
        StreamInput streamIn = ChannelBufferStreamInputFactory.create(buffer, size2);
        long requestId = buffer.readLong();
        byte status2 = buffer.readByte();
        Version version = Version.fromId(buffer.readInt());
        if (TransportStatus.isCompress(status2) && hasMessageBytesToRead && buffer.readable()) {
            Compressor compressor = CompressorFactory.compressor(buffer);
            if (compressor == null) {
                int maxToRead = Math.min(buffer.readableBytes(), 10);
                int offset2 = buffer.readerIndex();
                StringBuilder sb = new StringBuilder("stream marked as compressed, but no compressor found, first [").append(maxToRead).append("] content bytes out of [").append(buffer.readableBytes()).append("] readable bytes with message size [").append(size2).append("] ").append("] are [");
                for (int i2 = 0; i2 < maxToRead; ++i2) {
                    sb.append(buffer.getByte(offset2 + i2)).append(",");
                }
                sb.append("]");
                throw new ElasticSearchIllegalStateException(sb.toString());
            }
            wrappedStream = CachedStreamInput.cachedHandlesCompressed(compressor, streamIn);
        } else {
            wrappedStream = CachedStreamInput.cachedHandles(streamIn);
        }
        ((StreamInput)wrappedStream).setVersion(version);
        if (TransportStatus.isRequest(status2)) {
            String action = this.handleRequest(ctx.getChannel(), wrappedStream, requestId, version);
            if (buffer.readerIndex() != expectedIndexReader) {
                if (buffer.readerIndex() < expectedIndexReader) {
                    this.logger.warn("Message not fully read (request) for [{}] and action [{}], resetting", requestId, action);
                } else {
                    this.logger.warn("Message read past expected size (request) for [{}] and action [{}], resetting", requestId, action);
                }
                buffer.readerIndex(expectedIndexReader);
            }
        } else {
            TransportResponseHandler handler = this.transportServiceAdapter.remove(requestId);
            if (handler != null) {
                if (TransportStatus.isError(status2)) {
                    this.handlerResponseError(wrappedStream, handler);
                } else {
                    this.handleResponse(wrappedStream, handler);
                }
            } else {
                buffer.readerIndex(markedReaderIndex + size2);
            }
            if (buffer.readerIndex() != expectedIndexReader) {
                if (buffer.readerIndex() < expectedIndexReader) {
                    this.logger.warn("Message not fully read (response) for [{}] handler {}, error [{}], resetting", requestId, handler, TransportStatus.isError(status2));
                } else {
                    this.logger.warn("Message read past expected size (response) for [{}] handler {}, error [{}], resetting", requestId, handler, TransportStatus.isError(status2));
                }
                buffer.readerIndex(expectedIndexReader);
            }
        }
        ((StreamInput)wrappedStream).close();
    }

    private void handleResponse(StreamInput buffer, TransportResponseHandler handler) {
        Object response = handler.newInstance();
        try {
            ((TransportResponse)response).readFrom(buffer);
        }
        catch (Exception e) {
            this.handleException(handler, new TransportSerializationException("Failed to deserialize response of type [" + response.getClass().getName() + "]", e));
            return;
        }
        try {
            if (handler.executor() == "same") {
                handler.handleResponse(response);
            } else {
                this.threadPool.executor(handler.executor()).execute(new ResponseHandler(handler, (TransportResponse)response));
            }
        }
        catch (Exception e) {
            this.handleException(handler, new ResponseHandlerFailureTransportException(e));
        }
    }

    private void handlerResponseError(StreamInput buffer, TransportResponseHandler handler) {
        Throwable error2;
        try {
            ThrowableObjectInputStream ois = new ThrowableObjectInputStream(buffer, this.transport.settings().getClassLoader());
            error2 = (Throwable)ois.readObject();
        }
        catch (Exception e) {
            error2 = new TransportSerializationException("Failed to deserialize exception response from stream", e);
        }
        this.handleException(handler, error2);
    }

    private void handleException(final TransportResponseHandler handler, Throwable error2) {
        if (!(error2 instanceof RemoteTransportException)) {
            error2 = new RemoteTransportException(error2.getMessage(), error2);
        }
        final RemoteTransportException rtx = (RemoteTransportException)error2;
        if (handler.executor() == "same") {
            handler.handleException(rtx);
        } else {
            this.threadPool.executor(handler.executor()).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        handler.handleException(rtx);
                    }
                    catch (Exception e) {
                        MessageChannelHandler.this.logger.error("Failed to handle exception response", e, new Object[0]);
                    }
                }
            });
        }
    }

    private String handleRequest(Channel channel, StreamInput buffer, long requestId, Version version) throws IOException {
        String action = buffer.readString();
        NettyTransportChannel transportChannel = new NettyTransportChannel(this.transport, action, channel, requestId, version);
        try {
            TransportRequestHandler handler = this.transportServiceAdapter.handler(action);
            if (handler == null) {
                throw new ActionNotFoundTransportException(action);
            }
            Object request = handler.newInstance();
            ((TransportRequest)request).readFrom(buffer);
            if (handler.executor() == "same") {
                handler.messageReceived(request, transportChannel);
            } else {
                this.threadPool.executor(handler.executor()).execute(new RequestHandler(handler, (TransportRequest)request, transportChannel, action));
            }
        }
        catch (Exception e) {
            try {
                transportChannel.sendResponse(e);
            }
            catch (IOException e1) {
                this.logger.warn("Failed to send error message back to client for action [" + action + "]", e, new Object[0]);
                this.logger.warn("Actual Exception", e1, new Object[0]);
            }
        }
        return action;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.transport.exceptionCaught(ctx, e);
    }

    class RequestHandler
    implements Runnable {
        private final TransportRequestHandler handler;
        private final TransportRequest request;
        private final NettyTransportChannel transportChannel;
        private final String action;

        public RequestHandler(TransportRequestHandler handler, TransportRequest request, NettyTransportChannel transportChannel, String action) {
            this.handler = handler;
            this.request = request;
            this.transportChannel = transportChannel;
            this.action = action;
        }

        @Override
        public void run() {
            block4: {
                try {
                    this.handler.messageReceived(this.request, this.transportChannel);
                }
                catch (Throwable e) {
                    if (MessageChannelHandler.this.transport.lifecycleState() != Lifecycle.State.STARTED) break block4;
                    try {
                        this.transportChannel.sendResponse(e);
                    }
                    catch (IOException e1) {
                        MessageChannelHandler.this.logger.warn("Failed to send error message back to client for action [" + this.action + "]", e1, new Object[0]);
                        MessageChannelHandler.this.logger.warn("Actual Exception", e, new Object[0]);
                    }
                }
            }
        }
    }

    class ResponseHandler
    implements Runnable {
        private final TransportResponseHandler handler;
        private final TransportResponse response;

        public ResponseHandler(TransportResponseHandler handler, TransportResponse response) {
            this.handler = handler;
            this.response = response;
        }

        @Override
        public void run() {
            try {
                this.handler.handleResponse(this.response);
            }
            catch (Exception e) {
                MessageChannelHandler.this.handleException(this.handler, new ResponseHandlerFailureTransportException(e));
            }
        }
    }
}

