/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.jmx.MBean;
import org.elasticsearch.jmx.ManagedAttribute;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.netty.NettyTransport;

@MBean(objectName="service=transport,transportType=netty", description="Netty Transport")
public class NettyTransportManagement {
    private final NettyTransport transport;

    @Inject
    public NettyTransportManagement(Transport transport) {
        this.transport = (NettyTransport)transport;
    }

    @ManagedAttribute(description="Number of connections this node has to other nodes")
    public long getNumberOfOutboundConnections() {
        return this.transport.connectedNodes.size();
    }

    @ManagedAttribute(description="Number if IO worker threads")
    public int getWorkerCount() {
        return this.transport.workerCount;
    }

    @ManagedAttribute(description="Port(s) netty was configured to bind on")
    public String getPort() {
        return this.transport.port;
    }

    @ManagedAttribute(description="Host to bind to")
    public String getBindHost() {
        return this.transport.bindHost;
    }

    @ManagedAttribute(description="Host to publish")
    public String getPublishHost() {
        return this.transport.publishHost;
    }

    @ManagedAttribute(description="Connect timeout")
    public String getConnectTimeout() {
        return this.transport.connectTimeout.toString();
    }

    @ManagedAttribute(description="TcpNoDelay")
    public Boolean getTcpNoDelay() {
        return this.transport.tcpNoDelay;
    }

    @ManagedAttribute(description="TcpKeepAlive")
    public Boolean getTcpKeepAlive() {
        return this.transport.tcpKeepAlive;
    }

    @ManagedAttribute(description="ReuseAddress")
    public Boolean getReuseAddress() {
        return this.transport.reuseAddress;
    }

    @ManagedAttribute(description="TcpSendBufferSize")
    public String getTcpSendBufferSize() {
        if (this.transport.tcpSendBufferSize == null) {
            return null;
        }
        return this.transport.tcpSendBufferSize.toString();
    }

    @ManagedAttribute(description="TcpReceiveBufferSize")
    public String getTcpReceiveBufferSize() {
        if (this.transport.tcpReceiveBufferSize == null) {
            return null;
        }
        return this.transport.tcpReceiveBufferSize.toString();
    }
}

