/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Object"}, include={"Kernel"})
public class RubyObject
extends RubyBasicObject {
    public static final ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyObject(runtime, klass);
        }
    };
    public static final ObjectAllocator REIFYING_OBJECT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            klass.reifyWithAncestors();
            return klass.allocate();
        }
    };

    public RubyObject(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public RubyObject(RubyClass metaClass) {
        super(metaClass);
    }

    @Deprecated
    protected RubyObject(Ruby runtime, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime, metaClass, useObjectSpace, canBeTainted);
    }

    protected RubyObject(Ruby runtime, RubyClass metaClass, boolean useObjectSpace) {
        super(runtime, metaClass, useObjectSpace);
    }

    public static RubyClass createObjectClass(Ruby runtime, RubyClass objectClass) {
        objectClass.index = 14;
        objectClass.setReifiedClass(RubyObject.class);
        objectClass.defineAnnotatedMethods(RubyObject.class);
        return objectClass;
    }

    @Override
    @Deprecated
    public IRubyObject initialize() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(ThreadContext context) {
        return context.nil;
    }

    public void attachToObjectSpace() {
        this.getRuntime().getObjectSpace().add(this);
    }

    @Override
    public int getNativeTypeIndex() {
        return 14;
    }

    public static void puts(Object obj) {
        System.out.println(obj.toString());
    }

    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && RuntimeHelpers.invokedynamic(this.getRuntime().getCurrentContext(), (IRubyObject)this, MethodNames.OP_EQUAL, (IRubyObject)other).isTrue();
    }

    public String toString() {
        RubyString rubyString = RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, "to_s").convertToString();
        return rubyString.getUnicodeValue();
    }

    public final void callInit(IRubyObject[] args2, Block block) {
        RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "initialize", args2, block);
    }

    public final void callInit(Block block) {
        RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "initialize", block);
    }

    public final void callInit(IRubyObject arg0, Block block) {
        RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "initialize", arg0, block);
    }

    public final void callInit(IRubyObject arg0, IRubyObject arg1, Block block) {
        RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "initialize", arg0, arg1, block);
    }

    public final void callInit(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, "initialize", arg0, arg1, arg2, block);
    }

    public final void callInit(ThreadContext context, IRubyObject[] args2, Block block) {
        this.getMetaClass().getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, args2, block);
    }

    public final void callInit(ThreadContext context, Block block) {
        this.getMetaClass().getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, block);
    }

    public final void callInit(ThreadContext context, IRubyObject arg0, Block block) {
        this.getMetaClass().getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, block);
    }

    public final void callInit(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        this.getMetaClass().getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, arg1, block);
    }

    public final void callInit(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        this.getMetaClass().getBaseCallSite(0).call(context, (IRubyObject)this, (IRubyObject)this, arg0, arg1, arg2, block);
    }

    @Deprecated
    public final IRubyObject convertToType(RubyClass target, int convertMethodIndex) {
        throw new RuntimeException("Not supported; use the String versions");
    }

    @Deprecated
    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject[] args2, Block block) {
        int line;
        String file2;
        if (block.isGiven()) {
            if (args2.length > 0) {
                throw this.getRuntime().newArgumentError(args2.length, 0);
            }
            return this.yieldUnder(context, mod, block);
        }
        if (args2.length == 0) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        if (args2.length > 3) {
            String lastFuncName = context.getFrameName();
            throw this.getRuntime().newArgumentError("wrong number of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        RubyString evalStr = args2[0] instanceof RubyString ? (RubyString)args2[0] : args2[0].convertToString();
        if (args2.length > 1) {
            file2 = args2[1].convertToString().asJavaString();
            line = args2.length > 2 ? (int)(args2[2].convertToInteger().getLongValue() - 1L) : 0;
        } else {
            file2 = "(eval)";
            line = 0;
        }
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    @Override
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.runtime.newBoolean(RubyObject.equalInternal(context, this, other));
    }

    protected static boolean equalInternal(ThreadContext context, IRubyObject a, IRubyObject b) {
        if (a == b) {
            return true;
        }
        if (a instanceof RubySymbol) {
            return false;
        }
        if (a instanceof RubyFixnum && b instanceof RubyFixnum) {
            return ((RubyFixnum)a).fastEqual((RubyFixnum)b);
        }
        if (a instanceof RubyFloat && b instanceof RubyFloat) {
            return ((RubyFloat)a).fastEqual((RubyFloat)b);
        }
        return RuntimeHelpers.invokedynamic(context, a, MethodNames.OP_EQUAL, b).isTrue();
    }

    protected static boolean eqlInternal(ThreadContext context, IRubyObject a, IRubyObject b) {
        if (a == b) {
            return true;
        }
        if (a instanceof RubySymbol) {
            return false;
        }
        if (a instanceof RubyNumeric) {
            if (a.getClass() != b.getClass()) {
                return false;
            }
            return RubyObject.equalInternal(context, a, b);
        }
        return RuntimeHelpers.invokedynamic(context, a, MethodNames.EQL, b).isTrue();
    }

    public int hashCode() {
        IRubyObject hashValue = RuntimeHelpers.invokedynamic(this.getRuntime().getCurrentContext(), (IRubyObject)this, MethodNames.HASH);
        if (hashValue instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return this.nonFixnumHashCode(hashValue);
    }

    private int nonFixnumHashCode(IRubyObject hashValue) {
        Ruby runtime = this.getRuntime();
        if (runtime.is1_9()) {
            RubyInteger integer = hashValue.convertToInteger();
            if (integer instanceof RubyBignum) {
                return integer.getBigIntegerValue().intValue();
            }
            return (int)integer.getLongValue();
        }
        if ((hashValue = hashValue.callMethod(runtime.getCurrentContext(), "%", RubyFixnum.newFixnum(runtime, 0x2000000BL))) instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return System.identityHashCode(hashValue);
    }

    public static RubyString inspect(ThreadContext context, IRubyObject object) {
        return RubyString.objAsString(context, object.callMethod(context, "inspect"));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        List<String> names2 = this.getInstanceVariableNameList();
        out.writeInt(names2.size());
        for (String name2 : names2) {
            out.writeObject(name2);
            out.writeObject(this.getInstanceVariables().getInstanceVariable(name2));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int ivarCount = in.readInt();
        for (int i2 = 0; i2 < ivarCount; ++i2) {
            this.setInstanceVariable((String)in.readObject(), (IRubyObject)in.readObject());
        }
    }

    public static class Data
    extends RubyObject
    implements DataType {
        public Data(Ruby runtime, RubyClass metaClass, Object data2) {
            super(runtime, metaClass);
            this.dataWrapStruct(data2);
        }

        public Data(RubyClass metaClass, Object data2) {
            super(metaClass);
            this.dataWrapStruct(data2);
        }
    }
}

