/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.DefinedMessage;

public class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private final Node receiverNode;
    private Node argsNode;
    protected Node iterNode;
    public CallSite callAdapter;

    @Deprecated
    public CallNode(ISourcePosition position, Node receiverNode, String name2, Node argsNode) {
        this(position, receiverNode, name2, argsNode, null);
    }

    public CallNode(ISourcePosition position, Node receiverNode, String name2, Node argsNode, Node iterNode) {
        super(position);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
        this.setArgsNode(argsNode);
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getCallSite(name2);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CALLNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getCallSite(this.callAdapter.methodName);
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        return argsNode;
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.iterNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        assert (false) : "No longer called";
        return null;
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value2, Block block, boolean checkArity) {
        IRubyObject receiver2 = this.receiverNode.interpret(runtime, context, self, block);
        if (this.argsNode == null) {
            RuntimeHelpers.invoke(context, receiver2, this.getName(), new IRubyObject[]{value2}, CallType.NORMAL, Block.NULL_BLOCK);
        } else {
            RubyArray args2 = (RubyArray)this.argsNode.interpret(runtime, context, self, block);
            args2.append(value2);
            RuntimeHelpers.invoke(context, receiver2, this.getName(), args2.toJavaArray(), CallType.NORMAL, Block.NULL_BLOCK);
        }
        return runtime.getNil();
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.receiverNode.definition(runtime, context, self, aBlock) != null) {
            try {
                IRubyObject receiver2 = this.receiverNode.interpret(runtime, context, self, aBlock);
                RubyClass metaClass = receiver2.getMetaClass();
                DynamicMethod method2 = metaClass.searchMethod(this.getName());
                Visibility visibility = method2.getVisibility();
                if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self)) && !method2.isUndefined()) {
                    return ASTInterpreter.getArgumentDefinition(runtime, context, this.getArgsNode(), context.runtime.getDefinedMessage(DefinedMessage.METHOD), self, aBlock);
                }
            }
            catch (JumpException excptn) {
                // empty catch block
            }
        }
        return null;
    }
}

