/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class ListNode
extends Node {
    private List<Node> list = new ArrayList<Node>(0);

    public ListNode(ISourcePosition position, Node firstNode) {
        this(position);
        this.list = new ArrayList<Node>(4);
        this.list.add(firstNode);
    }

    public ListNode(ISourcePosition position) {
        super(position);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LISTNODE;
    }

    public ListNode add(Node node) {
        if (node == null || node == NilImplicitNode.NIL) {
            this.list.add(NilImplicitNode.NIL);
            return this;
        }
        this.list.add(node);
        if (this.getPosition() == null) {
            this.setPosition(node.getPosition());
        }
        return this;
    }

    public ListNode prepend(Node node) {
        if (node == null) {
            return this;
        }
        this.list.add(0, node);
        this.setPosition(node.getPosition());
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public ListNode addAll(ListNode other) {
        if (other != null && other.size() > 0) {
            this.list.addAll(other.list);
            if (this.getPosition() == null) {
                this.setPosition(other.getPosition());
            }
        }
        return this;
    }

    public ListNode addAll(Node other) {
        return this.add(other);
    }

    public Node getLast() {
        return this.list.size() == 0 ? null : this.list.get(this.list.size() - 1);
    }

    @Override
    public List<Node> childNodes() {
        return this.list;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        throw new RuntimeException("Base class ListNode should never be evaluated");
    }

    public Node get(int idx) {
        return this.list.get(idx);
    }
}

