/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.atomic;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.unsafe.UnsafeGetter;
import sun.misc.Unsafe;

public class AtomicReferenceLibrary
implements Library {
    private static final ObjectAllocator JRUBYREFERENCE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            return new JRubyReference(runtime, klazz);
        }
    };
    private static final ObjectAllocator JRUBYREFERENCE8_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            return new JRubyReference8(runtime, klazz);
        }
    };

    public void load(Ruby runtime, boolean wrap2) throws IOException {
        RubyClass atomicCls = runtime.defineClass("Atomic", runtime.getObject(), JRUBYREFERENCE_ALLOCATOR);
        try {
            Unsafe.class.getMethod("getAndSetObject", Object.class);
            atomicCls.setAllocator(JRUBYREFERENCE8_ALLOCATOR);
        }
        catch (Exception e) {
            // empty catch block
        }
        atomicCls.defineAnnotatedMethods(JRubyReference.class);
    }

    public static class JRubyReference8
    extends JRubyReference {
        public JRubyReference8(Ruby runtime, RubyClass klass) {
            super(runtime, klass);
        }

        public IRubyObject get_and_set(ThreadContext context, IRubyObject newValue) {
            return (IRubyObject)UNSAFE.getAndSetObject(this, referenceOffset, newValue);
        }
    }

    @JRubyClass(name={"JRubyReference"}, parent="Object")
    public static class JRubyReference
    extends RubyObject {
        volatile IRubyObject reference;
        static final Unsafe UNSAFE;
        static final long referenceOffset;

        public JRubyReference(Ruby runtime, RubyClass klass) {
            super(runtime, klass);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context) {
            UNSAFE.putObject(this, referenceOffset, context.nil);
            return context.nil;
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context, IRubyObject value2) {
            UNSAFE.putObject(this, referenceOffset, value2);
            return context.nil;
        }

        @JRubyMethod(name={"get", "value"})
        public IRubyObject get() {
            return this.reference;
        }

        @JRubyMethod(name={"set", "value="})
        public IRubyObject set(IRubyObject newValue) {
            UNSAFE.putObjectVolatile(this, referenceOffset, newValue);
            return newValue;
        }

        @JRubyMethod(name={"compare_and_set", "compare_and_swap"})
        public IRubyObject compare_and_set(ThreadContext context, IRubyObject expectedValue, IRubyObject newValue) {
            Ruby runtime = context.runtime;
            if (expectedValue instanceof RubyNumeric) {
                return this.compareAndSetNumeric(context, expectedValue, newValue);
            }
            return runtime.newBoolean(UNSAFE.compareAndSwapObject(this, referenceOffset, expectedValue, newValue));
        }

        @JRubyMethod(name={"get_and_set", "swap"})
        public IRubyObject get_and_set(ThreadContext context, IRubyObject newValue) {
            IRubyObject oldValue;
            while (!UNSAFE.compareAndSwapObject(this, referenceOffset, oldValue = this.get(), newValue)) {
            }
            return oldValue;
        }

        private IRubyObject compareAndSetNumeric(ThreadContext context, IRubyObject expectedValue, IRubyObject newValue) {
            IRubyObject current2;
            boolean success2;
            Ruby runtime = context.runtime;
            do {
                if (!((current2 = this.reference) instanceof RubyNumeric)) {
                    return runtime.getFalse();
                }
                RubyNumeric currentNumber = (RubyNumeric)current2;
                if (currentNumber.equals(expectedValue)) continue;
                return runtime.getFalse();
            } while (!(success2 = UNSAFE.compareAndSwapObject(this, referenceOffset, current2, newValue)));
            return runtime.getTrue();
        }

        static {
            try {
                UNSAFE = UnsafeGetter.getUnsafe();
                Class<JRubyReference> k = JRubyReference.class;
                referenceOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("reference"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

