/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.delegate;

import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class Delegator {
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject initialize(ThreadContext context, IRubyObject self, IRubyObject obj) {
        return context.runtime.getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        IRubyObject[] newArgs;
        if (args2.length == 0) {
            newArgs = IRubyObject.NULL_ARRAY;
        } else {
            newArgs = new IRubyObject[args2.length - 1];
            System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
        }
        String methodName = args2[0].asJavaString();
        IRubyObject object = self.callMethod(context, "__getobj__");
        DynamicMethod method2 = ((RubyObject)object).getMetaClass().searchMethod(methodName);
        if (method2.getVisibility().isPrivate()) {
            throw context.runtime.newNoMethodError("method `" + methodName + "' is private", methodName, context.runtime.getNil());
        }
        return method2.call(context, object, (RubyModule)object.getMetaClass(), methodName, newArgs, block);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject send(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return ((RubyObject)self.callMethod(context, "__getobj__")).send(context, args2, block);
    }

    @JRubyMethod
    public static IRubyObject method(ThreadContext context, IRubyObject self, IRubyObject name2) {
        String methodName = name2.asJavaString();
        final IRubyObject object = self.callMethod(context, "__getobj__");
        if (!self.getMetaClass().searchMethod(methodName).isUndefined()) {
            return (RubyMethod)((RubyObject)self).method(name2);
        }
        final RubyMethod method2 = (RubyMethod)((RubyObject)object).method(name2);
        return RubyMethod.newMethod(self.getMetaClass(), methodName, self.getMetaClass(), methodName, new JavaMethod.JavaMethodNBlock((RubyModule)self.getMetaClass(), Visibility.PUBLIC){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                if (self.callMethod(context, "__getobj__") != object) {
                    throw context.runtime.newNameError("object changed", "object changed");
                }
                return method2.call(context, args2, block);
            }
        }, self);
    }

    @JRubyMethod(name={"respond_to?"})
    public static IRubyObject repond_to_p(ThreadContext context, IRubyObject self, IRubyObject name2) {
        if (self.getMetaClass().isMethodBound(name2.asJavaString(), false)) {
            return context.runtime.getTrue();
        }
        return ((RubyObject)self.callMethod(context, "__getobj__")).callMethod(context, "respond_to?", name2);
    }

    @JRubyMethod
    public static IRubyObject __getobj__(ThreadContext context, IRubyObject self) {
        throw context.runtime.newNotImplementedError("need to define `__getobj__'");
    }

    @JRubyMethod
    public static IRubyObject marshal_dump(ThreadContext context, IRubyObject self) {
        return (RubyObject)self.callMethod(context, "__getobj__");
    }

    @JRubyMethod
    public static IRubyObject marshal_load(ThreadContext context, IRubyObject self, IRubyObject obj) {
        return self.callMethod(context, "__setobj__", obj);
    }
}

