/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.util.ByteList;

public class EncContent {
    private int contentType;
    private CipherSpec cipher;
    private AlgorithmIdentifier algorithm;
    private ASN1OctetString encData;

    public final int getContentType() {
        return this.contentType;
    }

    public final void setContentType(int newContentType) {
        this.contentType = newContentType;
    }

    public final CipherSpec getCipher() {
        return this.cipher;
    }

    public final void setCipher(CipherSpec newCipher) {
        this.cipher = newCipher;
    }

    public final AlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    public final void setAlgorithm(AlgorithmIdentifier newAlgorithm) {
        this.algorithm = newAlgorithm;
    }

    public final ASN1OctetString getEncData() {
        return this.encData;
    }

    public final void setEncData(ASN1OctetString newEncData) {
        this.encData = newEncData;
    }

    public String toString() {
        return "#<EncContent contentType=" + this.contentType + " algorithm=" + (this.algorithm == null ? "null" : ASN1Registry.o2a(this.algorithm.getAlgorithm())) + " content=" + this.encData + ">";
    }

    public static EncContent fromASN1(ASN1Encodable content) {
        ASN1Sequence sequence = (ASN1Sequence)content;
        ASN1ObjectIdentifier contentType = (ASN1ObjectIdentifier)sequence.getObjectAt(0);
        int nid = ASN1Registry.obj2nid(contentType);
        EncContent ec = new EncContent();
        ec.setContentType(nid);
        ec.setAlgorithm(AlgorithmIdentifier.getInstance(sequence.getObjectAt(1)));
        if (sequence.size() > 2 && sequence.getObjectAt(2) instanceof ASN1TaggedObject && ((ASN1TaggedObject)sequence.getObjectAt(2)).getTagNo() == 0) {
            ASN1Primitive ee = ((ASN1TaggedObject)sequence.getObjectAt(2)).getObject();
            if (ee instanceof ASN1Sequence && ((ASN1Sequence)ee).size() > 0) {
                ByteList combinedOctets = new ByteList();
                Enumeration enm = ((ASN1Sequence)ee).getObjects();
                while (enm.hasMoreElements()) {
                    byte[] octets = ((ASN1OctetString)enm.nextElement()).getOctets();
                    combinedOctets.append(octets);
                }
                ec.setEncData(new DEROctetString(combinedOctets.bytes()));
            } else {
                ec.setEncData((ASN1OctetString)ee);
            }
        }
        return ec;
    }

    public ASN1Encodable asASN1() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(ASN1Registry.nid2obj(this.contentType).toASN1Primitive());
        vector.add(this.algorithm.toASN1Primitive());
        if (this.encData != null) {
            vector.add(new DERTaggedObject(false, 0, this.encData));
        }
        return new DLSequence(vector);
    }
}

