/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import org.jruby.ext.openssl.impl.BIO;

public class MemBIO
extends BIO {
    private byte[] buffer = new byte[1024];
    private int wpointer = 0;
    private int rpointer = 0;
    private int slen = 0;

    private void realloc() {
        byte[] newBuffer = new byte[this.buffer.length * 2];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.wpointer);
        this.buffer = newBuffer;
    }

    public int gets(byte[] in, int len) throws IOException {
        if (this.rpointer == this.slen) {
            return 0;
        }
        int i2 = 0;
        while (i2 < len && this.rpointer < this.slen) {
            in[i2] = this.buffer[this.rpointer];
            if (in[i2] == 10) {
                ++i2;
                ++this.rpointer;
                break;
            }
            ++i2;
            ++this.rpointer;
        }
        return i2;
    }

    public int read(byte[] in, int index2, int len) throws IOException {
        if (this.rpointer == this.slen) {
            return 0;
        }
        int toRead = Math.min(len, this.slen - this.rpointer);
        System.arraycopy(this.buffer, this.rpointer, in, index2, toRead);
        this.rpointer += toRead;
        return toRead;
    }

    public int write(byte[] out, int offset2, int len) throws IOException {
        while (this.wpointer + len > this.buffer.length) {
            this.realloc();
        }
        System.arraycopy(out, offset2, this.buffer, this.wpointer, len);
        this.wpointer += len;
        this.slen += len;
        return len;
    }

    public String toString() {
        try {
            return "<MemBIO w:" + this.wpointer + " r:" + this.rpointer + " buf:\"" + new String(this.buffer, this.rpointer, this.slen - this.rpointer) + "\" next=" + this.next() + ">";
        }
        catch (Exception exception2) {
            return null;
        }
    }

    public void setMemEofReturn(int value2) {
    }

    public int getType() {
        return 1025;
    }

    public byte[] getMemCopy() {
        byte[] nbuf = new byte[this.slen];
        System.arraycopy(this.buffer, 0, nbuf, 0, this.slen);
        return nbuf;
    }

    public void reset() {
        this.rpointer = 0;
    }
}

