/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.Certificate;
import org.jruby.ext.openssl.x509store.X509Aux;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509AuxCertificate
extends X509Certificate {
    private static final long serialVersionUID = -909543379295427515L;
    private final X509Certificate wrap;
    private final X509Aux aux;
    private boolean valid = false;
    private int ex_flags = 0;
    private static final String NS_CERT_TYPE_OID = "2.16.840.1.113730.1.1";

    public X509AuxCertificate(Certificate wrap2) throws IOException, CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bis = new ByteArrayInputStream(wrap2.getEncoded());
        this.wrap = (X509Certificate)cf.generateCertificate(bis);
        this.aux = null;
    }

    public X509AuxCertificate(X509Certificate wrap2) {
        this(wrap2, null);
    }

    public X509AuxCertificate(X509Certificate wrap2, X509Aux aux) {
        this.wrap = wrap2;
        this.aux = aux;
    }

    public X509Aux getAux() {
        return this.aux;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean v) {
        this.valid = v;
    }

    public int getExFlags() {
        return this.ex_flags;
    }

    public void setExFlags(int ex_flags) {
        this.ex_flags = ex_flags;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.wrap.checkValidity();
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.wrap.checkValidity(date);
    }

    @Override
    public int getBasicConstraints() {
        return this.wrap.getBasicConstraints();
    }

    @Override
    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        return this.wrap.getExtendedKeyUsage();
    }

    @Override
    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        return this.wrap.getIssuerAlternativeNames();
    }

    @Override
    public Principal getIssuerDN() {
        return this.wrap.getIssuerDN();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return this.wrap.getIssuerUniqueID();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.wrap.getIssuerX500Principal();
    }

    @Override
    public boolean[] getKeyUsage() {
        return this.wrap.getKeyUsage();
    }

    @Override
    public Date getNotAfter() {
        return this.wrap.getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.wrap.getNotBefore();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.wrap.getSerialNumber();
    }

    @Override
    public String getSigAlgName() {
        return this.wrap.getSigAlgName();
    }

    @Override
    public String getSigAlgOID() {
        return this.wrap.getSigAlgOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.wrap.getSigAlgParams();
    }

    @Override
    public byte[] getSignature() {
        return this.wrap.getSignature();
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        return this.wrap.getSubjectAlternativeNames();
    }

    @Override
    public Principal getSubjectDN() {
        return this.wrap.getSubjectDN();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return this.wrap.getSubjectUniqueID();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.wrap.getSubjectX500Principal();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.wrap.getTBSCertificate();
    }

    @Override
    public int getVersion() {
        return this.wrap.getVersion();
    }

    @Override
    public boolean equals(Object other) {
        boolean ret;
        boolean bl = ret = this == other;
        if (!ret && other instanceof X509AuxCertificate) {
            X509AuxCertificate o = (X509AuxCertificate)other;
            ret = this.wrap.equals(o.wrap) && (this.aux == null ? o.aux == null : this.aux.equals(o.aux));
        }
        return ret;
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.wrap.getEncoded();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.wrap.getPublicKey();
    }

    @Override
    public int hashCode() {
        int ret = this.wrap.hashCode();
        return ret += 3 * (this.aux == null ? 1 : this.aux.hashCode());
    }

    @Override
    public String toString() {
        return this.wrap.toString();
    }

    @Override
    public void verify(PublicKey key2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.wrap.verify(key2);
    }

    @Override
    public void verify(PublicKey key2, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.wrap.verify(key2, sigProvider);
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.wrap.getCriticalExtensionOIDs();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return this.wrap.getExtensionValue(oid);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.wrap.getNonCriticalExtensionOIDs();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.wrap.hasUnsupportedCriticalExtension();
    }

    public Integer getNsCertType() throws CertificateException {
        byte[] bytes2 = this.getExtensionValue(NS_CERT_TYPE_OID);
        if (bytes2 == null) {
            return null;
        }
        try {
            ASN1Primitive o = new ASN1InputStream(bytes2).readObject();
            if (o instanceof DERBitString) {
                return ((DERBitString)o).intValue();
            }
            if (o instanceof DEROctetString) {
                ASN1InputStream in = new ASN1InputStream(((DEROctetString)o).getOctets());
                o = in.readObject();
                return ((DERBitString)o).intValue();
            }
            throw new CertificateException("unknown type from ASN1InputStream.readObject: " + o);
        }
        catch (IOException ioe) {
            throw new CertificateEncodingException(ioe.getMessage(), ioe);
        }
    }
}

