/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.GetInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class GetFieldInstr
extends GetInstr {
    private RubyClass.VariableAccessor accessor = RubyClass.VariableAccessor.DUMMY_ACCESSOR;

    public GetFieldInstr(Variable dest, Operand obj, String fieldName) {
        super(Operation.GET_FIELD, dest, obj, fieldName);
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new GetFieldInstr(ii.getRenamedVariable(this.getResult()), this.getSource().cloneForInlining(ii), this.getRef());
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        IRubyObject value2;
        Ruby runtime = context.runtime;
        IRubyObject object = (IRubyObject)this.getSource().retrieve(context, self, currDynScope, temp);
        RubyClass cls = object.getMetaClass().getRealClass();
        RubyClass.VariableAccessor localAccessor = this.accessor;
        if (localAccessor.getClassId() != cls.hashCode()) {
            localAccessor = cls.getVariableAccessorForRead(this.getRef());
            if (localAccessor == null) {
                return runtime.getNil();
            }
            value2 = (IRubyObject)localAccessor.get(object);
            this.accessor = localAccessor;
        } else {
            value2 = (IRubyObject)localAccessor.get(object);
        }
        return value2 == null ? runtime.getNil() : value2;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.GetFieldInstr(this);
    }
}

