/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.defined;

import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.defined.DefinedInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SuperMethodBoundInstr
extends DefinedInstr {
    public SuperMethodBoundInstr(Variable result2, Operand object) {
        super(Operation.SUPER_METHOD_BOUND, result2, new Operand[]{object});
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.operands[0] = this.operands[0].getSimplifiedOperand(valueMap, force);
    }

    public Operand getObject() {
        return this.operands[0];
    }

    @Override
    public Instr cloneForInlining(InlinerInfo inlinerInfo) {
        return new SuperMethodBoundInstr((Variable)this.getResult().cloneForInlining(inlinerInfo), this.getObject().cloneForInlining(inlinerInfo));
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getObject() + ")";
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        RubyModule frameClass;
        IRubyObject receiver2 = (IRubyObject)this.getObject().retrieve(context, self, currDynScope, temp);
        boolean flag = false;
        String frameName = context.getFrameName();
        if (frameName != null && (frameClass = context.getFrameKlazz()) != null) {
            flag = RuntimeHelpers.findImplementerIfNecessary(receiver2.getMetaClass(), frameClass).getSuperClass().isMethodBound(frameName, false);
        }
        return context.runtime.newBoolean(flag);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SuperMethodBoundInstr(this);
    }
}

