/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.BufferPacker;
import org.msgpack.packer.MessagePackBufferPacker;
import org.msgpack.packer.MessagePackPacker;
import org.msgpack.packer.Packer;
import org.msgpack.packer.Unconverter;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.type.Value;
import org.msgpack.unpacker.BufferUnpacker;
import org.msgpack.unpacker.Converter;
import org.msgpack.unpacker.MessagePackBufferUnpacker;
import org.msgpack.unpacker.MessagePackUnpacker;
import org.msgpack.unpacker.Unpacker;

public class MessagePack {
    private TemplateRegistry registry;
    private static final MessagePack globalMessagePack = new MessagePack();

    public MessagePack() {
        this.registry = new TemplateRegistry(null);
    }

    public MessagePack(MessagePack msgpack) {
        this.registry = new TemplateRegistry(msgpack.registry);
    }

    protected MessagePack(TemplateRegistry registry) {
        this.registry = registry;
    }

    public void setClassLoader(ClassLoader cl) {
        this.registry.setClassLoader(cl);
    }

    public Packer createPacker(OutputStream out) {
        return new MessagePackPacker(this, out);
    }

    public BufferPacker createBufferPacker() {
        return new MessagePackBufferPacker(this);
    }

    public BufferPacker createBufferPacker(int bufferSize) {
        return new MessagePackBufferPacker(this, bufferSize);
    }

    public Unpacker createUnpacker(InputStream in) {
        return new MessagePackUnpacker(this, in);
    }

    public BufferUnpacker createBufferUnpacker() {
        return new MessagePackBufferUnpacker(this);
    }

    public BufferUnpacker createBufferUnpacker(byte[] bytes2) {
        return this.createBufferUnpacker().wrap(bytes2);
    }

    public BufferUnpacker createBufferUnpacker(byte[] bytes2, int off, int len) {
        return this.createBufferUnpacker().wrap(bytes2, off, len);
    }

    public BufferUnpacker createBufferUnpacker(ByteBuffer buffer) {
        return this.createBufferUnpacker().wrap(buffer);
    }

    public <T> byte[] write(T v) throws IOException {
        BufferPacker pk = this.createBufferPacker();
        if (v == null) {
            pk.writeNil();
        } else {
            Template tmpl = this.registry.lookup(v.getClass());
            tmpl.write(pk, v);
        }
        return pk.toByteArray();
    }

    public <T> byte[] write(T v, Template<T> template) throws IOException {
        BufferPacker pk = this.createBufferPacker();
        template.write(pk, v);
        return pk.toByteArray();
    }

    public <T> void write(OutputStream out, T v) throws IOException {
        Packer pk = this.createPacker(out);
        if (v == null) {
            pk.writeNil();
        } else {
            Template tmpl = this.registry.lookup(v.getClass());
            tmpl.write(pk, v);
        }
    }

    public <T> void write(OutputStream out, T v, Template<T> template) throws IOException {
        Packer pk = this.createPacker(out);
        template.write(pk, v);
    }

    public byte[] write(Value v) throws IOException {
        BufferPacker pk = this.createBufferPacker();
        pk.write(v);
        return pk.toByteArray();
    }

    public Value read(byte[] bytes2) throws IOException {
        return this.read(bytes2, 0, bytes2.length);
    }

    public Value read(byte[] bytes2, int off, int len) throws IOException {
        return this.createBufferUnpacker(bytes2, off, len).readValue();
    }

    public Value read(ByteBuffer buffer) throws IOException {
        return this.createBufferUnpacker(buffer).readValue();
    }

    public Value read(InputStream in) throws IOException {
        return this.createUnpacker(in).readValue();
    }

    public <T> T read(byte[] bytes2, T v) throws IOException {
        Template tmpl = this.registry.lookup(v.getClass());
        return this.read(bytes2, v, tmpl);
    }

    public <T> T read(byte[] bytes2, Template<T> tmpl) throws IOException {
        return this.read(bytes2, null, tmpl);
    }

    public <T> T read(byte[] bytes2, Class<T> c) throws IOException {
        Template tmpl = this.registry.lookup(c);
        return this.read(bytes2, null, tmpl);
    }

    public <T> T read(byte[] bytes2, T v, Template<T> tmpl) throws IOException {
        BufferUnpacker u = this.createBufferUnpacker(bytes2);
        return tmpl.read(u, v);
    }

    public <T> T read(ByteBuffer b, T v) throws IOException {
        Template tmpl = this.registry.lookup(v.getClass());
        return this.read(b, v, tmpl);
    }

    public <T> T read(ByteBuffer b, Template<T> tmpl) throws IOException {
        return this.read(b, null, tmpl);
    }

    public <T> T read(ByteBuffer b, Class<T> c) throws IOException {
        Template tmpl = this.registry.lookup(c);
        return this.read(b, null, tmpl);
    }

    public <T> T read(ByteBuffer b, T v, Template<T> tmpl) throws IOException {
        BufferUnpacker u = this.createBufferUnpacker(b);
        return tmpl.read(u, v);
    }

    public <T> T read(InputStream in, T v) throws IOException {
        Template tmpl = this.registry.lookup(v.getClass());
        return this.read(in, v, tmpl);
    }

    public <T> T read(InputStream in, Template<T> tmpl) throws IOException {
        return this.read(in, null, tmpl);
    }

    public <T> T read(InputStream in, Class<T> c) throws IOException {
        Template tmpl = this.registry.lookup(c);
        return this.read(in, null, tmpl);
    }

    public <T> T read(InputStream in, T v, Template<T> tmpl) throws IOException {
        Unpacker u = this.createUnpacker(in);
        return tmpl.read(u, v);
    }

    public <T> T convert(Value v, T to) throws IOException {
        Template tmpl = this.registry.lookup(to.getClass());
        return tmpl.read(new Converter(this, v), to);
    }

    public <T> T convert(Value v, Class<T> c) throws IOException {
        Template tmpl = this.registry.lookup(c);
        return tmpl.read(new Converter(this, v), null);
    }

    public <T> Value unconvert(T v) throws IOException {
        Unconverter pk = new Unconverter(this);
        if (v == null) {
            pk.writeNil();
        } else {
            Template tmpl = this.registry.lookup(v.getClass());
            tmpl.write(pk, v);
        }
        return pk.getResult();
    }

    public void register(Class<?> type2) {
        this.registry.register(type2);
    }

    public <T> void register(Class<T> type2, Template<T> template) {
        this.registry.register(type2, template);
    }

    public boolean unregister(Class<?> type2) {
        return this.registry.unregister(type2);
    }

    public void unregister() {
        this.registry.unregister();
    }

    public <T> Template<T> lookup(Class<T> type2) {
        return this.registry.lookup(type2);
    }

    public Template<?> lookup(Type type2) {
        return this.registry.lookup(type2);
    }

    @Deprecated
    public static byte[] pack(Object v) throws IOException {
        return globalMessagePack.write(v);
    }

    @Deprecated
    public static void pack(OutputStream out, Object v) throws IOException {
        globalMessagePack.write(out, v);
    }

    @Deprecated
    public static <T> byte[] pack(T v, Template<T> template) throws IOException {
        return globalMessagePack.write(v, template);
    }

    @Deprecated
    public static <T> void pack(OutputStream out, T v, Template<T> template) throws IOException {
        globalMessagePack.write(out, v, template);
    }

    @Deprecated
    public static Value unpack(byte[] bytes2) throws IOException {
        return globalMessagePack.read(bytes2);
    }

    @Deprecated
    public static <T> T unpack(byte[] bytes2, Template<T> template) throws IOException {
        MessagePackBufferUnpacker u = new MessagePackBufferUnpacker(globalMessagePack).wrap(bytes2);
        return template.read(u, null);
    }

    @Deprecated
    public static <T> T unpack(byte[] bytes2, Template<T> template, T to) throws IOException {
        MessagePackBufferUnpacker u = new MessagePackBufferUnpacker(globalMessagePack).wrap(bytes2);
        return template.read(u, to);
    }

    @Deprecated
    public static <T> T unpack(byte[] bytes2, Class<T> klass) throws IOException {
        return globalMessagePack.read(bytes2, klass);
    }

    @Deprecated
    public static <T> T unpack(byte[] bytes2, T to) throws IOException {
        return globalMessagePack.read(bytes2, to);
    }

    @Deprecated
    public static Value unpack(InputStream in) throws IOException {
        return globalMessagePack.read(in);
    }

    @Deprecated
    public static <T> T unpack(InputStream in, Template<T> tmpl) throws IOException, MessageTypeException {
        return tmpl.read(new MessagePackUnpacker(globalMessagePack, in), null);
    }

    @Deprecated
    public static <T> T unpack(InputStream in, Template<T> tmpl, T to) throws IOException, MessageTypeException {
        return tmpl.read(new MessagePackUnpacker(globalMessagePack, in), to);
    }

    @Deprecated
    public static <T> T unpack(InputStream in, Class<T> klass) throws IOException {
        return globalMessagePack.read(in, klass);
    }

    @Deprecated
    public static <T> T unpack(InputStream in, T to) throws IOException {
        return globalMessagePack.read(in, to);
    }
}

