/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyStringIO;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.IOInputStream;
import org.msgpack.MessagePack;
import org.msgpack.jruby.RubyObjectPacker;
import org.msgpack.jruby.RubyObjectUnpacker;
import org.msgpack.type.Value;
import org.msgpack.unpacker.MessagePackBufferUnpacker;
import org.msgpack.unpacker.MessagePackUnpacker;
import org.msgpack.unpacker.UnpackerIterator;

public class MessagePackLibrary
implements Library {
    @Override
    public void load(Ruby ruby2, boolean bl) throws IOException {
        MessagePack messagePack = new MessagePack();
        RubyModule rubyModule = ruby2.defineModule("MessagePack");
        rubyModule.defineAnnotatedMethods(MessagePackModule.class);
        RubyClass rubyClass = ruby2.getStandardError();
        RubyClass rubyClass2 = rubyModule.defineClassUnder("UnpackError", rubyClass, rubyClass.getAllocator());
        RubyClass rubyClass3 = rubyModule.defineClassUnder("Unpacker", ruby2.getObject(), new UnpackerAllocator(messagePack));
        rubyClass3.defineAnnotatedMethods(Unpacker.class);
    }

    @JRubyClass(name={"MessagePack::Unpacker"})
    public static class Unpacker
    extends RubyObject {
        private MessagePack msgPack;
        private RubyObjectUnpacker rubyObjectUnpacker;
        private MessagePackBufferUnpacker bufferUnpacker;
        private MessagePackUnpacker streamUnpacker;
        private UnpackerIterator unpackerIterator;
        private IRubyObject stream;
        private IRubyObject data;
        private RubyObjectUnpacker.CompiledOptions options;

        public Unpacker(Ruby ruby2, RubyClass rubyClass, MessagePack messagePack) {
            super(ruby2, rubyClass);
            this.msgPack = messagePack;
            this.rubyObjectUnpacker = new RubyObjectUnpacker(messagePack);
            this.bufferUnpacker = null;
            this.streamUnpacker = null;
            this.stream = null;
            this.data = null;
        }

        @JRubyMethod(name={"initialize"}, optional=2, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
            if (iRubyObjectArray.length == 0) {
                this.options = new RubyObjectUnpacker.CompiledOptions();
            } else if (iRubyObjectArray.length == 1 && iRubyObjectArray[0] instanceof RubyHash) {
                this.options = new RubyObjectUnpacker.CompiledOptions((RubyHash)iRubyObjectArray[0]);
            } else if (iRubyObjectArray.length > 0) {
                this.setStream(threadContext, iRubyObjectArray[0]);
                this.options = iRubyObjectArray.length > 2 ? new RubyObjectUnpacker.CompiledOptions((RubyHash)iRubyObjectArray[1]) : new RubyObjectUnpacker.CompiledOptions();
            }
            return this;
        }

        @JRubyMethod(required=2)
        public IRubyObject execute(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return this.executeLimit(threadContext, iRubyObject, iRubyObject2, null);
        }

        @JRubyMethod(name={"execute_limit"}, required=3)
        public IRubyObject executeLimit(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            this.data = null;
            try {
                int n = RubyNumeric.fix2int(iRubyObject2);
                int n2 = -1;
                if (iRubyObject3 != null) {
                    n2 = RubyNumeric.fix2int(iRubyObject3);
                }
                byte[] byArray = iRubyObject.asString().getBytes();
                MessagePackBufferUnpacker messagePackBufferUnpacker = new MessagePackBufferUnpacker(this.msgPack, byArray.length);
                messagePackBufferUnpacker.wrap(byArray, n, n2 == -1 ? byArray.length - n : n2);
                this.data = this.rubyObjectUnpacker.valueToRubyObject(threadContext.getRuntime(), messagePackBufferUnpacker.readValue(), this.options);
                return threadContext.getRuntime().newFixnum(n + messagePackBufferUnpacker.getReadByteCount());
            }
            catch (IOException iOException) {
                return threadContext.getRuntime().getNil();
            }
        }

        @JRubyMethod(name={"data"})
        public IRubyObject getData(ThreadContext threadContext) {
            if (this.data == null) {
                return threadContext.getRuntime().getNil();
            }
            return this.data;
        }

        @JRubyMethod(name={"finished?"})
        public IRubyObject finished_q(ThreadContext threadContext) {
            return this.data == null ? threadContext.getRuntime().getFalse() : threadContext.getRuntime().getTrue();
        }

        @JRubyMethod(required=1)
        public IRubyObject feed(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.streamUnpacker = null;
            byte[] byArray = iRubyObject.asString().getBytes();
            if (this.bufferUnpacker == null) {
                this.bufferUnpacker = new MessagePackBufferUnpacker(this.msgPack);
                this.unpackerIterator = this.bufferUnpacker.iterator();
            }
            this.bufferUnpacker.feed(byArray);
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod(name={"feed_each"}, required=1)
        public IRubyObject feedEach(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
            this.feed(threadContext, iRubyObject);
            this.each(threadContext, block);
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod
        public IRubyObject each(ThreadContext threadContext, Block block) {
            MessagePackUnpacker messagePackUnpacker = null;
            if (this.bufferUnpacker == null && this.streamUnpacker != null) {
                messagePackUnpacker = this.streamUnpacker;
            } else if (this.bufferUnpacker != null) {
                messagePackUnpacker = this.bufferUnpacker;
            } else {
                return threadContext.getRuntime().getNil();
            }
            if (block.isGiven()) {
                while (this.unpackerIterator.hasNext()) {
                    Value value2 = this.unpackerIterator.next();
                    IRubyObject iRubyObject = this.rubyObjectUnpacker.valueToRubyObject(threadContext.getRuntime(), value2, this.options);
                    block.yield(threadContext, iRubyObject);
                }
                return threadContext.getRuntime().getNil();
            }
            return RubyEnumerator.RubyEnumeratorKernel.obj_to_enum(threadContext, this);
        }

        @JRubyMethod
        public IRubyObject fill(ThreadContext threadContext) {
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod
        public IRubyObject reset(ThreadContext threadContext) {
            if (this.bufferUnpacker != null) {
                this.bufferUnpacker.reset();
            }
            if (this.streamUnpacker != null) {
                this.streamUnpacker.reset();
            }
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod(name={"stream"})
        public IRubyObject getStream(ThreadContext threadContext) {
            if (this.stream == null) {
                return threadContext.getRuntime().getNil();
            }
            return this.stream;
        }

        @JRubyMethod(name={"stream="}, required=1)
        public IRubyObject setStream(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.bufferUnpacker = null;
            this.stream = iRubyObject;
            if (iRubyObject instanceof RubyStringIO) {
                IRubyObject iRubyObject2 = ((RubyStringIO)iRubyObject).string();
                byte[] byArray = ((RubyString)iRubyObject2).getBytes();
                this.streamUnpacker = new MessagePackUnpacker(this.msgPack, new ByteArrayInputStream(byArray));
            } else {
                this.streamUnpacker = new MessagePackUnpacker(this.msgPack, new IOInputStream(iRubyObject));
            }
            this.unpackerIterator = this.streamUnpacker.iterator();
            return this.getStream(threadContext);
        }
    }

    private static class UnpackerAllocator
    implements ObjectAllocator {
        private MessagePack msgPack;

        public UnpackerAllocator(MessagePack messagePack) {
            this.msgPack = messagePack;
        }

        @Override
        public IRubyObject allocate(Ruby ruby2, RubyClass rubyClass) {
            return new Unpacker(ruby2, rubyClass, this.msgPack);
        }
    }

    @JRubyModule(name={"MessagePack"})
    public static class MessagePackModule {
        private static MessagePack msgPack = new MessagePack();
        private static RubyObjectPacker packer = new RubyObjectPacker(msgPack);
        private static RubyObjectUnpacker unpacker = new RubyObjectUnpacker(msgPack);

        @JRubyMethod(module=true, required=1)
        public static IRubyObject pack(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) throws IOException {
            return packer.pack(iRubyObject2);
        }

        @JRubyMethod(module=true, required=1, optional=1)
        public static IRubyObject unpack(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) throws IOException {
            RubyHash rubyHash = iRubyObjectArray.length == 2 ? (RubyHash)iRubyObjectArray[1] : null;
            RubyString rubyString = iRubyObjectArray[0].asString();
            return unpacker.unpack(rubyString, rubyHash);
        }
    }
}

