/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.io.IOException;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.msgpack.MessagePack;
import org.msgpack.packer.BufferPacker;

public class RubyObjectPacker {
    private final MessagePack msgPack;

    public RubyObjectPacker(MessagePack messagePack) {
        this.msgPack = messagePack;
    }

    public RubyString pack(IRubyObject iRubyObject) throws IOException {
        return RubyString.newString(iRubyObject.getRuntime(), this.packRaw(iRubyObject));
    }

    public byte[] packRaw(IRubyObject iRubyObject) throws IOException {
        BufferPacker bufferPacker = this.msgPack.createBufferPacker();
        this.write(bufferPacker, iRubyObject);
        return bufferPacker.toByteArray();
    }

    private void write(BufferPacker bufferPacker, IRubyObject iRubyObject) throws IOException {
        if (iRubyObject == null || iRubyObject instanceof RubyNil) {
            bufferPacker.writeNil();
        } else if (iRubyObject instanceof RubyBoolean) {
            bufferPacker.write(((RubyBoolean)iRubyObject).isTrue());
        } else if (iRubyObject instanceof RubyBignum) {
            this.write(bufferPacker, (RubyBignum)iRubyObject);
        } else if (iRubyObject instanceof RubyInteger) {
            this.write(bufferPacker, (RubyInteger)iRubyObject);
        } else if (iRubyObject instanceof RubyFixnum) {
            this.write(bufferPacker, (RubyFixnum)iRubyObject);
        } else if (iRubyObject instanceof RubyFloat) {
            this.write(bufferPacker, (RubyFloat)iRubyObject);
        } else if (iRubyObject instanceof RubyString) {
            this.write(bufferPacker, (RubyString)iRubyObject);
        } else if (iRubyObject instanceof RubySymbol) {
            this.write(bufferPacker, (RubySymbol)iRubyObject);
        } else if (iRubyObject instanceof RubyArray) {
            this.write(bufferPacker, (RubyArray)iRubyObject);
        } else if (iRubyObject instanceof RubyHash) {
            this.write(bufferPacker, (RubyHash)iRubyObject);
        } else {
            throw iRubyObject.getRuntime().newArgumentError(String.format("Cannot pack type: %s", iRubyObject.getClass().getName()));
        }
    }

    private void write(BufferPacker bufferPacker, RubyBignum rubyBignum) throws IOException {
        bufferPacker.write(rubyBignum.getBigIntegerValue());
    }

    private void write(BufferPacker bufferPacker, RubyInteger rubyInteger) throws IOException {
        bufferPacker.write(rubyInteger.getLongValue());
    }

    private void write(BufferPacker bufferPacker, RubyFixnum rubyFixnum) throws IOException {
        bufferPacker.write(rubyFixnum.getLongValue());
    }

    private void write(BufferPacker bufferPacker, RubyFloat rubyFloat) throws IOException {
        bufferPacker.write(rubyFloat.getDoubleValue());
    }

    private void write(BufferPacker bufferPacker, RubyString rubyString) throws IOException {
        bufferPacker.write(rubyString.getBytes());
    }

    private void write(BufferPacker bufferPacker, RubySymbol rubySymbol) throws IOException {
        this.write(bufferPacker, (RubyString)rubySymbol.to_s());
    }

    private void write(BufferPacker bufferPacker, RubyArray rubyArray) throws IOException {
        int n = rubyArray.size();
        bufferPacker.writeArrayBegin(n);
        for (int j = 0; j < n; ++j) {
            this.write(bufferPacker, (RubyObject)rubyArray.entry(j));
        }
        bufferPacker.writeArrayEnd();
    }

    private void write(BufferPacker bufferPacker, RubyHash rubyHash) throws IOException {
        int n = rubyHash.size();
        bufferPacker.writeMapBegin(n);
        RubyArray rubyArray = rubyHash.keys();
        RubyArray rubyArray2 = rubyHash.rb_values();
        for (int j = 0; j < n; ++j) {
            this.write(bufferPacker, (RubyObject)rubyArray.entry(j));
            this.write(bufferPacker, (RubyObject)rubyArray2.entry(j));
        }
        bufferPacker.writeMapEnd();
    }
}

