/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.packer;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.AbstractPacker;
import org.msgpack.packer.Packer;
import org.msgpack.packer.PackerStack;
import org.msgpack.type.Value;
import org.msgpack.type.ValueFactory;

public class Unconverter
extends AbstractPacker {
    private PackerStack stack = new PackerStack();
    private Object[] values = new Object[128];
    private Value result;

    public Unconverter() {
        this(new MessagePack());
    }

    public Unconverter(MessagePack msgpack) {
        super(msgpack);
    }

    public Value getResult() {
        return this.result;
    }

    public void resetResult() {
        this.result = null;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.put(ValueFactory.createBooleanValue(v));
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.put(ValueFactory.createIntegerValue(v));
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.put(ValueFactory.createIntegerValue(v));
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.put(ValueFactory.createIntegerValue(v));
    }

    @Override
    public void writeBigInteger(BigInteger v) throws IOException {
        this.put(ValueFactory.createIntegerValue(v));
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.put(ValueFactory.createIntegerValue(v));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.put(ValueFactory.createFloatValue(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.put(ValueFactory.createFloatValue(v));
    }

    @Override
    public void writeByteArray(byte[] b, int off, int len) throws IOException {
        this.put(ValueFactory.createRawValue(b, off, len));
    }

    @Override
    public void writeByteBuffer(ByteBuffer bb) throws IOException {
        this.put(ValueFactory.createRawValue(bb));
    }

    @Override
    public void writeString(String s2) throws IOException {
        this.put(ValueFactory.createRawValue(s2));
    }

    @Override
    public Packer writeNil() throws IOException {
        this.put(ValueFactory.createNilValue());
        return this;
    }

    @Override
    public Packer writeArrayBegin(int size2) throws IOException {
        if (size2 == 0) {
            this.putContainer(ValueFactory.createArrayValue());
            this.stack.pushArray(0);
            this.values[this.stack.getDepth()] = null;
        } else {
            Value[] array = new Value[size2];
            this.putContainer(ValueFactory.createArrayValue(array, true));
            this.stack.pushArray(size2);
            this.values[this.stack.getDepth()] = array;
        }
        return this;
    }

    @Override
    public Packer writeArrayEnd(boolean check2) throws IOException {
        if (!this.stack.topIsArray()) {
            throw new MessageTypeException("writeArrayEnd() is called but writeArrayBegin() is not called");
        }
        int remain = this.stack.getTopCount();
        if (remain > 0) {
            if (check2) {
                throw new MessageTypeException("writeArrayEnd(check=true) is called but the array is not end");
            }
            for (int i2 = 0; i2 < remain; ++i2) {
                this.writeNil();
            }
        }
        this.stack.pop();
        if (this.stack.getDepth() <= 0) {
            this.result = (Value)this.values[0];
        }
        return this;
    }

    @Override
    public Packer writeMapBegin(int size2) throws IOException {
        this.stack.checkCount();
        if (size2 == 0) {
            this.putContainer(ValueFactory.createMapValue());
            this.stack.pushMap(0);
            this.values[this.stack.getDepth()] = null;
        } else {
            Value[] array = new Value[size2 * 2];
            this.putContainer(ValueFactory.createMapValue(array, true));
            this.stack.pushMap(size2);
            this.values[this.stack.getDepth()] = array;
        }
        return this;
    }

    @Override
    public Packer writeMapEnd(boolean check2) throws IOException {
        if (!this.stack.topIsMap()) {
            throw new MessageTypeException("writeMapEnd() is called but writeMapBegin() is not called");
        }
        int remain = this.stack.getTopCount();
        if (remain > 0) {
            if (check2) {
                throw new MessageTypeException("writeMapEnd(check=true) is called but the map is not end");
            }
            for (int i2 = 0; i2 < remain; ++i2) {
                this.writeNil();
            }
        }
        this.stack.pop();
        if (this.stack.getDepth() <= 0) {
            this.result = (Value)this.values[0];
        }
        return this;
    }

    @Override
    public Packer write(Value v) throws IOException {
        this.put(v);
        return this;
    }

    private void put(Value v) {
        if (this.stack.getDepth() <= 0) {
            this.result = v;
        } else {
            this.stack.checkCount();
            Value[] array = (Value[])this.values[this.stack.getDepth()];
            array[array.length - this.stack.getTopCount()] = v;
            this.stack.reduceCount();
        }
    }

    private void putContainer(Value v) {
        if (this.stack.getDepth() <= 0) {
            this.values[0] = v;
        } else {
            this.stack.checkCount();
            Value[] array = (Value[])this.values[this.stack.getDepth()];
            array[array.length - this.stack.getTopCount()] = v;
            this.stack.reduceCount();
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

