/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.annotation.Beans;
import org.msgpack.annotation.Ignore;
import org.msgpack.annotation.Index;
import org.msgpack.annotation.Message;
import org.msgpack.annotation.MessagePackBeans;
import org.msgpack.annotation.MessagePackMessage;
import org.msgpack.annotation.MessagePackOrdinalEnum;
import org.msgpack.annotation.NotNullable;
import org.msgpack.annotation.Optional;
import org.msgpack.annotation.OrdinalEnum;
import org.msgpack.template.FieldList;
import org.msgpack.template.FieldOption;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.DefaultFieldEntry;
import org.msgpack.template.builder.FieldEntry;
import org.msgpack.template.builder.TemplateBuildException;
import org.msgpack.template.builder.TemplateBuilder;

public abstract class AbstractTemplateBuilder
implements TemplateBuilder {
    protected TemplateRegistry registry;

    protected AbstractTemplateBuilder(TemplateRegistry registry) {
        this.registry = registry;
    }

    @Override
    public <T> Template<T> buildTemplate(Type targetType) throws TemplateBuildException {
        Class targetClass = (Class)targetType;
        this.checkClassValidation(targetClass);
        FieldOption fieldOption = this.getFieldOption(targetClass);
        FieldEntry[] entries2 = this.toFieldEntries(targetClass, fieldOption);
        return this.buildTemplate(targetClass, entries2);
    }

    @Override
    public <T> Template<T> buildTemplate(Class<T> targetClass, FieldList fieldList) throws TemplateBuildException {
        this.checkClassValidation(targetClass);
        FieldEntry[] entries2 = this.toFieldEntries(targetClass, fieldList);
        return this.buildTemplate(targetClass, entries2);
    }

    protected abstract <T> Template<T> buildTemplate(Class<T> var1, FieldEntry[] var2);

    protected void checkClassValidation(Class<?> targetClass) {
        if (targetClass.isInterface()) {
            throw new TemplateBuildException("Cannot build template for interface: " + targetClass.getName());
        }
        if (targetClass.isArray()) {
            throw new TemplateBuildException("Cannot build template for array class: " + targetClass.getName());
        }
        if (targetClass.isPrimitive()) {
            throw new TemplateBuildException("Cannot build template of primitive type: " + targetClass.getName());
        }
    }

    protected FieldOption getFieldOption(Class<?> targetClass) {
        Message m = targetClass.getAnnotation(Message.class);
        if (m == null) {
            return FieldOption.DEFAULT;
        }
        MessagePackMessage mpm = targetClass.getAnnotation(MessagePackMessage.class);
        if (mpm == null) {
            return FieldOption.DEFAULT;
        }
        return m.value();
    }

    private FieldEntry[] toFieldEntries(Class<?> targetClass, FieldList flist) {
        List<FieldList.Entry> src = flist.getList();
        FieldEntry[] entries2 = new FieldEntry[src.size()];
        for (int i2 = 0; i2 < src.size(); ++i2) {
            FieldList.Entry s2 = src.get(i2);
            if (s2.isAvailable()) {
                try {
                    entries2[i2] = new DefaultFieldEntry(targetClass.getDeclaredField(s2.getName()), s2.getOption());
                    continue;
                }
                catch (SecurityException e) {
                    throw new TemplateBuildException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new TemplateBuildException(e);
                }
            }
            entries2[i2] = new DefaultFieldEntry();
        }
        return entries2;
    }

    protected FieldEntry[] toFieldEntries(Class<?> targetClass, FieldOption from) {
        Field[] fields2 = this.getFields(targetClass);
        ArrayList<DefaultFieldEntry> indexed = new ArrayList<DefaultFieldEntry>();
        int maxIndex = -1;
        for (Field f : fields2) {
            FieldOption opt = this.getFieldOption(f, from);
            if (opt == FieldOption.IGNORE) continue;
            int index2 = this.getFieldIndex(f, maxIndex);
            if (indexed.size() > index2 && indexed.get(index2) != null) {
                throw new TemplateBuildException("duplicated index: " + index2);
            }
            if (index2 < 0) {
                throw new TemplateBuildException("invalid index: " + index2);
            }
            while (indexed.size() <= index2) {
                indexed.add(null);
            }
            indexed.set(index2, new DefaultFieldEntry(f, opt));
            if (maxIndex >= index2) continue;
            maxIndex = index2;
        }
        FieldEntry[] entries2 = new FieldEntry[maxIndex + 1];
        for (int i2 = 0; i2 < indexed.size(); ++i2) {
            FieldEntry e = (FieldEntry)indexed.get(i2);
            entries2[i2] = e == null ? new DefaultFieldEntry() : e;
        }
        return entries2;
    }

    private Field[] getFields(Class<?> targetClass) {
        ArrayList<Field[]> succ2 = new ArrayList<Field[]>();
        int total2 = 0;
        for (Class<?> c = targetClass; c != Object.class; c = c.getSuperclass()) {
            Field[] fields2 = c.getDeclaredFields();
            total2 += fields2.length;
            succ2.add(fields2);
        }
        Field[] result2 = new Field[total2];
        int off = 0;
        for (int i2 = succ2.size() - 1; i2 >= 0; --i2) {
            Field[] fields3 = (Field[])succ2.get(i2);
            System.arraycopy(fields3, 0, result2, off, fields3.length);
            off += fields3.length;
        }
        return result2;
    }

    private FieldOption getFieldOption(Field field2, FieldOption from) {
        int mod = field2.getModifiers();
        if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || Modifier.isTransient(mod)) {
            return FieldOption.IGNORE;
        }
        if (AbstractTemplateBuilder.isAnnotated(field2, Ignore.class)) {
            return FieldOption.IGNORE;
        }
        if (AbstractTemplateBuilder.isAnnotated(field2, Optional.class)) {
            return FieldOption.OPTIONAL;
        }
        if (AbstractTemplateBuilder.isAnnotated(field2, NotNullable.class)) {
            return FieldOption.NOTNULLABLE;
        }
        if (from != FieldOption.DEFAULT) {
            return from;
        }
        if (field2.getType().isPrimitive()) {
            return FieldOption.NOTNULLABLE;
        }
        return FieldOption.OPTIONAL;
    }

    private int getFieldIndex(Field field2, int maxIndex) {
        Index a = field2.getAnnotation(Index.class);
        if (a == null) {
            return maxIndex + 1;
        }
        return a.value();
    }

    @Override
    public void writeTemplate(Type targetType, String directoryName) {
        throw new UnsupportedOperationException(targetType.toString());
    }

    @Override
    public <T> Template<T> loadTemplate(Type targetType) {
        return null;
    }

    public static boolean isAnnotated(Class<?> targetClass, Class<? extends Annotation> with) {
        return targetClass.getAnnotation(with) != null;
    }

    public static boolean isAnnotated(AccessibleObject accessibleObject, Class<? extends Annotation> with) {
        return accessibleObject.getAnnotation(with) != null;
    }

    public static boolean matchAtClassTemplateBuilder(Class<?> targetClass, boolean hasAnnotation) {
        if (hasAnnotation) {
            return AbstractTemplateBuilder.isAnnotated(targetClass, Message.class) || AbstractTemplateBuilder.isAnnotated(targetClass, MessagePackMessage.class);
        }
        return !targetClass.isEnum() && !targetClass.isInterface();
    }

    public static boolean matchAtBeansClassTemplateBuilder(Type targetType, boolean hasAnnotation) {
        Class targetClass = (Class)targetType;
        if (hasAnnotation) {
            return AbstractTemplateBuilder.isAnnotated((Class)targetType, Beans.class) || AbstractTemplateBuilder.isAnnotated((Class)targetType, MessagePackBeans.class);
        }
        return !targetClass.isEnum() || !targetClass.isInterface();
    }

    public static boolean matchAtArrayTemplateBuilder(Class<?> targetClass, boolean hasAnnotation) {
        if (targetClass instanceof GenericArrayType) {
            return true;
        }
        return targetClass.isArray();
    }

    public static boolean matchAtOrdinalEnumTemplateBuilder(Class<?> targetClass, boolean hasAnnotation) {
        if (hasAnnotation) {
            return AbstractTemplateBuilder.isAnnotated(targetClass, OrdinalEnum.class) || AbstractTemplateBuilder.isAnnotated(targetClass, MessagePackOrdinalEnum.class);
        }
        return targetClass.isEnum();
    }
}

