/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.msgpack.annotation.Ignore;
import org.msgpack.annotation.Index;
import org.msgpack.annotation.NotNullable;
import org.msgpack.annotation.Optional;
import org.msgpack.packer.Packer;
import org.msgpack.template.FieldOption;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.BeansFieldEntry;
import org.msgpack.template.builder.FieldEntry;
import org.msgpack.template.builder.ReflectionTemplateBuilder;
import org.msgpack.template.builder.TemplateBuildException;
import org.msgpack.unpacker.Unpacker;

public class ReflectionBeansTemplateBuilder
extends ReflectionTemplateBuilder {
    private static Logger LOG = Logger.getLogger(ReflectionBeansTemplateBuilder.class.getName());

    public ReflectionBeansTemplateBuilder(TemplateRegistry registry) {
        super(registry);
    }

    @Override
    public boolean matchType(Type targetType, boolean hasAnnotation) {
        Class targetClass = (Class)targetType;
        boolean matched2 = ReflectionBeansTemplateBuilder.matchAtBeansClassTemplateBuilder(targetClass, hasAnnotation);
        if (matched2 && LOG.isLoggable(Level.FINE)) {
            LOG.fine("matched type: " + targetClass.getName());
        }
        return matched2;
    }

    @Override
    protected ReflectionTemplateBuilder.ReflectionFieldTemplate[] toTemplates(FieldEntry[] entries2) {
        ReflectionTemplateBuilder.ReflectionFieldTemplate[] tmpls = new ReflectionTemplateBuilder.ReflectionFieldTemplate[entries2.length];
        for (int i2 = 0; i2 < entries2.length; ++i2) {
            FieldEntry e = entries2[i2];
            Class<?> type2 = e.getType();
            if (type2.isPrimitive()) {
                tmpls[i2] = new ReflectionBeansFieldTemplate(e);
                continue;
            }
            Template tmpl = this.registry.lookup(e.getGenericType());
            tmpls[i2] = new ReflectionTemplateBuilder.FieldTemplateImpl(e, tmpl);
        }
        return tmpls;
    }

    @Override
    public FieldEntry[] toFieldEntries(Class<?> targetClass, FieldOption implicitOption) {
        int i2;
        BeanInfo desc;
        try {
            desc = Introspector.getBeanInfo(targetClass);
        }
        catch (IntrospectionException e1) {
            throw new TemplateBuildException("Class must be java beans class:" + targetClass.getName());
        }
        PropertyDescriptor[] props = desc.getPropertyDescriptors();
        ArrayList<PropertyDescriptor> list2 = new ArrayList<PropertyDescriptor>();
        for (int i3 = 0; i3 < props.length; ++i3) {
            PropertyDescriptor pd = props[i3];
            if (this.isIgnoreProperty(pd)) continue;
            list2.add(pd);
        }
        props = new PropertyDescriptor[list2.size()];
        list2.toArray(props);
        FieldEntry[] entries2 = new BeansFieldEntry[props.length];
        for (int i4 = 0; i4 < props.length; ++i4) {
            PropertyDescriptor p2 = props[i4];
            int index2 = this.getPropertyIndex(p2);
            if (index2 < 0) continue;
            if (entries2[index2] != null) {
                throw new TemplateBuildException("duplicated index: " + index2);
            }
            if (index2 >= entries2.length) {
                throw new TemplateBuildException("invalid index: " + index2);
            }
            entries2[index2] = new BeansFieldEntry(p2);
            props[index2] = null;
        }
        int insertIndex = 0;
        for (i2 = 0; i2 < props.length; ++i2) {
            PropertyDescriptor p3 = props[i2];
            if (p3 == null) continue;
            while (entries2[insertIndex] != null) {
                ++insertIndex;
            }
            entries2[insertIndex] = new BeansFieldEntry(p3);
        }
        for (i2 = 0; i2 < entries2.length; ++i2) {
            FieldEntry e = entries2[i2];
            FieldOption op = this.getPropertyOption((BeansFieldEntry)e, implicitOption);
            e.setOption(op);
        }
        return entries2;
    }

    private FieldOption getPropertyOption(BeansFieldEntry e, FieldOption implicitOption) {
        FieldOption forGetter = this.getMethodOption(e.getPropertyDescriptor().getReadMethod());
        if (forGetter != FieldOption.DEFAULT) {
            return forGetter;
        }
        FieldOption forSetter = this.getMethodOption(e.getPropertyDescriptor().getWriteMethod());
        if (forSetter != FieldOption.DEFAULT) {
            return forSetter;
        }
        return implicitOption;
    }

    private FieldOption getMethodOption(Method method2) {
        if (ReflectionBeansTemplateBuilder.isAnnotated(method2, Ignore.class)) {
            return FieldOption.IGNORE;
        }
        if (ReflectionBeansTemplateBuilder.isAnnotated(method2, Optional.class)) {
            return FieldOption.OPTIONAL;
        }
        if (ReflectionBeansTemplateBuilder.isAnnotated(method2, NotNullable.class)) {
            return FieldOption.NOTNULLABLE;
        }
        return FieldOption.DEFAULT;
    }

    private int getPropertyIndex(PropertyDescriptor desc) {
        int getterIndex = this.getMethodIndex(desc.getReadMethod());
        if (getterIndex >= 0) {
            return getterIndex;
        }
        int setterIndex = this.getMethodIndex(desc.getWriteMethod());
        return setterIndex;
    }

    private int getMethodIndex(Method method2) {
        Index a = method2.getAnnotation(Index.class);
        if (a == null) {
            return -1;
        }
        return a.value();
    }

    private boolean isIgnoreProperty(PropertyDescriptor desc) {
        if (desc == null) {
            return true;
        }
        Method getter = desc.getReadMethod();
        Method setter = desc.getWriteMethod();
        return getter == null || setter == null || !Modifier.isPublic(getter.getModifiers()) || !Modifier.isPublic(setter.getModifiers()) || ReflectionBeansTemplateBuilder.isAnnotated(getter, Ignore.class) || ReflectionBeansTemplateBuilder.isAnnotated(setter, Ignore.class);
    }

    static class ReflectionBeansFieldTemplate
    extends ReflectionTemplateBuilder.ReflectionFieldTemplate {
        ReflectionBeansFieldTemplate(FieldEntry entry) {
            super(entry);
        }

        @Override
        public void write(Packer packer, Object v, boolean required) throws IOException {
            packer.write(v);
        }

        @Override
        public Object read(Unpacker unpacker, Object to, boolean required) throws IOException {
            Class<?> o = unpacker.read(this.entry.getType());
            this.entry.set(to, o);
            return o;
        }
    }
}

