/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.type;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.type.AbstractRawValue;
import org.msgpack.type.Value;

class StringRawValueImpl
extends AbstractRawValue {
    private String string;

    StringRawValueImpl(String string2) {
        this.string = string2;
    }

    @Override
    public byte[] getByteArray() {
        try {
            return this.string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MessageTypeException(ex);
        }
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public void writeTo(Packer pk) throws IOException {
        pk.write(this.string);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isRawValue()) {
            return false;
        }
        if (v.getClass() == StringRawValueImpl.class) {
            return this.string.equals(((StringRawValueImpl)v).string);
        }
        return Arrays.equals(this.getByteArray(), v.asRawValue().getByteArray());
    }
}

