/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.unpacker;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Unconverter;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.MapValue;
import org.msgpack.type.Value;
import org.msgpack.type.ValueType;
import org.msgpack.unpacker.AbstractUnpacker;
import org.msgpack.unpacker.UnpackerStack;

public class Converter
extends AbstractUnpacker {
    private final UnpackerStack stack = new UnpackerStack();
    private Object[] values = new Object[128];
    protected Value value;

    public Converter(Value value2) {
        this(new MessagePack(), value2);
    }

    public Converter(MessagePack msgpack, Value value2) {
        super(msgpack);
        this.value = value2;
    }

    protected Value nextValue() throws IOException {
        throw new EOFException();
    }

    private void ensureValue() throws IOException {
        if (this.value == null) {
            this.value = this.nextValue();
        }
    }

    @Override
    public boolean tryReadNil() throws IOException {
        this.stack.checkCount();
        if (this.getTop().isNilValue()) {
            this.stack.reduceCount();
            if (this.stack.getDepth() == 0) {
                this.value = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean trySkipNil() throws IOException {
        this.ensureValue();
        if (this.stack.getDepth() > 0 && this.stack.getTopCount() <= 0) {
            return true;
        }
        if (this.getTop().isNilValue()) {
            this.stack.reduceCount();
            if (this.stack.getDepth() == 0) {
                this.value = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public void readNil() throws IOException {
        if (!this.getTop().isNilValue()) {
            throw new MessageTypeException("Expected nil but got not nil value");
        }
        this.stack.reduceCount();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean v = this.getTop().asBooleanValue().getBoolean();
        this.stack.reduceCount();
        return v;
    }

    @Override
    public byte readByte() throws IOException {
        byte v = this.getTop().asIntegerValue().getByte();
        this.stack.reduceCount();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
        return v;
    }

    @Override
    public short readShort() throws IOException {
        short v = this.getTop().asIntegerValue().getShort();
        this.stack.reduceCount();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
        return v;
    }

    @Override
    public int readInt() throws IOException {
        int v = this.getTop().asIntegerValue().getInt();
        this.stack.reduceCount();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
        return v;
    }

    @Override
    public long readLong() throws IOException {
        long v = this.getTop().asIntegerValue().getLong();
        this.stack.reduceCount();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
        return v;
    }

    @Override
    public BigInteger readBigInteger() throws IOException {
        BigInteger v = this.getTop().asIntegerValue().getBigInteger();
        this.stack.reduceCount();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
        return v;
    }

    @Override
    public float readFloat() throws IOException {
        float v = this.getTop().asFloatValue().getFloat();
        this.stack.reduceCount();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
        return v;
    }

    @Override
    public double readDouble() throws IOException {
        double v = this.getTop().asFloatValue().getDouble();
        this.stack.reduceCount();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
        return v;
    }

    @Override
    public byte[] readByteArray() throws IOException {
        byte[] raw = this.getTop().asRawValue().getByteArray();
        this.stack.reduceCount();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
        return raw;
    }

    @Override
    public String readString() throws IOException {
        String str = this.getTop().asRawValue().getString();
        this.stack.reduceCount();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
        return str;
    }

    @Override
    public int readArrayBegin() throws IOException {
        Value v = this.getTop();
        if (!v.isArrayValue()) {
            throw new MessageTypeException("Expected array but got not array value");
        }
        ArrayValue a = v.asArrayValue();
        this.stack.reduceCount();
        this.stack.pushArray(a.size());
        this.values[this.stack.getDepth()] = a.getElementArray();
        return a.size();
    }

    @Override
    public void readArrayEnd(boolean check2) throws IOException {
        if (!this.stack.topIsArray()) {
            throw new MessageTypeException("readArrayEnd() is called but readArrayBegin() is not called");
        }
        int remain = this.stack.getTopCount();
        if (remain > 0) {
            if (check2) {
                throw new MessageTypeException("readArrayEnd(check=true) is called but the array is not end");
            }
            for (int i2 = 0; i2 < remain; ++i2) {
                this.skip();
            }
        }
        this.stack.pop();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
    }

    @Override
    public int readMapBegin() throws IOException {
        Value v = this.getTop();
        if (!v.isMapValue()) {
            throw new MessageTypeException("Expected map but got not map value");
        }
        MapValue m = v.asMapValue();
        this.stack.reduceCount();
        this.stack.pushMap(m.size());
        this.values[this.stack.getDepth()] = m.getKeyValueArray();
        return m.size();
    }

    @Override
    public void readMapEnd(boolean check2) throws IOException {
        if (!this.stack.topIsMap()) {
            throw new MessageTypeException("readMapEnd() is called but readMapBegin() is not called");
        }
        int remain = this.stack.getTopCount();
        if (remain > 0) {
            if (check2) {
                throw new MessageTypeException("readMapEnd(check=true) is called but the map is not end");
            }
            for (int i2 = 0; i2 < remain; ++i2) {
                this.skip();
            }
        }
        this.stack.pop();
        if (this.stack.getDepth() == 0) {
            this.value = null;
        }
    }

    private Value getTop() throws IOException {
        this.ensureValue();
        this.stack.checkCount();
        if (this.stack.getDepth() == 0) {
            return this.value;
        }
        Value[] array = (Value[])this.values[this.stack.getDepth()];
        return array[array.length - this.stack.getTopCount()];
    }

    @Override
    public Value readValue() throws IOException {
        if (this.stack.getDepth() == 0) {
            if (this.value == null) {
                return this.nextValue();
            }
            Value v = this.value;
            this.value = null;
            return v;
        }
        return super.readValue();
    }

    @Override
    protected void readValue(Unconverter uc) throws IOException {
        if (uc.getResult() != null) {
            uc.resetResult();
        }
        this.stack.checkCount();
        Value v = this.getTop();
        if (!v.isArrayValue() && !v.isMapValue()) {
            uc.write(v);
            this.stack.reduceCount();
            if (this.stack.getDepth() == 0) {
                this.value = null;
            }
            if (uc.getResult() != null) {
                return;
            }
        }
        while (true) {
            if (this.stack.getDepth() != 0 && this.stack.getTopCount() == 0) {
                if (this.stack.topIsArray()) {
                    uc.writeArrayEnd(true);
                    this.stack.pop();
                } else if (this.stack.topIsMap()) {
                    uc.writeMapEnd(true);
                    this.stack.pop();
                } else {
                    throw new RuntimeException("invalid stack");
                }
                if (this.stack.getDepth() == 0) {
                    this.value = null;
                }
                if (uc.getResult() == null) continue;
                return;
            }
            this.stack.checkCount();
            v = this.getTop();
            if (v.isArrayValue()) {
                ArrayValue a = v.asArrayValue();
                uc.writeArrayBegin(a.size());
                this.stack.reduceCount();
                this.stack.pushArray(a.size());
                this.values[this.stack.getDepth()] = a.getElementArray();
                continue;
            }
            if (v.isMapValue()) {
                MapValue m = v.asMapValue();
                uc.writeMapBegin(m.size());
                this.stack.reduceCount();
                this.stack.pushMap(m.size());
                this.values[this.stack.getDepth()] = m.getKeyValueArray();
                continue;
            }
            uc.write(v);
            this.stack.reduceCount();
        }
    }

    @Override
    public void skip() throws IOException {
        this.stack.checkCount();
        Value v = this.getTop();
        if (!v.isArrayValue() && !v.isMapValue()) {
            this.stack.reduceCount();
            if (this.stack.getDepth() == 0) {
                this.value = null;
            }
            return;
        }
        int targetDepth = this.stack.getDepth();
        while (true) {
            if (this.stack.getTopCount() == 0) {
                this.stack.pop();
                if (this.stack.getDepth() == 0) {
                    this.value = null;
                }
                if (this.stack.getDepth() > targetDepth) continue;
                return;
            }
            this.stack.checkCount();
            v = this.getTop();
            if (v.isArrayValue()) {
                ArrayValue a = v.asArrayValue();
                this.stack.reduceCount();
                this.stack.pushArray(a.size());
                this.values[this.stack.getDepth()] = a.getElementArray();
                continue;
            }
            if (v.isMapValue()) {
                MapValue m = v.asMapValue();
                this.stack.reduceCount();
                this.stack.pushMap(m.size());
                this.values[this.stack.getDepth()] = m.getKeyValueArray();
                continue;
            }
            this.stack.reduceCount();
        }
    }

    @Override
    public ValueType getNextType() throws IOException {
        return this.getTop().getType();
    }

    public void reset() {
        this.stack.clear();
        this.value = null;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int getReadByteCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void setRawSizeLimit(int size2) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void setArraySizeLimit(int size2) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void setMapSizeLimit(int size2) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

