/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.util.json;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.io.Output;
import org.msgpack.io.StreamOutput;
import org.msgpack.packer.AbstractPacker;
import org.msgpack.packer.Packer;
import org.msgpack.packer.PackerStack;

public class JSONPacker
extends AbstractPacker {
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};
    private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};
    private static final byte COMMA = 44;
    private static final byte COLON = 58;
    private static final byte QUOTE = 34;
    private static final byte LEFT_BR = 91;
    private static final byte RIGHT_BR = 93;
    private static final byte LEFT_WN = 123;
    private static final byte RIGHT_WN = 125;
    private static final byte BACKSLASH = 92;
    private static final byte ZERO = 48;
    private static final int FLAG_FIRST_ELEMENT = 1;
    private static final int FLAG_MAP_KEY = 2;
    private static final int FLAG_MAP_VALUE = 4;
    protected final Output out;
    private int[] flags;
    private PackerStack stack = new PackerStack();
    private CharsetDecoder decoder;
    private static final int[] ESCAPE_TABLE = new int[128];
    private static final byte[] HEX_TABLE;

    public JSONPacker(OutputStream stream) {
        this(new MessagePack(), stream);
    }

    public JSONPacker(MessagePack msgpack, OutputStream stream) {
        this(msgpack, new StreamOutput(stream));
    }

    protected JSONPacker(MessagePack msgpack, Output out) {
        super(msgpack);
        this.out = out;
        this.stack = new PackerStack();
        this.flags = new int[128];
        this.decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    @Override
    protected void writeBoolean(boolean v) throws IOException {
        this.beginElement();
        if (v) {
            this.out.write(TRUE, 0, TRUE.length);
        } else {
            this.out.write(FALSE, 0, FALSE.length);
        }
        this.endElement();
    }

    @Override
    protected void writeByte(byte v) throws IOException {
        this.beginElement();
        byte[] b = Byte.toString(v).getBytes();
        this.out.write(b, 0, b.length);
        this.endElement();
    }

    @Override
    protected void writeShort(short v) throws IOException {
        this.beginElement();
        byte[] b = Short.toString(v).getBytes();
        this.out.write(b, 0, b.length);
        this.endElement();
    }

    @Override
    protected void writeInt(int v) throws IOException {
        this.beginElement();
        byte[] b = Integer.toString(v).getBytes();
        this.out.write(b, 0, b.length);
        this.endElement();
    }

    @Override
    protected void writeLong(long v) throws IOException {
        this.beginElement();
        byte[] b = Long.toString(v).getBytes();
        this.out.write(b, 0, b.length);
        this.endElement();
    }

    @Override
    protected void writeBigInteger(BigInteger v) throws IOException {
        this.beginElement();
        byte[] b = v.toString().getBytes();
        this.out.write(b, 0, b.length);
        this.endElement();
    }

    @Override
    protected void writeFloat(float v) throws IOException {
        this.beginElement();
        Float r = Float.valueOf(v);
        if (r.isInfinite() || r.isNaN()) {
            throw new IOException("JSONPacker doesn't support NaN and infinite float value");
        }
        byte[] b = Float.toString(v).getBytes();
        this.out.write(b, 0, b.length);
        this.endElement();
    }

    @Override
    protected void writeDouble(double v) throws IOException {
        this.beginElement();
        Double r = v;
        if (r.isInfinite() || r.isNaN()) {
            throw new IOException("JSONPacker doesn't support NaN and infinite float value");
        }
        byte[] b = Double.toString(v).getBytes();
        this.out.write(b, 0, b.length);
        this.endElement();
    }

    @Override
    protected void writeByteArray(byte[] b, int off, int len) throws IOException {
        this.beginStringElement();
        this.out.writeByte((byte)34);
        this.escape(this.out, b, off, len);
        this.out.writeByte((byte)34);
        this.endElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeByteBuffer(ByteBuffer bb) throws IOException {
        this.beginStringElement();
        this.out.writeByte((byte)34);
        int pos2 = bb.position();
        try {
            this.escape(this.out, bb);
        }
        finally {
            bb.position(pos2);
        }
        this.out.writeByte((byte)34);
        this.endElement();
    }

    @Override
    protected void writeString(String s2) throws IOException {
        this.beginStringElement();
        this.out.writeByte((byte)34);
        JSONPacker.escape(this.out, s2);
        this.out.writeByte((byte)34);
        this.endElement();
    }

    @Override
    public Packer writeNil() throws IOException {
        this.beginElement();
        this.out.write(NULL, 0, NULL.length);
        this.endElement();
        return this;
    }

    @Override
    public Packer writeArrayBegin(int size2) throws IOException {
        this.beginElement();
        this.out.writeByte((byte)91);
        this.endElement();
        this.stack.pushArray(size2);
        this.flags[this.stack.getDepth()] = 1;
        return this;
    }

    @Override
    public Packer writeArrayEnd(boolean check2) throws IOException {
        if (!this.stack.topIsArray()) {
            throw new MessageTypeException("writeArrayEnd() is called but writeArrayBegin() is not called");
        }
        int remain = this.stack.getTopCount();
        if (remain > 0) {
            if (check2) {
                throw new MessageTypeException("writeArrayEnd(check=true) is called but the array is not end: " + remain);
            }
            for (int i2 = 0; i2 < remain; ++i2) {
                this.writeNil();
            }
        }
        this.stack.pop();
        this.out.writeByte((byte)93);
        return this;
    }

    @Override
    public Packer writeMapBegin(int size2) throws IOException {
        this.beginElement();
        this.out.writeByte((byte)123);
        this.endElement();
        this.stack.pushMap(size2);
        this.flags[this.stack.getDepth()] = 3;
        return this;
    }

    @Override
    public Packer writeMapEnd(boolean check2) throws IOException {
        if (!this.stack.topIsMap()) {
            throw new MessageTypeException("writeMapEnd() is called but writeMapBegin() is not called");
        }
        int remain = this.stack.getTopCount();
        if (remain > 0) {
            if (check2) {
                throw new MessageTypeException("writeMapEnd(check=true) is called but the map is not end: " + remain);
            }
            for (int i2 = 0; i2 < remain; ++i2) {
                this.writeNil();
            }
        }
        this.stack.pop();
        this.out.writeByte((byte)125);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void reset() {
        this.stack.clear();
    }

    private void beginElement() throws IOException {
        int flag = this.flags[this.stack.getDepth()];
        if ((flag & 2) != 0) {
            throw new IOException("Key of a map must be a string in JSON");
        }
        this.beginStringElement();
    }

    private void beginStringElement() throws IOException {
        int flag = this.flags[this.stack.getDepth()];
        if ((flag & 4) != 0) {
            this.out.writeByte((byte)58);
        } else if (this.stack.getDepth() > 0 && (flag & 1) == 0) {
            this.out.writeByte((byte)44);
        }
    }

    private void endElement() throws IOException {
        int flag = this.flags[this.stack.getDepth()];
        if ((flag & 2) != 0) {
            flag &= 0xFFFFFFFD;
            flag |= 4;
        } else if ((flag & 4) != 0) {
            flag &= 0xFFFFFFFB;
            flag |= 2;
        }
        this.flags[this.stack.getDepth()] = flag &= 0xFFFFFFFE;
        this.stack.reduceCount();
    }

    private void escape(Output out, byte[] b, int off, int len) throws IOException {
        this.escape(out, ByteBuffer.wrap(b, off, len));
    }

    private void escape(Output out, ByteBuffer bb) throws IOException {
        String str = this.decoder.decode(bb).toString();
        JSONPacker.escape(out, str);
    }

    private static void escape(Output out, String s2) throws IOException {
        byte[] tmp = new byte[]{92, 117, 0, 0, 0, 0};
        char[] chars2 = s2.toCharArray();
        for (int i2 = 0; i2 < chars2.length; ++i2) {
            char ch = chars2[i2];
            if (ch <= '\u007f') {
                int e = ESCAPE_TABLE[ch];
                if (e == 0) {
                    tmp[2] = (byte)ch;
                    out.write(tmp, 2, 1);
                    continue;
                }
                if (e > 0) {
                    tmp[2] = 92;
                    tmp[3] = (byte)e;
                    out.write(tmp, 2, 2);
                    continue;
                }
                tmp[2] = 48;
                tmp[3] = 48;
                tmp[4] = HEX_TABLE[ch >> 4];
                tmp[5] = HEX_TABLE[ch & 0xF];
                out.write(tmp, 0, 6);
                continue;
            }
            if (ch <= '\u07ff') {
                tmp[2] = (byte)(0xC0 | ch >> 6);
                tmp[3] = (byte)(0x80 | ch & 0x3F);
                out.write(tmp, 2, 2);
                continue;
            }
            if (ch >= '\ud800' && ch <= '\udfff') {
                tmp[2] = HEX_TABLE[ch >> 12 & 0xF];
                tmp[3] = HEX_TABLE[ch >> 8 & 0xF];
                tmp[4] = HEX_TABLE[ch >> 4 & 0xF];
                tmp[5] = HEX_TABLE[ch & 0xF];
                out.write(tmp, 0, 6);
                continue;
            }
            tmp[2] = (byte)(0xE0 | ch >> 12);
            tmp[3] = (byte)(0x80 | ch >> 6 & 0x3F);
            tmp[4] = (byte)(0x80 | ch & 0x3F);
            out.write(tmp, 2, 3);
        }
    }

    static {
        for (int i2 = 0; i2 < 32; ++i2) {
            JSONPacker.ESCAPE_TABLE[i2] = -1;
        }
        JSONPacker.ESCAPE_TABLE[34] = 34;
        JSONPacker.ESCAPE_TABLE[92] = 92;
        JSONPacker.ESCAPE_TABLE[8] = 98;
        JSONPacker.ESCAPE_TABLE[9] = 116;
        JSONPacker.ESCAPE_TABLE[12] = 102;
        JSONPacker.ESCAPE_TABLE[10] = 110;
        JSONPacker.ESCAPE_TABLE[13] = 114;
        char[] hex2 = "0123456789ABCDEF".toCharArray();
        HEX_TABLE = new byte[hex2.length];
        for (int i3 = 0; i3 < hex2.length; ++i3) {
            JSONPacker.HEX_TABLE[i3] = (byte)hex2[i3];
        }
    }
}

