/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.TableColumn;

final class ComboBoxTab {
    private static final String TEST_STR = "A test string";
    private ListCellRenderer narrowMarginRenderer;
    private ListCellRenderer wideMarginRenderer;
    private ListCellRenderer noMarginRenderer;
    private ListCellRenderer panelRenderer;

    ComboBoxTab() {
    }

    private void initRenderers() {
        this.narrowMarginRenderer = new CustomMarginRenderer(new EmptyBorder(1, 1, 1, 1));
        this.wideMarginRenderer = new CustomMarginRenderer(new EmptyBorder(1, 5, 1, 5));
        this.noMarginRenderer = new CustomMarginRenderer(new EmptyBorder(0, 0, 0, 0));
        this.panelRenderer = new PanelRenderer();
    }

    JComponent build() {
        this.initRenderers();
        FormLayout layout = new FormLayout("0:grow, pref, 0:grow", "pref, 9dlu, pref, 2dlu, pref, 21dlu, pref, 2dlu, 50dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.getPanel().setOpaque(false);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.buildHelpPanel(), cc.xy(2, 1));
        builder.addSeparator("Form", cc.xy(2, 3));
        builder.add((Component)this.buildTestPanel(), cc.xy(2, 5, "center, fill"));
        builder.addTitle("Table", cc.xy(2, 7));
        builder.add((Component)this.buildTable(), cc.xy(2, 9));
        return builder.getPanel();
    }

    private JComponent buildHelpPanel() {
        return new JLabel("Font baselines shall be aligned and the visible value shall not be cropped.");
    }

    private JComponent buildTestPanel() {
        FormLayout layout = new FormLayout("right:pref, 3dlu, left:pref, 4dlu, left:pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.getPanel().setOpaque(false);
        builder.append("Renderer");
        builder.append(this.createCenteredLabel("Editable"));
        builder.append(this.createCenteredLabel("Non-Editable"));
        builder.append("Default");
        builder.append(this.createComboBox(TEST_STR, true, null));
        builder.append(this.createComboBox(TEST_STR, false, null));
        builder.append("Panel");
        builder.append(this.createComboBox(TEST_STR, true, this.panelRenderer));
        builder.append(this.createComboBox(TEST_STR, false, this.panelRenderer));
        builder.append("Narrow Margin");
        builder.append(this.createComboBox(TEST_STR, true, this.narrowMarginRenderer));
        builder.append(this.createComboBox(TEST_STR, false, this.narrowMarginRenderer));
        builder.append("No Margin");
        builder.append(this.createComboBox(TEST_STR, true, this.noMarginRenderer));
        builder.append(this.createComboBox(TEST_STR, false, this.noMarginRenderer));
        builder.append("Wide Margin");
        builder.append(this.createComboBox(TEST_STR, true, this.wideMarginRenderer));
        builder.append(this.createComboBox(TEST_STR, false, this.wideMarginRenderer));
        return builder.getPanel();
    }

    private JComponent buildTable() {
        Object[] columnNames = new String[]{"Text", "Editable", "Non-Editable"};
        Object[][] data = new Object[][]{{TEST_STR, TEST_STR, TEST_STR}, {TEST_STR, TEST_STR, TEST_STR}, {TEST_STR, TEST_STR, TEST_STR}, {TEST_STR, TEST_STR, TEST_STR}, {TEST_STR, TEST_STR, TEST_STR}};
        JTable table = new JTable(data, columnNames);
        TableColumn editableColumn = table.getColumnModel().getColumn(1);
        JComboBox editableCombo = this.createComboBox(TEST_STR, true, null);
        editableColumn.setCellEditor(new DefaultCellEditor(editableCombo));
        TableColumn nonEditableColumn = table.getColumnModel().getColumn(2);
        JComboBox nonEditableCombo = this.createComboBox(TEST_STR, false, null);
        nonEditableColumn.setCellEditor(new DefaultCellEditor(nonEditableCombo));
        return new JScrollPane(table);
    }

    private JLabel createCenteredLabel(String text) {
        return new JLabel(text, 0);
    }

    private JComboBox createComboBox(String selectedText, boolean editable, ListCellRenderer renderer) {
        String[] values = new String[]{selectedText, "1", "2", "3", "4", "5", "Two", "Three", "Four", "Five", "Six", "Seven"};
        JComboBox<String> combo = new JComboBox<String>(values);
        combo.setEditable(editable);
        if (renderer != null) {
            combo.setRenderer(renderer);
        }
        return combo;
    }

    private static final class PanelRenderer
    extends JPanel
    implements ListCellRenderer {
        private static Border noFocusBorder;
        private final JLabel label;

        private PanelRenderer() {
            super(new BorderLayout());
            if (noFocusBorder == null) {
                noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            }
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
            this.label = new JLabel();
            this.add((Component)this.label, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.label.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.label.setForeground(list.getForeground());
            }
            if (value instanceof Icon) {
                this.label.setIcon((Icon)value);
                this.label.setText("");
            } else {
                this.label.setIcon(null);
                this.label.setText(value == null ? "" : value.toString());
            }
            this.label.setEnabled(list.isEnabled());
            this.label.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }

    private static final class CustomMarginRenderer
    extends BasicComboBoxRenderer {
        private CustomMarginRenderer(Border border) {
            this.setBorder(border);
        }
    }
}

