/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

final class SplitTab {
    SplitTab() {
    }

    JComponent build() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(Borders.DIALOG_BORDER);
        panel.add(this.buildHorizontalSplit());
        return panel;
    }

    private JComponent buildHorizontalSplit() {
        JScrollPane left = new JScrollPane(this.buildTree());
        left.setPreferredSize(new Dimension(200, 100));
        JScrollPane upperRight = new JScrollPane(this.buildTextArea());
        upperRight.setPreferredSize(new Dimension(100, 100));
        JScrollPane lowerRight = new JScrollPane(this.buildTable());
        lowerRight.setPreferredSize(new Dimension(100, 100));
        UIFSplitPane verticalSplit = UIFSplitPane.createStrippedSplitPane(0, upperRight, lowerRight);
        UIFSplitPane horizontalSplit = UIFSplitPane.createStrippedSplitPane(1, left, verticalSplit);
        return horizontalSplit;
    }

    private JTree buildTree() {
        JTree tree = new JTree(this.createSampleTreeModel());
        tree.expandRow(3);
        tree.expandRow(2);
        tree.expandRow(1);
        return tree;
    }

    private JTextArea buildTextArea() {
        JTextArea area = new JTextArea();
        area.setText("May\nI\nKindly\nRemind you that a\nMargin\nImproves a text's readability.");
        return area;
    }

    private JTable buildTable() {
        JTable table = new JTable(this.createSampleTableData(), new String[]{"Artist", "Title      "});
        table.setAutoResizeMode(0);
        table.getColumnModel().getColumn(0).setPreferredWidth(100);
        table.getColumnModel().getColumn(1).setPreferredWidth(300);
        table.setRowSelectionInterval(2, 2);
        int tableFontSize = table.getFont().getSize();
        int minimumRowHeight = tableFontSize + 6;
        int defaultRowHeight = LookUtils.IS_LOW_RESOLUTION ? 17 : 18;
        table.setRowHeight(Math.max(minimumRowHeight, defaultRowHeight));
        return table;
    }

    private TreeModel createSampleTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Musicians");
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode("Drums");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("Elvin Jones"));
        parent.add(new DefaultMutableTreeNode("Jack DeJohnette"));
        parent.add(new DefaultMutableTreeNode("Rashied Ali"));
        parent = new DefaultMutableTreeNode("Piano");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("Alexander von Schlippenbach"));
        parent.add(new DefaultMutableTreeNode("McCoy Tyner"));
        parent.add(new DefaultMutableTreeNode("Sun Ra"));
        parent = new DefaultMutableTreeNode("Saxophon");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("Albert Ayler"));
        parent.add(new DefaultMutableTreeNode("Archie Shepp"));
        parent.add(new DefaultMutableTreeNode("Charlie Parker"));
        parent.add(new DefaultMutableTreeNode("John Coltrane"));
        parent.add(new DefaultMutableTreeNode("Ornette Coleman"));
        parent.add(new DefaultMutableTreeNode("Pharoa Sanders"));
        parent.add(new DefaultMutableTreeNode("Sonny Rollins"));
        return new DefaultTreeModel(root);
    }

    private String[][] createSampleTableData() {
        return new String[][]{{"Albert Ayler", "Greenwich Village"}, {"Carla Bley", "Escalator Over the Hill"}, {"Frank Zappa", "Yo' Mama"}, {"John Coltrane", "Ascension"}, {"Miles Davis", "In a Silent Way"}, {"Pharoa Sanders", "Karma"}, {"Wayne Shorter", "Juju"}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}};
    }
}

