/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.Differ;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.LexStream;
import lpg.runtime.UnknownStreamType;
import lpg.runtime.Utf8LexStream;

public class DifferLines
extends Differ {
    public DifferLines(IPrsStream newStream, IPrsStream oldStream) {
        super(newStream, oldStream);
    }

    protected DifferLines() {
    }

    public Differ.ILine[] getBuffer(IPrsStream prsStream) {
        ILexStream lex_stream = prsStream.getILexStream();
        Differ.ILine[] buffer = new Line[lex_stream.getLineCount() + 1];
        int token = 1;
        buffer[0] = new Line(prsStream, 0, 0);
        for (int line_no = 1; line_no < buffer.length; ++line_no) {
            int first_token = token;
            while (token < prsStream.getSize() && prsStream.getLine(token) == line_no) {
                ++token;
            }
            buffer[line_no] = new Line(prsStream, first_token, token);
        }
        return buffer;
    }

    void printLines(IPrsStream prs_stream, int first_line, int last_line) {
        if (prs_stream.getILexStream() instanceof LexStream) {
            LexStream lex_stream = (LexStream)prs_stream.getILexStream();
            char[] buffer = lex_stream.getInputChars();
            for (int line_no = first_line; line_no <= last_line; ++line_no) {
                int start = lex_stream.getLineOffset(line_no - 1) + 1;
                int end = lex_stream.getLineOffset(line_no);
                String num = line_no + " ";
                for (int i = 0; i < 7 - num.length(); ++i) {
                    System.out.print(' ');
                }
                String line = num + new String(buffer, start, end - start);
                System.out.println(line);
            }
        } else if (prs_stream.getILexStream() instanceof Utf8LexStream) {
            Utf8LexStream lex_stream = (Utf8LexStream)prs_stream.getILexStream();
            byte[] buffer = lex_stream.getInputBytes();
            for (int line_no = first_line; line_no <= last_line; ++line_no) {
                int start = lex_stream.getLineOffset(line_no - 1) + 1;
                int end = lex_stream.getLineOffset(line_no);
                String num = line_no + " ";
                for (int i = 0; i < 7 - num.length(); ++i) {
                    System.out.print(' ');
                }
                String line = num + new String(buffer, start, end - start);
                System.out.println(line);
            }
        } else {
            throw new UnknownStreamType("Unknown stream type " + prs_stream.getILexStream().getClass().toString());
        }
    }

    void outputInsert(Differ.Change element) {
        this.insertCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Insert after " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlde()].getStartLine() + " " + this.newStream.getFileName() + "," + this.newBuffer[element.getNews()].getStartLine() + (this.newBuffer[element.getNewe()].getEndLine() > this.newBuffer[element.getNews()].getStartLine() ? ".." + this.newBuffer[element.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[element.getNews()].getStartLine(), this.newBuffer[element.getNewe()].getEndLine());
    }

    void outputDelete(Differ.Change element) {
        this.deleteCount += element.getOlde() - element.getOlds() + 1;
        System.out.println("Delete after " + this.newStream.getFileName() + "," + this.newBuffer[element.getNewe()].getStartLine() + " " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlds()].getStartLine() + (this.oldBuffer[element.getOlde()].getEndLine() > this.oldBuffer[element.getOlds()].getStartLine() ? ".." + this.oldBuffer[element.getOlde()].getEndLine() : "") + ":");
        this.printLines(this.oldStream, this.oldBuffer[element.getOlds()].getStartLine(), this.oldBuffer[element.getOlde()].getEndLine());
    }

    void outputReplace(Differ.Change element) {
        this.replaceDeleteCount += element.getOlde() - element.getOlds() + 1;
        this.replaceInsertCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Replace " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlds()].getStartLine() + (this.oldBuffer[element.getOlde()].getEndLine() > this.oldBuffer[element.getOlds()].getStartLine() ? ".." + this.oldBuffer[element.getOlde()].getEndLine() : "") + ":");
        this.printLines(this.oldStream, this.oldBuffer[element.getOlds()].getStartLine(), this.oldBuffer[element.getOlde()].getEndLine());
        System.out.println("With " + this.newStream.getFileName() + "," + this.newBuffer[element.getNews()].getStartLine() + (this.newBuffer[element.getNewe()].getEndLine() > this.newBuffer[element.getNews()].getStartLine() ? ".." + this.newBuffer[element.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[element.getNews()].getStartLine(), this.newBuffer[element.getNewe()].getEndLine());
    }

    void outputMove(Differ.Change element) {
        this.moveCount += element.getNewe() - element.getNews() + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlds()].getStartLine() + (this.oldBuffer[element.getOlde()].getEndLine() > this.oldBuffer[element.getOlds()].getStartLine() ? ".." + this.oldBuffer[element.getOlde()].getEndLine() : "") + " to " + this.newStream.getFileName() + "," + this.newBuffer[element.getNews()].getStartLine() + (this.newBuffer[element.getNewe()].getEndLine() > this.newBuffer[element.getNews()].getStartLine() ? ".." + this.newBuffer[element.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[element.getNews()].getStartLine(), this.newBuffer[element.getNewe()].getEndLine());
    }

    void outputMoveDelete(Differ.Change element) {
        this.moveCount += element.getNewe() - element.getNews() + 1;
        int bound = this.newBuffer[element.getNewe()].getEndLine() - this.newBuffer[element.getNews()].getStartLine();
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlds()].getStartLine() + (bound > 0 ? ".." + (this.oldBuffer[element.getOlds()].getStartLine() + bound) : "") + " to " + this.newStream.getFileName() + "," + this.newBuffer[element.getNews()].getStartLine() + (this.newBuffer[element.getNewe()].getEndLine() > this.newBuffer[element.getNews()].getStartLine() ? ".." + this.newBuffer[element.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[element.getNews()].getStartLine(), this.newBuffer[element.getNewe()].getEndLine());
        int oldi = this.oldBuffer[element.getOlds()].getStartLine() + bound + 1;
        this.deleteCount += element.getOlde() - element.getOlds() - element.getNewe() + element.getNews();
        System.out.println("... And delete " + this.oldStream.getFileName() + "," + oldi + (this.oldBuffer[element.getOlde()].getEndLine() > oldi ? ".." + this.oldBuffer[element.getOlde()].getEndLine() : ""));
        this.printLines(this.oldStream, oldi, this.newBuffer[element.getOlde()].getEndLine());
    }

    void outputMoveInsert(Differ.Change element) {
        this.moveCount += element.getOlde() - element.getOlds() + 1;
        int bound = this.oldBuffer[element.getOlde()].getStartLine() - this.oldBuffer[element.getOlds()].getEndLine();
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldBuffer[element.getOlds()].getStartLine() + (this.oldBuffer[element.getOlde()].getEndLine() > this.oldBuffer[element.getOlds()].getStartLine() ? ".." + this.oldBuffer[element.getOlde()].getEndLine() : "") + " to " + this.newStream.getFileName() + "," + this.newBuffer[element.getNews()].getStartLine() + (bound > 0 ? ".." + this.newBuffer[element.getNews()].getStartLine() + bound : "") + ":");
        this.printLines(this.newStream, this.newBuffer[element.getNews()].getStartLine(), this.newBuffer[element.getNews()].getStartLine() + bound);
        int newi = this.newBuffer[element.getNews()].getStartLine() + bound + 1;
        this.insertCount += element.getNewe() - element.getNews() - element.getOlde() + element.getOlds();
        System.out.println("... And insert " + this.newStream.getFileName() + "," + newi + (this.newBuffer[element.getNewe()].getEndLine() > newi ? ".." + this.newBuffer[element.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, newi, this.newBuffer[element.getNewe()].getEndLine());
    }

    public class Line
    implements Differ.ILine {
        private int[] kind;
        private String[] name;
        private int hash_code;
        private int start_line;
        private int start_column;
        private int end_line;
        private int end_column;
        private int buffer_length;

        public Line(IPrsStream stream, int start_token, int gate_token) {
            int size = gate_token > start_token ? gate_token - start_token : 0;
            int end_token = gate_token - 1;
            this.start_line = stream.getLine(start_token);
            this.start_column = stream.getColumn(start_token);
            if (size > 0) {
                this.end_line = stream.getEndLine(end_token);
                this.end_column = stream.getEndColumn(end_token);
            } else {
                this.end_line = stream.getLine(start_token);
                this.end_column = stream.getColumn(start_token);
            }
            this.kind = new int[size];
            this.name = new String[size];
            this.hash_code = size;
            for (int i = 0; i < size; ++i) {
                this.kind[i] = stream.getKind(start_token + i);
                this.name[i] = stream.getName(start_token + i);
                this.buffer_length += this.name[i].length() + 1;
                this.hash_code += this.kind[i];
            }
            this.hash_code += this.buffer_length;
        }

        public final int size() {
            return this.kind.length;
        }

        public final int hashCode() {
            return this.hash_code;
        }

        public final boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof Line) {
                Line another_line = (Line)anObject;
                if (this.kind.length == another_line.kind.length) {
                    int i;
                    for (i = 0; i < this.kind.length && this.kind[i] == another_line.kind[i] && this.name[i].equals(another_line.name[i]); ++i) {
                    }
                    return i == this.kind.length;
                }
            }
            return false;
        }

        public final int getStartLine() {
            return this.start_line;
        }

        public final int getStartColumn() {
            return this.start_column;
        }

        public final int getEndLine() {
            return this.end_line;
        }

        public final int getEndColumn() {
            return this.end_column;
        }

        public final String toString() {
            StringBuffer buffer = new StringBuffer(this.buffer_length);
            if (this.name.length > 0) {
                buffer.append(this.name[0]);
                for (int i = 1; i < this.name.length; ++i) {
                    buffer.append(" ");
                    buffer.append(this.name[i]);
                }
            }
            return buffer.toString();
        }
    }
}

