/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lpg.runtime.Adjunct;
import lpg.runtime.ErrorToken;
import lpg.runtime.ILexStream;
import lpg.runtime.IMessageHandler;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.LexStream;
import lpg.runtime.NullExportedSymbolsException;
import lpg.runtime.NullTerminalSymbolsException;
import lpg.runtime.ParseErrorCodes;
import lpg.runtime.SegmentedTuple;
import lpg.runtime.Token;
import lpg.runtime.UndefinedEofSymbolException;
import lpg.runtime.UnimplementedTerminalsException;
import lpg.runtime.Utf8LexStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrsStream
implements IPrsStream,
ParseErrorCodes {
    private ILexStream iLexStream;
    private int[] kindMap = null;
    private SegmentedTuple<IToken> tokens = new SegmentedTuple();
    private SegmentedTuple<IToken> adjuncts = new SegmentedTuple();
    private int index = 0;
    private int len = 0;

    public PrsStream() {
    }

    public PrsStream(ILexStream iLexStream) {
        this.iLexStream = iLexStream;
        if (iLexStream != null) {
            iLexStream.setPrsStream(this);
        }
        this.resetTokenStream();
    }

    @Override
    public String[] orderedExportedSymbols() {
        return null;
    }

    @Override
    public void remapTerminalSymbols(String[] ordered_parser_symbols, int eof_symbol) throws UndefinedEofSymbolException, NullExportedSymbolsException, NullTerminalSymbolsException, UnimplementedTerminalsException {
        if (this.iLexStream == null) {
            throw new NullPointerException("lpg.runtime.PrsStream.remapTerminalSymbols(..):  lexStream is null");
        }
        String[] ordered_lexer_symbols = this.iLexStream.orderedExportedSymbols();
        if (ordered_lexer_symbols == null) {
            throw new NullExportedSymbolsException();
        }
        if (ordered_parser_symbols == null) {
            throw new NullTerminalSymbolsException();
        }
        ArrayList<Integer> unimplemented_symbols = new ArrayList<Integer>();
        if (ordered_lexer_symbols != ordered_parser_symbols) {
            int i;
            this.kindMap = new int[ordered_lexer_symbols.length];
            HashMap<String, Integer> terminal_map = new HashMap<String, Integer>();
            for (i = 0; i < ordered_lexer_symbols.length; ++i) {
                terminal_map.put(ordered_lexer_symbols[i], new Integer(i));
            }
            for (i = 0; i < ordered_parser_symbols.length; ++i) {
                Integer k = (Integer)terminal_map.get(ordered_parser_symbols[i]);
                if (k != null) {
                    this.kindMap[k.intValue()] = i;
                    continue;
                }
                if (i == eof_symbol) {
                    throw new UndefinedEofSymbolException();
                }
                unimplemented_symbols.add(new Integer(i));
            }
        }
        if (unimplemented_symbols.size() > 0) {
            throw new UnimplementedTerminalsException(unimplemented_symbols);
        }
    }

    @Override
    public final int mapKind(int kind) {
        return this.kindMap == null ? kind : this.kindMap[kind];
    }

    @Override
    public void resetTokenStream() {
        this.tokens = new SegmentedTuple();
        this.index = 0;
        this.adjuncts = new SegmentedTuple();
    }

    @Override
    public void setLexStream(ILexStream lexStream) {
        this.iLexStream = lexStream;
        this.resetTokenStream();
    }

    public void resetLexStream(LexStream lexStream) {
        this.iLexStream = lexStream;
        if (lexStream != null) {
            lexStream.setPrsStream(this);
        }
    }

    @Override
    public void makeToken(int startLoc, int endLoc, int kind) {
        Token token = new Token(this, startLoc, endLoc, this.mapKind(kind));
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
    }

    @Override
    public void makeToken(IToken token, int offset_adjustment) {
        token.setStartOffset(token.getStartOffset() + offset_adjustment);
        token.setEndOffset(token.getEndOffset() + offset_adjustment);
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
    }

    @Override
    public void removeLastToken() {
        int last_index = this.tokens.size() - 1;
        Token token = (Token)this.tokens.get(last_index);
        this.adjuncts.reset(token.getAdjunctIndex());
        this.tokens.reset(last_index);
    }

    @Override
    public int makeErrorToken(int firsttok, int lasttok, int errortok, int kind) {
        int index = this.tokens.size();
        ErrorToken token = new ErrorToken(this.getIToken(firsttok), this.getIToken(lasttok), this.getIToken(errortok), this.getStartOffset(firsttok), this.getEndOffset(lasttok), kind);
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
        return index;
    }

    @Override
    public void addToken(IToken token) {
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
    }

    @Override
    public void makeAdjunct(int startLoc, int endLoc, int kind) {
        int token_index = this.tokens.size() - 1;
        Adjunct adjunct = new Adjunct(this, startLoc, endLoc, this.mapKind(kind));
        adjunct.setAdjunctIndex(this.adjuncts.size());
        adjunct.setTokenIndex(token_index);
        this.adjuncts.add(adjunct);
    }

    @Override
    public void makeAdjunct(IToken adjunct, int offset_adjustment) {
        int token_index = this.tokens.size() - 1;
        adjunct.setStartOffset(adjunct.getStartOffset() + offset_adjustment);
        adjunct.setEndOffset(adjunct.getEndOffset() + offset_adjustment);
        adjunct.setAdjunctIndex(this.adjuncts.size());
        adjunct.setAdjunctIndex(token_index);
        this.adjuncts.add(adjunct);
    }

    @Override
    public void addAdjunct(IToken adjunct) {
        int token_index = this.tokens.size() - 1;
        adjunct.setTokenIndex(token_index);
        adjunct.setAdjunctIndex(this.adjuncts.size());
        this.adjuncts.add(adjunct);
    }

    @Override
    public String getTokenText(int i) {
        IToken t = this.tokens.get(i);
        return ((Object)t).toString();
    }

    @Override
    public int getStartOffset(int i) {
        IToken t = this.tokens.get(i);
        return t.getStartOffset();
    }

    @Override
    public int getEndOffset(int i) {
        IToken t = this.tokens.get(i);
        return t.getEndOffset();
    }

    @Override
    public int getTokenLength(int i) {
        IToken t = this.tokens.get(i);
        return t.getEndOffset() - t.getStartOffset() + 1;
    }

    @Override
    public int getLineNumberOfTokenAt(int i) {
        IToken t = this.tokens.get(i);
        return this.iLexStream.getLineNumberOfCharAt(t.getStartOffset());
    }

    @Override
    public int getEndLineNumberOfTokenAt(int i) {
        IToken t = this.tokens.get(i);
        return this.iLexStream.getLineNumberOfCharAt(t.getEndOffset());
    }

    @Override
    public int getColumnOfTokenAt(int i) {
        IToken t = this.tokens.get(i);
        return this.iLexStream.getColumnOfCharAt(t.getStartOffset());
    }

    @Override
    public int getEndColumnOfTokenAt(int i) {
        IToken t = this.tokens.get(i);
        return this.iLexStream.getColumnOfCharAt(t.getEndOffset());
    }

    @Override
    public String[] orderedTerminalSymbols() {
        return null;
    }

    @Override
    public int getLineOffset(int i) {
        return this.iLexStream.getLineOffset(i);
    }

    @Override
    public int getLineOffsetOfLine(int i) {
        return this.iLexStream.getLineOffsetOfLine(i);
    }

    @Override
    public int getLineCount() {
        return this.iLexStream.getLineCount();
    }

    @Override
    public int getLineNumberOfCharAt(int i) {
        return this.iLexStream.getLineNumberOfCharAt(i);
    }

    @Override
    public int getColumnOfCharAt(int i) {
        return this.getColumnOfCharAt(i);
    }

    @Override
    public int getFirstErrorToken(int i) {
        return this.getFirstRealToken(i);
    }

    @Override
    public int getFirstRealToken(int i) {
        while (i >= this.len) {
            i = ((ErrorToken)this.tokens.get(i)).getFirstRealToken().getTokenIndex();
        }
        return i;
    }

    @Override
    public int getLastErrorToken(int i) {
        return this.getLastRealToken(i);
    }

    @Override
    public int getLastRealToken(int i) {
        while (i >= this.len) {
            i = ((ErrorToken)this.tokens.get(i)).getLastRealToken().getTokenIndex();
        }
        return i;
    }

    @Override
    public void addTokensInRangeToList(ArrayList<IToken> list, IToken start_token, IToken end_token) {
        assert (list != null);
        if (start_token == null || end_token == null) {
            return;
        }
        int token_index = start_token.getTokenIndex();
        if (start_token instanceof Adjunct) {
            IToken adjunct;
            for (int i = start_token.getAdjunctIndex(); i < this.adjuncts.size() && (adjunct = this.adjuncts.get(i)).getTokenIndex() == token_index; ++i) {
                list.add(adjunct);
                if (adjunct != end_token) continue;
                return;
            }
            ++token_index;
        }
        while (token_index < this.tokens.size()) {
            IToken adjunct;
            IToken token = this.tokens.get(token_index);
            list.add(token);
            if (token == end_token) {
                return;
            }
            for (int i = token.getAdjunctIndex(); i < this.adjuncts.size() && (adjunct = this.adjuncts.get(i)).getTokenIndex() == token_index; ++i) {
                list.add(adjunct);
                if (adjunct != end_token) continue;
                return;
            }
            ++token_index;
        }
    }

    @Override
    public char[] getInputChars() {
        return this.iLexStream instanceof LexStream ? ((LexStream)this.iLexStream).getInputChars() : null;
    }

    @Override
    public byte[] getInputBytes() {
        return this.iLexStream instanceof Utf8LexStream ? ((Utf8LexStream)this.iLexStream).getInputBytes() : null;
    }

    @Override
    public String toString(int first_token, int last_token) {
        return this.toString(this.tokens.get(first_token), this.tokens.get(last_token));
    }

    @Override
    public String toString(IToken t1, IToken t2) {
        return this.iLexStream.toString(t1.getStartOffset(), t2.getEndOffset());
    }

    @Override
    public int getSize() {
        return this.tokens.size();
    }

    public void setSize() {
        this.len = this.tokens.size();
    }

    @Override
    public int getTokenIndexAtCharacter(int offset) {
        int low = 0;
        int high = this.tokens.size();
        while (high > low) {
            int mid = (high + low) / 2;
            IToken mid_element = this.tokens.get(mid);
            if (offset >= mid_element.getStartOffset() && offset <= mid_element.getEndOffset()) {
                return mid;
            }
            if (offset < mid_element.getStartOffset()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return -(low - 1);
    }

    @Override
    public IToken getTokenAtCharacter(int offset) {
        int tokenIndex = this.getTokenIndexAtCharacter(offset);
        return tokenIndex < 0 ? null : this.getTokenAt(tokenIndex);
    }

    @Override
    public IToken getTokenAt(int i) {
        return this.tokens.get(i);
    }

    @Override
    public IToken getIToken(int i) {
        return this.tokens.get(i);
    }

    @Override
    public List<IToken> getTokens() {
        return this.tokens;
    }

    @Override
    public int getStreamIndex() {
        return this.index;
    }

    @Override
    public int getStreamLength() {
        return this.len;
    }

    @Override
    public void setStreamIndex(int index) {
        this.index = index;
    }

    @Override
    public void setStreamLength() {
        this.len = this.tokens.size();
    }

    @Override
    public void setStreamLength(int len) {
        this.len = len;
    }

    @Override
    public ILexStream getILexStream() {
        return this.iLexStream;
    }

    @Override
    public ILexStream getLexStream() {
        return this.iLexStream;
    }

    @Override
    public void dumpTokens() {
        if (this.getSize() <= 2) {
            return;
        }
        System.out.println(" Kind \tOffset \tLen \tLine \tCol \tText\n");
        for (int i = 1; i < this.getSize() - 1; ++i) {
            this.dumpToken(i);
        }
    }

    @Override
    public void dumpToken(int i) {
        System.out.print(" (" + this.getKind(i) + ")");
        System.out.print(" \t" + this.getStartOffset(i));
        System.out.print(" \t" + this.getTokenLength(i));
        System.out.print(" \t" + this.getLineNumberOfTokenAt(i));
        System.out.print(" \t" + this.getColumnOfTokenAt(i));
        System.out.print(" \t" + this.getTokenText(i));
        System.out.println();
    }

    @Override
    public ArrayList<IToken> incrementalResetAtCharacterOffset(int damage_offset) {
        int i;
        int token_index = this.getTokenIndexAtCharacter(damage_offset);
        int adjunct_index = -1;
        int n = token_index = token_index < 0 ? -token_index : token_index;
        if (this.getTokenAt(token_index).getEndOffset() + 1 < damage_offset) {
            int i2 = this.tokens.get(token_index).getAdjunctIndex();
            while (i2 < this.adjuncts.size() && this.adjuncts.get(i2).getTokenIndex() == token_index && this.adjuncts.get(i2).getStartOffset() < damage_offset) {
                adjunct_index = i2++;
            }
        }
        ArrayList<IToken> affected_tokens = new ArrayList<IToken>();
        int count = (adjunct_index >= 0 ? this.adjuncts.size() - adjunct_index : this.adjuncts.size() - this.tokens.get(token_index).getAdjunctIndex()) + (this.tokens.size() - token_index);
        if (adjunct_index >= 0) {
            assert (token_index < this.tokens.size());
            ++token_index;
            for (i = adjunct_index; i < this.tokens.get(token_index).getAdjunctIndex(); ++i) {
                affected_tokens.add(this.adjuncts.get(i));
            }
            this.adjuncts.reset(adjunct_index);
        } else {
            this.adjuncts.reset(this.tokens.get(token_index).getAdjunctIndex());
        }
        for (i = token_index; i < this.tokens.size() - 1; ++i) {
            affected_tokens.add(this.tokens.get(i));
            for (int k = this.tokens.get(i).getAdjunctIndex(); k < this.tokens.get(i + 1).getAdjunctIndex(); ++k) {
                affected_tokens.add(this.adjuncts.get(k));
            }
        }
        affected_tokens.add(this.tokens.get(this.tokens.size() - 1));
        this.tokens.reset(token_index);
        return affected_tokens;
    }

    private IToken[] getAdjuncts(int i) {
        int start_index = this.tokens.get(i).getAdjunctIndex();
        int end_index = i + 1 == this.tokens.size() ? this.adjuncts.size() : this.tokens.get(this.getNext(i)).getAdjunctIndex();
        int size = end_index - start_index;
        IToken[] slice = new IToken[size];
        int j = start_index;
        int k = 0;
        while (j < end_index) {
            slice[k] = this.adjuncts.get(j);
            ++j;
            ++k;
        }
        return slice;
    }

    @Override
    public IToken[] getFollowingAdjuncts(int i) {
        return this.getAdjuncts(i);
    }

    @Override
    public IToken[] getPrecedingAdjuncts(int i) {
        return this.getAdjuncts(this.getPrevious(i));
    }

    @Override
    public IToken getAdjunctAt(int i) {
        return this.adjuncts.get(i);
    }

    @Override
    public List<IToken> getAdjuncts() {
        return this.adjuncts;
    }

    @Override
    public int getToken() {
        this.index = this.getNext(this.index);
        return this.index;
    }

    @Override
    public int getToken(int end_token) {
        this.index = this.index < end_token ? this.getNext(this.index) : this.len - 1;
        return this.index;
    }

    @Override
    public int getKind(int i) {
        IToken t = this.tokens.get(i);
        return t.getKind();
    }

    @Override
    public int getNext(int i) {
        return ++i < this.len ? i : this.len - 1;
    }

    @Override
    public int getPrevious(int i) {
        return i <= 0 ? 0 : i - 1;
    }

    @Override
    public String getName(int i) {
        return this.getTokenText(i);
    }

    @Override
    public int peek() {
        return this.getNext(this.index);
    }

    @Override
    public void reset(int i) {
        this.index = this.getPrevious(i);
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public int badToken() {
        return 0;
    }

    @Override
    public int getLine(int i) {
        return this.getLineNumberOfTokenAt(i);
    }

    @Override
    public int getColumn(int i) {
        return this.getColumnOfTokenAt(i);
    }

    @Override
    public int getEndLine(int i) {
        return this.getEndLineNumberOfTokenAt(i);
    }

    @Override
    public int getEndColumn(int i) {
        return this.getEndColumnOfTokenAt(i);
    }

    @Override
    public boolean afterEol(int i) {
        return i < 1 ? true : this.getEndLineNumberOfTokenAt(i - 1) < this.getLineNumberOfTokenAt(i);
    }

    @Override
    public String getFileName() {
        return this.iLexStream.getFileName();
    }

    @Override
    public void setMessageHandler(IMessageHandler errMsg) {
        this.iLexStream.setMessageHandler(errMsg);
    }

    @Override
    public IMessageHandler getMessageHandler() {
        return this.iLexStream.getMessageHandler();
    }

    @Override
    public void reportError(int errorCode, int leftToken, int rightToken, String errorInfo) {
        String[] stringArray;
        if (errorInfo == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = errorInfo;
        }
        this.reportError(errorCode, leftToken, 0, rightToken, stringArray);
    }

    @Override
    public void reportError(int errorCode, int leftToken, int rightToken, String[] errorInfo) {
        this.reportError(errorCode, leftToken, 0, rightToken, errorInfo);
    }

    @Override
    public void reportError(int errorCode, int leftToken, int errorToken, int rightToken, String errorInfo) {
        String[] stringArray;
        if (errorInfo == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = errorInfo;
        }
        this.reportError(errorCode, leftToken, errorToken, rightToken, stringArray);
    }

    @Override
    public void reportError(int errorCode, int leftToken, int errorToken, int rightToken, String[] errorInfo) {
        this.iLexStream.reportLexicalError(errorCode, this.getStartOffset(leftToken), this.getEndOffset(rightToken), this.getStartOffset(errorToken), this.getEndOffset(errorToken), errorInfo == null ? new String[]{} : errorInfo);
    }
}

