/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

public class Stacks {
    public int STACK_INCREMENT = 1024;
    public int stateStackTop;
    public int[] stateStack;
    public int[] locationStack;
    public Object[] parseStack;

    public int getToken(int i) {
        return this.locationStack[this.stateStackTop + (i - 1)];
    }

    public Object getSym(int i) {
        return this.parseStack[this.stateStackTop + (i - 1)];
    }

    public void setSym1(Object ast) {
        this.parseStack[this.stateStackTop] = ast;
    }

    public void reallocateStacks() {
        int old_stack_length = this.stateStack == null ? 0 : this.stateStack.length;
        int stack_length = old_stack_length + this.STACK_INCREMENT;
        if (this.stateStack == null) {
            this.stateStack = new int[stack_length];
            this.locationStack = new int[stack_length];
            this.parseStack = new Object[stack_length];
        } else {
            this.stateStack = new int[stack_length];
            System.arraycopy(this.stateStack, 0, this.stateStack, 0, old_stack_length);
            this.locationStack = new int[stack_length];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, old_stack_length);
            this.parseStack = new Object[stack_length];
            System.arraycopy(this.parseStack, 0, this.parseStack, 0, old_stack_length);
        }
    }

    public void reallocateStateStack() {
        int old_stack_length = this.stateStack == null ? 0 : this.stateStack.length;
        int stack_length = old_stack_length + this.STACK_INCREMENT;
        if (this.stateStack == null) {
            this.stateStack = new int[stack_length];
        } else {
            this.stateStack = new int[stack_length];
            System.arraycopy(this.stateStack, 0, this.stateStack, 0, old_stack_length);
        }
    }

    public void allocateOtherStacks() {
        this.locationStack = new int[this.stateStack.length];
        this.parseStack = new Object[this.stateStack.length];
    }
}

