/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.RangeCoder;

import java.io.IOException;
import java.io.OutputStream;

public class Encoder {
    static final int kNumTopBits = 24;
    static final int kTopValue = 0x1000000;
    public static final int kTopValueMask = -16777216;
    static final int kBufferSize = 16384;
    byte[] buffer;
    int bufferPos;
    OutputStream Stream;
    public long Low;
    public int Range;
    int _ffNum;
    int _cache;
    long curPosition;

    public void SetStream(OutputStream outputStream) {
        this.Stream = outputStream;
        this.buffer = new byte[16384];
        this.bufferPos = 0;
    }

    public void ReleaseStream() {
        this.Stream = null;
        this.buffer = null;
    }

    public void Init() {
        this.curPosition = 0L;
        this.Low = 0L;
        this.Range = -1;
        this._ffNum = 0;
        this._cache = 0;
    }

    public void FlushData() throws IOException {
        for (int i = 0; i < 5; ++i) {
            this.ShiftLow();
        }
    }

    public void FlushStream() throws IOException {
        if (this.bufferPos >= 1) {
            this.Stream.write(this.buffer, 0, this.bufferPos);
        }
        this.Stream.flush();
    }

    public void writeStream(int n) throws IOException {
        this.buffer[this.bufferPos++] = (byte)n;
        if (this.bufferPos == 16384) {
            this.Stream.write(this.buffer);
            this.bufferPos = 0;
        }
    }

    public void ShiftLow() throws IOException {
        if (this.Low < 0xFF000000L || this.Low >> 32 == 1L) {
            this.writeStream(this._cache + (int)(this.Low >> 32));
            ++this.curPosition;
            while (this._ffNum != 0) {
                this.writeStream(255 + (int)(this.Low >> 32));
                ++this.curPosition;
                --this._ffNum;
            }
            this._cache = (int)this.Low >> 24;
        } else {
            ++this._ffNum;
        }
        this.Low = (this.Low & 0xFFFFFFL) << 8;
    }

    public void EncodeDirectBits(int n, int n2) throws IOException {
        for (int i = n2 - 1; i >= 0; --i) {
            this.Range >>>= 1;
            if ((n >> i & 1) == 1) {
                this.Low += (long)this.Range & 0xFFFFFFFFL;
            }
            if ((this.Range & 0xFF000000) != 0) continue;
            this.Range <<= 8;
            this.ShiftLow();
        }
    }

    public long GetProcessedSizeAdd() {
        return (long)this._ffNum + this.curPosition;
    }
}

