/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.RangeCoder;

import SevenZip.Compression.RangeCoder.BitDecoder;
import SevenZip.Compression.RangeCoder.Decoder;
import java.io.IOException;

public class BitTreeDecoder {
    BitDecoder[] Models;
    int NumBitLevels;

    public BitTreeDecoder(int n) {
        this.NumBitLevels = n;
        this.Models = new BitDecoder[1 << n];
        for (int i = 1; i < 1 << this.NumBitLevels; ++i) {
            this.Models[i] = new BitDecoder();
        }
    }

    public final void Init() {
        for (int i = 1; i < 1 << this.NumBitLevels; ++i) {
            this.Models[i].Init();
        }
    }

    public final int Decode(Decoder decoder) throws IOException {
        int n = 1;
        for (int i = this.NumBitLevels; i > 0; --i) {
            n = (n << 1) + this.Models[n].Decode(decoder);
        }
        return n - (1 << this.NumBitLevels);
    }

    public final int ReverseDecode(Decoder decoder) throws IOException {
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < this.NumBitLevels; ++i) {
            int n3 = this.Models[n].Decode(decoder);
            n <<= 1;
            n += n3;
            n2 |= n3 << i;
        }
        return n2;
    }

    public static final int ReverseDecode(BitDecoder[] bitDecoderArray, int n, Decoder decoder, int n2) throws IOException {
        int n3 = 1;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = bitDecoderArray[n + n3].Decode(decoder);
            n3 <<= 1;
            n3 += n5;
            n4 |= n5 << i;
        }
        return n4;
    }
}

