<?php
/**
* @package Mambo Open Source
* @subpackage Categories
* @copyright (C) 2005 - 2006 Mambo Foundation Inc.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* Mambo was originally developed by Miro (www.miro.com.au) in 2000. Miro assigned the copyright in Mambo to The Mambo Foundation in 2005 to ensure
* that Mambo remained free Open Source software owned and managed by the community.
* Mambo is Free Software
*/ 

class TOOLBAR_categories {
	/**
	* Draws the menu for Editing an existing category
	* @param int The published state (to display the inverse button)
	*/
	function _EDIT() {
		global $id;
		
		mosMenuBar::startTable();
		mosMenuBar::media_manager();
		mosMenuBar::spacer();
		mosMenuBar::save();
		mosMenuBar::spacer();
		mosMenuBar::apply();
		mosMenuBar::spacer();
		if ( $id ) {
			// for existing content items the button is renamed `close`
			mosMenuBar::cancel( 'cancel', T_('Close') );
		} else {
			mosMenuBar::cancel();
		}
		mosMenuBar::spacer();
		$section='';
		if (strstr($GLOBALS['section'], 'com_contact')){
		    $section = 'contact.';
		} 
		if (strstr($GLOBALS['section'], 'com_newsfeeds')){
		    $section = 'newsfeeds.';		    
		}
		if (strstr($GLOBALS['section'], 'com_weblinks')){
		    $section = 'weblinks.';		    
		}
		
		if ($GLOBALS['task'] == 'new') {
		    mosMenuBar::help( $section.'new' );
		} else {
		    mosMenuBar::help( $section.'edit' );
		}
		mosMenuBar::endTable();
	}
	/**
	* Draws the menu for Moving existing categories
	* @param int The published state (to display the inverse button)
	*/
	function _MOVE() {
		mosMenuBar::startTable();
		mosMenuBar::save( 'movesave' );
		mosMenuBar::spacer();
		mosMenuBar::cancel();
		mosMenuBar::spacer();
		mosMenuBar::help( 'move' );
		mosMenuBar::endTable();
	}
	/**
	* Draws the menu for Copying existing categories
	* @param int The published state (to display the inverse button)
	*/
	function _COPY() {
		mosMenuBar::startTable();
		mosMenuBar::save( 'copysave' );
		mosMenuBar::spacer();
		mosMenuBar::cancel();
		mosMenuBar::spacer();
		mosMenuBar::help( 'copy' );
		mosMenuBar::endTable();
	}
	/**
	* Draws the menu for Editing an existing category
	*/
	function _DEFAULT(){
		$section = mosGetParam( $_REQUEST, 'section', '' );

		mosMenuBar::startTable();
		mosMenuBar::publishList();
		mosMenuBar::spacer();
		mosMenuBar::unpublishList();
		mosMenuBar::spacer();
		mosMenuBar::addNewX();
		mosMenuBar::spacer();
		if ( $section == 'content' || ( $section > 0 ) ) {
			mosMenuBar::customX( 'moveselect', 'move.png', 'move_f2.png', T_('Move'), true );
			mosMenuBar::spacer();
			mosMenuBar::customX( 'copyselect', 'copy.png', 'copy_f2.png', T_('Copy'), true );
			mosMenuBar::spacer();
		}
		mosMenuBar::editListX();
		mosMenuBar::spacer();
		mosMenuBar::deleteList();
		mosMenuBar::spacer();
		
		$section='';
		
		if (strstr($GLOBALS['section'], 'com_contact')){
		    $section = 'contact.';
		} 
		if (strstr($GLOBALS['section'], 'com_newsfeeds')){
		    $section = 'newsfeeds.';		    
		}
		if (strstr($GLOBALS['section'], 'com_weblinks')){
		    $section = 'weblinks.';		    
		}
		mosMenuBar::help( $section.'manager' );
		mosMenuBar::endTable();
	}
}
?>
