<?php
/**
 * @package Mambo Open Source
 * @subpackage Languages
 * @author Carlos Souza <csouza@mambo-foundation.org>
 * @copyright (C) 2005 - 2006 Mambo Foundation Inc.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL * 
 *
 * Mambo was originally developed by Miro (www.miro.com.au) in 2000. Miro assigned the copyright in Mambo to The Mambo Foundation in 2005 to ensure 
 * that Mambo remained free Open Source software owned and managed by the community.
 * Mambo is Free Software
 */

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// ensure user has access to this component
if (!$acl->acl_check( 'administration', 'manage', 'users', $my->usertype, 'components', 'com_languages' ) ) {
    mosRedirect( 'index2.php', T_('You are not authorized to view this resource.') );
}

require_once(mamboCore::get('rootPath').'/includes/phpgettext/error.php');
require_once(mamboCore::get('rootPath').'/includes/phpgettext/phpgettext.catalog.php');
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'admin.languages.class.php');

$include_path = ini_set('include_path', ini_get('include_path').PATH_SEPARATOR.dirname(__FILE__));

$request =& Request::getInstance('com_languages');
$session =& $request->session();
if (isset($session['mosmsg'])) {
    $request->set('mosmsg',  $session['mosmsg']);
    unset($session['mosmsg']);
}

$lang = $session['lang'] = mosGetParam($_POST, 'lang', isset($session['lang']) ? $session['lang'] : mamboCore::get('mosConfig_lang'));
$mamboLanguage =& new mamboLanguage($lang);
$languages = $mamboLanguage->getLanguages();
$task = mosGetParam($_REQUEST, 'task', 'index');
$act  = mosGetParam($_REQUEST, 'act' , 'language');

$request->set('task',  $task);
$request->set('act',  $act);
$request->set('lang', $lang);
$request->set('languages', $languages);


$renderer =& Renderer::getInstance();
foreach ($request->get() as $key => $value) {
    $renderer->addvar($key, $value);
}

$controller = new Controller('com_languages');
$controller->forward($task);
ini_set('include_path', $include_path);

#dump($_REQUEST);

?>
