<?php
/**
* @package Mambo Open Source
* @subpackage Languages
* @copyright (C) 2005 - 2006 Mambo Foundation Inc.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* Mambo was originally developed by Miro (www.miro.com.au) in 2000. Miro assigned the copyright in Mambo to The Mambo Foundation in 2005 to ensure
* that Mambo remained free Open Source software owned and managed by the community.
* Mambo is Free Software
*/ 

class ToolBar
{
    var $request = array();
    var $map 	 = array();

    function ToolBar()
    {
        $this->request = $_REQUEST;
    }
    function display($method = null)
    {
        $task = isset($_REQUEST['task']) && !empty($_REQUEST['task']) ? $_REQUEST['task'] : 'index';
        if($task == 'index' && isset($_REQUEST['act'])) $task = $_REQUEST['act'];
        if (is_null($method))$method = $task;
        if (in_array($method,  array_keys($this->map)))$method = $this->map[$method];
        if ($method && strlen($method) > 2 && method_exists($this, $method))
        return $this->$method();
        return false;
    }
    function _default(){}
}

class languagesToolbar extends ToolBar {

    var $map = array('index' => 'language','extract' => 'language', 'sort' => 'catalogs', 'new' => 'newlang', 'save' => 'edit', 'auto_translate' => 'edit', 'convert' => 'edit', 'apply' => 'edit');

    function edit() {
        mosMenuBar::startTable();
        if ($this->request['act'] != 'catalogs') {
            #mosMenuBar::custom( 'translate', 'edit.png', 'edit_f2.png', T_('Manage Translations'), false );
            #mosMenuBar::spacer();
        } else {
            mosMenuBar::custom( 'auto_translate', 'copy.png', 'copy_f2.png', T_('Auto Translate'), false );
            mosMenuBar::spacer(20);
            mosMenuBar::apply();
            mosMenuBar::spacer();
        }
        mosMenuBar::save();
        mosMenuBar::spacer();
        mosMenuBar::cancel();
        mosMenuBar::spacer();
        #mosMenuBar::help( 'screen.languages.edit' );
        mosMenuBar::endTable();
    }
    function update() {
        mosMenuBar::startTable();
        mosMenuBar::cancel();
        mosMenuBar::spacer();
        #mosMenuBar::help( 'screen.languages.update' );
        mosMenuBar::endTable();
    }

    function language() {
        mosMenuBar::startTable();
        if (!is_dir(mamboCore::get('rootPath').'/language/untranslated')) {
            mosMenuBar::customX( 'extract', 'query.png', 'query.png', T_('Scan Sources'), false );
            mosMenuBar::spacer(50);
        }
        mosMenuBar::custom( 'translate', 'edit.png', 'edit_f2.png', T_('Manage Translations'), true );
        mosMenuBar::spacer();
        mosMenuBar::custom( 'export', 'upload.png', 'upload_f2.png', T_('Export'));
        mosMenuBar::spacer();
        mosMenuBar::addNewX();
        mosMenuBar::spacer();
        mosMenuBar::editListX( 'edit' );
        mosMenuBar::spacer();
        mosMenuBar::deleteList();
        mosMenuBar::spacer();
        #mosMenuBar::help( 'screen.languages.language' );
        mosMenuBar::endTable();
    }

    function newlang() {
        mosMenuBar::startTable();
        mosMenuBar::save();
        mosMenuBar::spacer();
        mosMenuBar::cancel();
        mosMenuBar::spacer();
        #mosMenuBar::help( 'screen.languages.main' );
        mosMenuBar::endTable();
    }

    function catalogs()
    {
        mosMenuBar::startTable();
        mosMenuBar::customX( 'update', 'publish.png', 'publish_f2.png', T_('Update'), false );
        mosMenuBar::spacer();
        mosMenuBar::editListX( 'edit' );
        mosMenuBar::spacer();
        mosMenuBar::cancel();
        mosMenuBar::spacer();
        #mosMenuBar::help( 'screen.languages.main' );
        mosMenuBar::endTable();
    }
}

$toolbar = new languagesToolbar('languages');
$toolbar->display();

?>