/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mapyrus.Argument;
import org.mapyrus.Constants;
import org.mapyrus.FileOrURL;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.GeographicDataset;

public class TextfileDataset
implements GeographicDataset {
    private LineNumberReader mReader;
    private String mFilename;
    private Process mProcess;
    private Character mDelimiter;
    private String mComment;
    private int mMaxFields;

    private String readLine() throws IOException {
        String string;
        while ((string = this.mReader.readLine()) != null && this.mComment.length() > 0 && string.startsWith(this.mComment)) {
        }
        return string;
    }

    public TextfileDataset(String string, String string2, InputStream inputStream) throws FileNotFoundException, IOException, MapyrusException {
        Object object;
        if (string.equals("-")) {
            this.mReader = new LineNumberReader(new InputStreamReader(inputStream));
        } else if (string.endsWith("|")) {
            object = string.substring(0, string.length() - 1).trim();
            String[] stringArray = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{object} : new String[]{"sh", "-c", object};
            this.mProcess = Runtime.getRuntime().exec(stringArray);
            this.mReader = new LineNumberReader(new InputStreamReader(this.mProcess.getInputStream()));
        } else {
            object = new FileOrURL(string);
            this.mReader = ((FileOrURL)object).getReader();
        }
        this.mFilename = string;
        this.mDelimiter = null;
        this.mComment = "#";
        this.mMaxFields = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("comment=")) {
                this.mComment = string3.substring(8);
                continue;
            }
            if (!string3.startsWith("delimiter=") || string3.length() != 11) continue;
            this.mDelimiter = new Character(string3.charAt(10));
        }
    }

    public String getProjection() {
        return "";
    }

    public Hashtable getMetadata() {
        return new Hashtable();
    }

    public String[] getFieldNames() {
        return null;
    }

    public Rectangle2D.Double getWorlds() {
        return new Rectangle2D.Double(-180.0, -90.0, 180.0, 90.0);
    }

    private boolean readNextRow(Row row) throws MapyrusException {
        int n;
        String string;
        try {
            string = this.readLine();
        }
        catch (IOException iOException) {
            throw new MapyrusException(iOException.getMessage() + ": " + this.mFilename);
        }
        if (string == null) {
            return false;
        }
        row.clear();
        Argument argument = new Argument(1, string);
        row.add(argument);
        if (this.mDelimiter == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                row.add(new Argument(1, string2));
            }
        } else {
            n = this.mDelimiter.charValue();
            int n2 = 0;
            int n3 = string.indexOf(n);
            if (n3 < 0) {
                row.add(argument);
            } else {
                while (n3 >= 0) {
                    if (n2 == n3) {
                        row.add(Argument.emptyString);
                    } else {
                        row.add(new Argument(1, string.substring(n2, n3)));
                    }
                    n2 = n3 + 1;
                    n3 = string.indexOf(n, n2);
                }
                row.add(new Argument(1, string.substring(n2)));
            }
        }
        if ((n = this.mMaxFields - row.size()) > 0) {
            while (n-- > 0) {
                row.add(Argument.emptyString);
            }
        } else if (n < 0) {
            this.mMaxFields = row.size();
        }
        return true;
    }

    public Row fetch() throws MapyrusException {
        Row row = new Row();
        Row row2 = this.readNextRow(row) ? row : null;
        return row2;
    }

    public void close() throws MapyrusException {
        block14: {
            try {
                if (this.mProcess != null) {
                    while (this.mReader.read() > 0) {
                    }
                }
                if (this.mProcess == null) break block14;
                try {
                    int n = this.mProcess.waitFor();
                    if (n != 0) {
                        throw new MapyrusException(MapyrusMessages.get("processerror") + ": " + this.mFilename);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new MapyrusException(interruptedException.getMessage());
                }
            }
            catch (IOException iOException) {
                throw new MapyrusException(iOException.getMessage());
            }
            finally {
                try {
                    this.mReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

