/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.geom;

import java.awt.geom.Point2D;
import org.mapyrus.NumericalAnalysis;

public class LineEquation {
    private double mA;
    private double mB;
    private double mC;
    private double mX1;
    private double mX2;
    private double mY1;
    private double mY2;

    public LineEquation(double d, double d2, double d3, double d4) {
        this.mA = d4 - d2;
        this.mB = d - d3;
        this.mC = d3 * d2 - d * d4;
        this.mX1 = d;
        this.mY1 = d2;
        this.mX2 = d3;
        this.mY2 = d4;
    }

    public LineEquation createParallel(double d) {
        double d2 = this.mX2 - this.mX1;
        double d3 = this.mY2 - this.mY1;
        double d4 = Math.atan2(d3, d2);
        double d5 = this.mX1 + Math.cos(d4 -= 1.5707963267948966) * d;
        double d6 = this.mY1 + Math.sin(d4) * d;
        LineEquation lineEquation = new LineEquation(d5, d6, d5 + d2, d6 + d3);
        return lineEquation;
    }

    public double getAngle() {
        double d = Math.atan2(this.mY2 - this.mY1, this.mX2 - this.mX1);
        return d;
    }

    private boolean isBetweenPoints(LineEquation lineEquation, double d, double d2) {
        boolean bl = true;
        if (lineEquation.mX1 <= lineEquation.mX2) {
            if (d < lineEquation.mX1 || d > lineEquation.mX2) {
                bl = false;
            }
        } else if (d > lineEquation.mX1 || d < lineEquation.mX2) {
            bl = false;
        }
        if (lineEquation.mY1 <= lineEquation.mY2) {
            if (d2 < lineEquation.mY1 || d2 > lineEquation.mY2) {
                bl = false;
            }
        } else if (d2 > lineEquation.mY1 || d2 < lineEquation.mY2) {
            bl = false;
        }
        return bl;
    }

    public Point2D.Double getStartPoint() {
        Point2D.Double double_ = new Point2D.Double(this.mX1, this.mY1);
        return double_;
    }

    public Point2D.Double getEndPoint() {
        Point2D.Double double_ = new Point2D.Double(this.mX2, this.mY2);
        return double_;
    }

    public Point2D.Double intersect(LineEquation lineEquation, boolean bl) {
        Point2D.Double double_;
        double d = this.mA * lineEquation.mB - lineEquation.mA * this.mB;
        if (NumericalAnalysis.equals(d, 0.0)) {
            double_ = null;
        } else {
            double d2 = (this.mB * lineEquation.mC - lineEquation.mB * this.mC) / d;
            double d3 = -(this.mA * lineEquation.mC - lineEquation.mA * this.mC) / d;
            double_ = new Point2D.Double(d2, d3);
            if (bl) {
                if (!this.isBetweenPoints(this, d2, d3)) {
                    double_ = null;
                }
                if (!this.isBetweenPoints(lineEquation, d2, d3)) {
                    double_ = null;
                }
            }
        }
        return double_;
    }

    public String toString() {
        return this.mA + "x + " + this.mB + "y + " + this.mC + " = 0";
    }

    public static void main(String[] stringArray) {
        LineEquation lineEquation = new LineEquation(5.0, 5.0, 10.0, 6.0);
        LineEquation lineEquation2 = new LineEquation(8.0, 4.0, 7.0, 17.0);
        Point2D.Double double_ = lineEquation.intersect(lineEquation2, false);
        System.out.println(double_);
    }
}

