/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.mapyrus.Constants;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;

public class FileOrURL {
    private String mName;
    private URL mURL;
    private BufferedInputStream mInputStream;
    private LineNumberReader mReader;
    private boolean mIsURL;

    public FileOrURL(String string) throws IOException, MapyrusException {
        InputStream inputStream;
        try {
            this.mURL = new URL(string);
            try {
                inputStream = this.mURL.openStream();
            }
            catch (IOException iOException) {
                throw new MapyrusException(MapyrusMessages.get("cannotopenurl") + ": " + this.mURL.toString() + Constants.LINE_SEPARATOR + iOException.getMessage());
            }
            this.mIsURL = true;
        }
        catch (MalformedURLException malformedURLException) {
            inputStream = new FileInputStream(string);
            this.mIsURL = false;
        }
        try {
            String string2 = string.toLowerCase();
            boolean bl = string2.endsWith(".gz") || string2.endsWith(".svgz");
            boolean bl2 = string2.endsWith(".zip");
            this.mInputStream = bl ? new BufferedInputStream(new GZIPInputStream(inputStream)) : (bl2 ? new BufferedInputStream(new ZipInputStream(inputStream)) : new BufferedInputStream(inputStream));
            this.mReader = new LineNumberReader(new InputStreamReader(this.mInputStream));
            this.mName = string;
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
    }

    public FileOrURL(String string, FileOrURL fileOrURL) throws IOException, MapyrusException {
        InputStream inputStream = null;
        try {
            this.mURL = fileOrURL != null ? new URL(fileOrURL.mURL, string) : new URL(string);
            try {
                inputStream = this.mURL.openStream();
            }
            catch (IOException iOException) {
                throw new MapyrusException(MapyrusMessages.get("cannotopenurl") + ": " + this.mURL.toString() + Constants.LINE_SEPARATOR + iOException.getMessage());
            }
            this.mIsURL = true;
            this.mName = this.mURL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            this.mURL = null;
        }
        if (this.mURL == null) {
            inputStream = new FileInputStream(string);
            this.mIsURL = false;
            this.mName = string;
        }
        try {
            boolean bl;
            boolean bl2 = string.endsWith(".gz") || string.endsWith(".GZ");
            boolean bl3 = bl = string.endsWith(".zip") || string.endsWith(".ZIP");
            this.mInputStream = bl2 ? new BufferedInputStream(new GZIPInputStream(inputStream)) : (bl ? new BufferedInputStream(new ZipInputStream(inputStream)) : new BufferedInputStream(inputStream));
            this.mReader = new LineNumberReader(new InputStreamReader(this.mInputStream));
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
    }

    public FileOrURL(Reader reader, String string) {
        this.mIsURL = false;
        this.mName = string;
        this.mReader = new LineNumberReader(reader);
        this.mInputStream = null;
    }

    public boolean isURL() {
        return this.mIsURL;
    }

    public String getURLContentType() throws IOException {
        return this.mURL.openConnection().getContentType();
    }

    public BufferedInputStream getInputStream() {
        return this.mInputStream;
    }

    public LineNumberReader getReader() {
        return this.mReader;
    }

    public String toString() {
        return this.mName;
    }
}

