/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import org.mapyrus.ColorDatabase;
import org.mapyrus.Constants;
import org.mapyrus.FileOrURL;
import org.mapyrus.FontCache;
import org.mapyrus.GeometricPath;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.PageMask;
import org.mapyrus.Throttle;
import org.mapyrus.font.AdobeFontMetrics;
import org.mapyrus.font.AdobeFontMetricsManager;
import org.mapyrus.font.PostScriptFont;
import org.mapyrus.font.StringDimension;
import org.mapyrus.font.TrueTypeFont;
import org.mapyrus.gui.MapyrusFrame;
import org.mapyrus.image.BlendComposite;
import org.mapyrus.image.ImageIOWrapper;
import org.mapyrus.io.ASCII85Writer;
import org.mapyrus.io.WildcardFile;
import org.mapyrus.pdf.PDFFile;
import org.mapyrus.ps.PostScriptFile;
import org.mapyrus.svg.SVGFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFormat {
    private static final int INTERNAL_IMAGE = 1;
    private static final int IMAGE_FILE = 2;
    private static final int SCREEN_WINDOW = 3;
    private static final int POSTSCRIPT_GEOMETRY = 4;
    private static final int POSTSCRIPT_IMAGE = 5;
    private static final int PDF = 6;
    private static final int SVG = 7;
    private static final int IMAGEMAP = 8;
    public static final int JUSTIFY_LEFT = 1;
    public static final int JUSTIFY_CENTER = 2;
    public static final int JUSTIFY_RIGHT = 4;
    public static final int JUSTIFY_TOP = 8;
    public static final int JUSTIFY_MIDDLE = 16;
    public static final int JUSTIFY_BOTTOM = 32;
    private static final int FONT_OUTLINE_MITER_LIMIT = 2;
    private static final String[] PDF_FONTS = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Symbol", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Times-Roman", "ZapfDingbats"};
    private String m_PDFFontPrefix;
    private String m_PDFImagePrefix;
    private String m_PDFGstatePrefix;
    private String m_SVGClipPathPrefix;
    private int m_outputType;
    private String m_formatName;
    private BufferedImage m_image;
    private String m_filename;
    private PrintWriter m_writer;
    private OutputStream m_outputStream;
    private Graphics2D m_graphics2D;
    private boolean m_isPipedOutput;
    private boolean m_isStandardOutput;
    private boolean m_isUpdatingFile;
    private Process m_outputProcess;
    private File m_tempFile;
    private PrintWriter m_imageMapWriter;
    private String m_uniqueKey;
    private Throttle m_throttle;
    private FontCache m_fontCache;
    private HashSet<String> m_suppliedFontResources;
    private HashSet<String> m_neededFontResources;
    private HashSet<String> m_encodeAsISOLatin1;
    private HashSet<String> m_reencodedFonts;
    private AdobeFontMetricsManager m_adobeFontMetrics;
    private ArrayList<String> m_afmFiles;
    private ArrayList<PostScriptFont> m_pfbFiles;
    private ArrayList<AdobeFontMetrics> m_PDFFonts;
    private HashMap<String, TrueTypeFont> m_TTFFonts;
    private double m_pageWidth;
    private double m_pageHeight;
    private double m_resolution;
    private String m_mediaBox;
    private double m_minimumLineWidth;
    private String m_fontName;
    private double m_fontSize;
    private int m_justificationShiftX;
    private int m_justificationShiftY;
    private double m_fontRotation;
    private double m_fontOutlineWidth;
    private double m_fontLineSpacing;
    private Font m_baseFont;
    private PageMask m_pageMask;
    private int m_clipPathCounter;
    private Stack<Integer> m_SVGOpenGTags;
    private int m_gradientCounter;
    private ArrayList<Integer> m_PDFFileOffsets;
    private StringWriter m_PDFGeometryStringWriter;
    private PrintWriter m_PDFGeometryWriter;
    private HashMap<String, String> m_PDFExtGStateObjects;
    private HashMap<String, StringWriter> m_PDFImageObjects;
    private ArrayList<PDFFile> m_PDFIncludedFiles;
    private ArrayList<ArrayList<Integer>> m_PDFIncludedPages;
    private DecimalFormat m_coordinateDecimal = new DecimalFormat("#.###", Constants.US_DECIMAL_FORMAT_SYMBOLS);

    private void writePostScriptHeader(double d, double d2, int n, boolean bl, ArrayList<PostScriptFont> arrayList, Color color) throws IOException, MapyrusException {
        long l = Math.round(d / 25.4 * 72.0);
        long l2 = Math.round(d2 / 25.4 * 72.0);
        StringBuffer stringBuffer = new StringBuffer("%!PS-Adobe-3.0");
        if (this.m_formatName.equals("eps") || this.m_formatName.equals("epsimage")) {
            stringBuffer.append(" EPSF-3.0");
        }
        this.writeLine(this.m_writer, stringBuffer.toString());
        if (bl) {
            this.writeLine(this.m_writer, "%%BoundingBox: 0 0 " + l2 + " " + l);
        } else {
            this.writeLine(this.m_writer, "%%BoundingBox: 0 0 " + l + " " + l2);
        }
        if (!this.m_formatName.equals("eps") && !this.m_formatName.equals("epsimage")) {
            this.writeLine(this.m_writer, "%%Pages: 1");
        }
        this.writeLine(this.m_writer, "%%DocumentData: Clean7Bit");
        this.writeLine(this.m_writer, "%%LanguageLevel: 2");
        this.writeLine(this.m_writer, "%%Creator: (Mapyrus " + Constants.getVersion() + ")");
        this.writeLine(this.m_writer, "%%OperatorMessage: (Mapyrus Output...)");
        Date date = new Date();
        this.writeLine(this.m_writer, "%%CreationDate: (" + date.toString() + ")");
        String string = System.getProperty("user.name");
        if (string != null) {
            this.writeLine(this.m_writer, "%%For: (" + string + ")");
        }
        this.writeLine(this.m_writer, "%%DocumentRequiredResources: (atend)");
        if (arrayList.size() > 0) {
            stringBuffer = new StringBuffer("%%DocumentSuppliedResources: font");
            for (PostScriptFont object : arrayList) {
                stringBuffer.append(" ").append(object.getName());
                this.m_suppliedFontResources.add(object.getName());
            }
            this.writeLine(this.m_writer, stringBuffer.toString());
        }
        this.writeLine(this.m_writer, "%%EndComments");
        this.writeLine(this.m_writer, "");
        this.writeLine(this.m_writer, "% Resolution " + n + " DPI");
        this.writeLine(this.m_writer, "%%BeginSetup");
        for (PostScriptFont postScriptFont : arrayList) {
            this.writeLine(this.m_writer, "%%BeginResource: font " + postScriptFont.getName());
            String string2 = postScriptFont.getFontDefinition();
            this.writeLine(this.m_writer, string2);
            this.writeLine(this.m_writer, "%%EndResource");
        }
        this.writeLine(this.m_writer, "%%EndSetup");
        this.writeLine(this.m_writer, "1 setlinewidth 0 setlinecap 0 setlinejoin");
        this.writeLine(this.m_writer, "[] 0 setdash 0 setgray 10 setmiterlimit");
        if (bl) {
            this.writeLine(this.m_writer, "% Turn page 90 degrees.");
            this.writeLine(this.m_writer, "90 rotate 0 " + l2 + " neg translate");
        }
        this.writeLine(this.m_writer, "0 0 " + l + " " + l2 + " rectclip");
        this.writeLine(this.m_writer, "/RG { setrgbcolor } bind def");
        if (color != null) {
            float[] fArray = color.getRGBColorComponents(null);
            this.writeLine(this.m_writer, "gsave");
            this.writeLine(this.m_writer, this.m_coordinateDecimal.format(fArray[0]) + " " + this.m_coordinateDecimal.format(fArray[1]) + " " + this.m_coordinateDecimal.format(fArray[2]) + " RG");
            this.writeLine(this.m_writer, "0 0 " + l + " " + l2 + " rectfill");
            this.writeLine(this.m_writer, "grestore");
        }
        this.writeLine(this.m_writer, "/m { moveto } bind def /l { lineto } bind def");
        this.writeLine(this.m_writer, "/c { curveto } bind def /h { closepath } bind def");
        this.writeLine(this.m_writer, "/S { stroke } bind def /f { fill } bind def");
        this.writeLine(this.m_writer, "/W { clip } bind def /n { newpath } bind def");
        this.writeLine(this.m_writer, "/ju { /fjy exch def /fjx exch def } bind def");
        this.writeLine(this.m_writer, "/font {");
        this.writeLine(this.m_writer, "/foutline exch def");
        this.writeLine(this.m_writer, "/flinespacing exch def");
        this.writeLine(this.m_writer, "/frot exch radtodeg def");
        this.writeLine(this.m_writer, "/fsize exch def findfont fsize scalefont setfont } def");
        this.writeLine(this.m_writer, "/radtodeg { 180 mul 3.1415629 div } bind def");
        this.writeLine(this.m_writer, "/t {");
        this.writeLine(this.m_writer, "/str exch def");
        this.writeLine(this.m_writer, "/nlines exch def");
        this.writeLine(this.m_writer, "/linenum exch def");
        this.writeLine(this.m_writer, "gsave currentpoint translate frot rotate");
        this.writeLine(this.m_writer, "% Shift label to correct justification");
        this.writeLine(this.m_writer, "1 fjx eq {0} if");
        this.writeLine(this.m_writer, "2 fjx eq {str stringwidth pop neg 2 div} if");
        this.writeLine(this.m_writer, "4 fjx eq {str stringwidth pop neg} if");
        this.writeLine(this.m_writer, "32 fjy eq {nlines 1 sub fsize mul flinespacing mul} if");
        this.writeLine(this.m_writer, "16 fjy eq {nlines fsize mul nlines 1 sub fsize mul flinespacing 1 sub mul add 2 div fsize sub} if");
        this.writeLine(this.m_writer, "8 fjy eq {fsize neg} if");
        this.writeLine(this.m_writer, "% Shift multi-line labels down");
        this.writeLine(this.m_writer, "linenum fsize mul flinespacing mul sub");
        this.writeLine(this.m_writer, "rmoveto");
        this.writeLine(this.m_writer, "% Draw label or label outline");
        this.writeLine(this.m_writer, "foutline 0 gt");
        this.writeLine(this.m_writer, "{str false charpath foutline w 0 j 0 J 2 M stroke}");
        this.writeLine(this.m_writer, "{str show}");
        this.writeLine(this.m_writer, "ifelse");
        this.writeLine(this.m_writer, "grestore newpath");
        this.writeLine(this.m_writer, "} bind def");
        this.writeLine(this.m_writer, "/w { setlinewidth } bind def");
        this.writeLine(this.m_writer, "/J { setlinecap } bind def");
        this.writeLine(this.m_writer, "/j { setlinejoin } bind def");
        this.writeLine(this.m_writer, "/M { setmiterlimit } bind def");
        this.writeLine(this.m_writer, "/d { setdash } bind def");
        this.writeLine(this.m_writer, "/q { gsave 12 dict begin } bind def");
        this.writeLine(this.m_writer, "/Q { end grestore } bind def");
        this.writeLine(this.m_writer, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePDFHeader(String string, double d, double d2, int n, boolean bl, ArrayList<PostScriptFont> arrayList, Color color) throws IOException, MapyrusException {
        long l = Math.round(d / 25.4 * 72.0);
        long l2 = Math.round(d2 / 25.4 * 72.0);
        this.m_pfbFiles = arrayList;
        this.m_PDFFileOffsets = new ArrayList();
        int n2 = this.writeLine(this.m_writer, "%PDF-1.4");
        this.m_PDFFileOffsets.add(new Integer(n2));
        n2 += this.writeLine(this.m_writer, "1 0 obj % Document Catalog");
        n2 += this.writeLine(this.m_writer, "<<");
        n2 += this.writeLine(this.m_writer, "/Type /Catalog");
        n2 += this.writeLine(this.m_writer, "/Outlines 3 0 R");
        n2 += this.writeLine(this.m_writer, "/Pages 4 0 R");
        n2 += this.writeLine(this.m_writer, ">>");
        this.m_PDFFileOffsets.add(new Integer(n2 += this.writeLine(this.m_writer, "endobj")));
        n2 += this.writeLine(this.m_writer, "2 0 obj % Document Metadata");
        n2 += this.writeLine(this.m_writer, "<<");
        n2 += this.writeLine(this.m_writer, "/Creator (Mapyrus " + Constants.getVersion() + ")");
        String string2 = System.getProperty("user.name");
        if (string2 != null) {
            n2 += this.writeLine(this.m_writer, "/Author (" + string2 + ")");
        }
        StringBuffer stringBuffer = new StringBuffer("D:");
        stringBuffer.append(new SimpleDateFormat("yyyyMMddHHmmssZZZZZ").format(new Date()));
        stringBuffer.insert(stringBuffer.length() - 2, '\'');
        stringBuffer.append('\'');
        n2 += this.writeLine(this.m_writer, "/CreationDate (" + stringBuffer.toString() + ")");
        n2 += this.writePostScriptString(this.m_writer, "/Title", string);
        n2 += this.writeLine(this.m_writer, ">>");
        this.m_PDFFileOffsets.add(new Integer(n2 += this.writeLine(this.m_writer, "endobj")));
        n2 += this.writeLine(this.m_writer, "3 0 obj % Document");
        n2 += this.writeLine(this.m_writer, "<<");
        n2 += this.writeLine(this.m_writer, "/Type /Outlines");
        n2 += this.writeLine(this.m_writer, "/Count 0");
        n2 += this.writeLine(this.m_writer, ">>");
        this.m_PDFFileOffsets.add(new Integer(n2 += this.writeLine(this.m_writer, "endobj")));
        n2 += this.writeLine(this.m_writer, "4 0 obj % Page Tree Node");
        n2 += this.writeLine(this.m_writer, "<<");
        n2 += this.writeLine(this.m_writer, "/Type /Pages");
        n2 += this.writeLine(this.m_writer, "/Kids [5 0 R]");
        n2 += this.writeLine(this.m_writer, "/Count 1");
        n2 += this.writeLine(this.m_writer, ">>");
        this.m_PDFFileOffsets.add(new Integer(n2 += this.writeLine(this.m_writer, "endobj")));
        this.m_mediaBox = bl ? "[0 0 " + l2 + " " + l + "]" : "[0 0 " + l + " " + l2 + "]";
        this.m_writer.flush();
        this.m_PDFExtGStateObjects = new HashMap();
        this.m_PDFImageObjects = new HashMap();
        this.m_PDFIncludedFiles = new ArrayList();
        this.m_PDFIncludedPages = new ArrayList();
        this.m_PDFGeometryStringWriter = new StringWriter();
        this.m_PDFGeometryWriter = new PrintWriter(this.m_PDFGeometryStringWriter);
        if (bl) {
            this.writeLine(this.m_PDFGeometryWriter, "0 1 -1 0 0 0 cm");
            this.writeLine(this.m_PDFGeometryWriter, "1 0 0 1 0 " + -l2 + " cm");
        }
        if (color != null) {
            float[] fArray = color.getColorComponents(null);
            this.writeLine(this.m_PDFGeometryWriter, "q");
            this.writeLine(this.m_PDFGeometryWriter, "0 0 " + l + " " + l2 + " re");
            for (int i = 0; i < fArray.length; ++i) {
                this.writeLine(this.m_PDFGeometryWriter, this.m_coordinateDecimal.format(fArray[i]));
            }
            this.writeLine(this.m_PDFGeometryWriter, "rg f Q");
        }
        this.writeLine(this.m_PDFGeometryWriter, "0 0 0 RG 0 0 0 rg");
        double d3 = 2.834645669291339;
        this.writeLine(this.m_PDFGeometryWriter, d3 + " 0 0 " + d3 + " 0 0 cm");
        for (int i = 0; i < this.m_afmFiles.size(); ++i) {
            String string3 = this.m_afmFiles.get(i);
            BufferedReader bufferedReader = null;
            AdobeFontMetrics adobeFontMetrics = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string3));
                adobeFontMetrics = new AdobeFontMetrics(bufferedReader, string3, this.m_encodeAsISOLatin1);
                this.m_PDFFonts.add(adobeFontMetrics);
                continue;
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
    }

    private void writePDFResources() throws IOException, MapyrusException {
        Serializable serializable;
        Object object;
        int n;
        Object object2;
        int n2;
        int n3 = 6;
        String string = "\r\n";
        StringBuffer stringBuffer = new StringBuffer(4096);
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        stringBuffer.append("<<").append(string);
        for (n2 = 0; n2 < PDF_FONTS.length; ++n2) {
            stringBuffer.append("/" + this.m_PDFFontPrefix + n2);
            stringBuffer.append(string);
            stringBuffer.append("<< /Type /Font /Subtype /Type1");
            stringBuffer.append(" /BaseFont /" + PDF_FONTS[n2] + " /Name /" + this.m_PDFFontPrefix + n2);
            if (this.m_encodeAsISOLatin1.contains(PDF_FONTS[n2])) {
                stringBuffer.append(" /Encoding /WinAnsiEncoding");
            }
            stringBuffer.append(" >>");
            stringBuffer.append(string);
        }
        for (n2 = 0; n2 < this.m_PDFFonts.size(); ++n2) {
            object2 = this.m_PDFFonts.get(n2);
            boolean bl = false;
            n = 0;
            object = null;
            while (n < this.m_pfbFiles.size() && !bl) {
                object = this.m_pfbFiles.get(n);
                if (((PostScriptFont)object).getName().equals(((AdobeFontMetrics)object2).getFontName())) {
                    bl = true;
                    continue;
                }
                ++n;
            }
            stringBuffer.append("/" + this.m_PDFFontPrefix + (PDF_FONTS.length + n2));
            stringBuffer.append(string);
            stringBuffer.append("<< /Type /Font /Subtype /Type1");
            stringBuffer.append(" /BaseFont /").append(((AdobeFontMetrics)object2).getFontName());
            stringBuffer.append(" /FirstChar ").append(((AdobeFontMetrics)object2).getFirstChar());
            stringBuffer.append(" /LastChar ").append(((AdobeFontMetrics)object2).getLastChar());
            stringBuffer.append(" /Widths ").append(n3).append(" 0 R");
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(n3).append(" 0 obj % Character Widths for ").append(((AdobeFontMetrics)object2).getFontName());
            ((StringBuffer)serializable).append(string);
            ++n3;
            ((StringBuffer)serializable).append("[");
            for (int i = ((AdobeFontMetrics)object2).getFirstChar(); i <= ((AdobeFontMetrics)object2).getLastChar(); ++i) {
                if (i % 16 == 0) {
                    ((StringBuffer)serializable).append(string);
                }
                ((StringBuffer)serializable).append(' ').append(((AdobeFontMetrics)object2).getCharWidth(i));
            }
            ((StringBuffer)serializable).append("]").append(string).append("endobj").append(string);
            arrayList.add(serializable);
            stringBuffer.append(" /FontDescriptor ").append(n3).append(" 0 R");
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(n3).append(" 0 obj % Font Descriptor");
            ((StringBuffer)serializable).append(string);
            ++n3;
            ((StringBuffer)serializable).append("<<");
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/Type /FontDescriptor");
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/FontName /").append(((AdobeFontMetrics)object2).getFontName());
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/Flags ").append(((AdobeFontMetrics)object2).getFlags());
            ((StringBuffer)serializable).append(string);
            Rectangle rectangle = ((AdobeFontMetrics)object2).getFontBBox();
            ((StringBuffer)serializable).append("/FontBBox [" + Math.round(rectangle.getMinX()) + " " + Math.round(rectangle.getMinY()) + " " + Math.round(rectangle.getMaxX()) + " " + Math.round(rectangle.getMaxY()) + "]");
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/ItalicAngle ").append(((AdobeFontMetrics)object2).getItalicAngle());
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/Ascent ").append(((AdobeFontMetrics)object2).getAscender());
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/Descent ").append(((AdobeFontMetrics)object2).getDescender());
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/CapHeight ").append(((AdobeFontMetrics)object2).getCapHeight());
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append("/StemV 105");
            ((StringBuffer)serializable).append(string);
            if (bl) {
                ((StringBuffer)serializable).append("/FontFile ").append(n3).append(" 0 R").append(string);
            }
            ((StringBuffer)serializable).append(">>").append(string);
            ((StringBuffer)serializable).append("endobj").append(string);
            arrayList.add(serializable);
            if (bl) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(n3).append(" 0 obj % Font File for ").append(((PostScriptFont)object).getName());
                ((StringBuffer)serializable).append(string);
                ++n3;
                ((StringBuffer)serializable).append(((PostScriptFont)object).getFontDefinition()).append(string);
                ((StringBuffer)serializable).append("endobj").append(string);
                arrayList.add(serializable);
            }
            if (this.m_encodeAsISOLatin1.contains(((AdobeFontMetrics)object2).getFontName())) {
                stringBuffer.append("/Encoding /WinAnsiEncoding");
            }
            stringBuffer.append(" >>").append(string);
        }
        for (n2 = 0; n2 < this.m_PDFIncludedFiles.size(); ++n2) {
            object2 = this.m_PDFIncludedFiles.get(n2);
            ArrayList<Integer> arrayList2 = this.m_PDFIncludedPages.get(n2);
            for (n = 0; n < arrayList2.size(); ++n) {
                object = arrayList2.get(n);
                serializable = ((PDFFile)object2).getFont((Integer)object, n3);
                if (serializable == null || ((ArrayList)serializable).isEmpty()) continue;
                stringBuffer.append(((ArrayList)serializable).get(0).toString());
                for (int i = 1; i < ((ArrayList)serializable).size(); ++i) {
                    arrayList.add((Serializable)((ArrayList)serializable).get(i));
                    ++n3;
                }
            }
        }
        stringBuffer.append(">>").append(string);
        Integer n4 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
        int n5 = n4;
        n5 += this.writeLine(this.m_writer, "5 0 obj % Single Page");
        n5 += this.writeLine(this.m_writer, "<<");
        n5 += this.writeLine(this.m_writer, "/Type /Page");
        n5 += this.writeLine(this.m_writer, "/Parent 4 0 R");
        n5 += this.writeLine(this.m_writer, "/MediaBox " + this.m_mediaBox);
        n5 += this.writeLine(this.m_writer, "/Contents " + n3 + " 0 R");
        n5 += this.writeLine(this.m_writer, "/Resources");
        n5 += this.writeLine(this.m_writer, "<<");
        n5 += this.writeLine(this.m_writer, "/ProcSet [/PDF /Text /ImageB /ImageC]");
        n5 += this.writeLine(this.m_writer, "/ExtGState " + ++n3 + " 0 R");
        n5 += this.writeLine(this.m_writer, "/ColorSpace " + ++n3 + " 0 R");
        n5 += this.writeLine(this.m_writer, "/Pattern " + ++n3 + " 0 R");
        n5 += this.writeLine(this.m_writer, "/Shading " + ++n3 + " 0 R");
        n5 += this.writeLine(this.m_writer, "/XObject " + ++n3 + " 0 R");
        ++n3;
        n5 += this.writeLine(this.m_writer, "/Font");
        n5 += this.writeLine(this.m_writer, stringBuffer.toString());
        n5 += this.writeLine(this.m_writer, ">>");
        n5 += this.writeLine(this.m_writer, ">>");
        this.m_PDFFileOffsets.add(new Integer(n5 += this.writeLine(this.m_writer, "endobj")));
        for (int i = 0; i < arrayList.size(); ++i) {
            this.m_PDFFileOffsets.add(new Integer(n5 += this.writeLine(this.m_writer, ((StringBuffer)arrayList.get(i)).toString())));
        }
    }

    private void writePostScriptScaling() {
        this.writeLine(this.m_writer, "% Set scaling so that (x, y) coordinates are given in millimetres");
        this.writeLine(this.m_writer, "72 25.4 div dup scale");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSVGHeader(double d, double d2, String string, Color color) throws IOException, MapyrusException {
        String[] stringArray;
        this.writeLine(this.m_writer, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?>");
        Date date = new Date();
        this.writeLine(this.m_writer, "<!-- Created by Mapyrus " + Constants.getVersion() + " on " + date.toString() + " -->");
        double d3 = (double)Constants.getScreenResolution() / 25.4;
        this.writeLine(this.m_writer, "<svg width=\"" + this.m_coordinateDecimal.format(d * d3) + "\"");
        this.writeLine(this.m_writer, "  height=\"" + this.m_coordinateDecimal.format(d2 * d3) + "\"");
        this.writeLine(this.m_writer, "  version=\"1.1\"");
        this.writeLine(this.m_writer, "  overflow=\"hidden\"");
        this.writeLine(this.m_writer, "  xml:space=\"preserve\"");
        this.writeLine(this.m_writer, "  xmlns=\"http://www.w3.org/2000/svg\">");
        if (string != null) {
            stringArray = null;
            try {
                String string2;
                stringArray = new FileOrURL(string).getReader();
                while ((string2 = stringArray.readLine()) != null) {
                    this.writeLine(this.m_writer, string2);
                }
            }
            finally {
                if (stringArray != null) {
                    stringArray.close();
                }
            }
        }
        if (color != null) {
            this.writeLine(this.m_writer, "<rect x=\"0\" y=\"0\" width=\"100%\"");
            this.writeLine(this.m_writer, "  height=\"100%\" stroke=\"none\"");
            this.writeLine(this.m_writer, "  fill=\"" + ColorDatabase.toHexString(color) + "\" fill-opacity=\"1\"/>");
        }
        this.writeLine(this.m_writer, "<g transform=\"scale(" + d3 + ")\"");
        this.writeLine(this.m_writer, "  style=\"fill-rule:nonzero;fill-opacity:1;stroke-opacity:1;stroke-dasharray:none;\"");
        this.writeLine(this.m_writer, "  clip-rule=\"nonzero\">");
        this.m_SVGOpenGTags.push(1);
        this.writeLine(this.m_writer, "<defs>");
        stringArray = new String[]{"normal", "multiply", "screen", "darken", "lighten"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.writeLine(this.m_writer, "<filter id=\"" + stringArray[i] + "\">");
            this.writeLine(this.m_writer, "<feBlend mode=\"" + stringArray[i] + "\" in2=\"BackgroundImage\" in=\"SourceGraphic\"/>");
            this.writeLine(this.m_writer, "</filter>");
        }
        this.writeLine(this.m_writer, "</defs>");
    }

    private void setupBufferedImage(double d, Color color, boolean bl, boolean bl2, boolean bl3) {
        double d2 = d / 25.4;
        if (color != null) {
            Color color2 = this.m_graphics2D.getColor();
            this.m_graphics2D.setColor(color);
            this.m_graphics2D.fillRect(0, 0, this.m_image.getWidth(), this.m_image.getHeight());
            this.m_graphics2D.setColor(color2);
        }
        this.m_graphics2D.translate(0, this.m_image.getHeight());
        this.m_graphics2D.scale(d2, -d2);
        if (bl) {
            this.m_graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        } else {
            this.m_graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
        }
        if (bl2) {
            this.m_graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        } else {
            this.m_graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
        }
        if (bl3) {
            this.m_graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
        } else {
            this.m_graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF));
        }
    }

    private boolean isSupportedImageFormat(String string) {
        boolean bl = false;
        String[] stringArray = ImageIOWrapper.getWriterFormatNames();
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    private String isoLatinEncode(String string) {
        return "/" + string + " findfont" + Constants.LINE_SEPARATOR + "dup length dict begin" + Constants.LINE_SEPARATOR + "{1 index /FID ne {def} {pop pop} ifelse} forall" + Constants.LINE_SEPARATOR + "/Encoding ISOLatin1Encoding def" + Constants.LINE_SEPARATOR + "currentdict" + Constants.LINE_SEPARATOR + "end" + Constants.LINE_SEPARATOR + "/" + string + " exch definefont pop";
    }

    private String getUniqueKey() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = System.currentTimeMillis() & Integer.MAX_VALUE;
        String string = Long.toHexString(l);
        int n = 8 - string.length();
        stringBuffer.append("Mapyrus".charAt(0));
        while (n-- > 0) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOutput(String string, double d, double d2, String string2, PrintStream printStream) throws IOException, MapyrusException {
        Object object;
        Object object2;
        ArrayList<PostScriptFont> arrayList = new ArrayList<PostScriptFont>();
        this.m_encodeAsISOLatin1 = new HashSet();
        this.m_reencodedFonts = new HashSet();
        this.m_TTFFonts = new HashMap();
        this.m_PDFFonts = new ArrayList();
        this.m_afmFiles = new ArrayList();
        this.m_SVGOpenGTags = new Stack();
        this.m_isUpdatingFile = false;
        boolean bl = false;
        Color color = null;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = null;
        Rectangle rectangle = null;
        this.m_uniqueKey = this.getUniqueKey();
        this.m_PDFFontPrefix = this.m_uniqueKey + "F";
        this.m_PDFImagePrefix = this.m_uniqueKey + "Img";
        this.m_PDFGstatePrefix = this.m_uniqueKey + "Gstate";
        this.m_SVGClipPathPrefix = this.m_uniqueKey + "C";
        int n = this.m_outputType == 4 ? 300 : (this.m_outputType == 6 ? 72 : Constants.getScreenResolution());
        this.m_adobeFontMetrics = null;
        this.m_minimumLineWidth = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            Iterator<String> iterator;
            Object object3;
            object2 = stringTokenizer.nextToken();
            if (((String)object2).startsWith("pfafiles=") && this.m_outputType != 6 || ((String)object2).startsWith("pfbfiles=") && this.m_outputType == 6) {
                boolean bl6 = this.m_outputType == 6;
                object = new StringTokenizer(((String)object2).substring(9), ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    object3 = ((StringTokenizer)object).nextToken();
                    if (((String)object3).length() <= 0) continue;
                    if (!this.m_throttle.isIOAllowed()) {
                        throw new MapyrusException(MapyrusMessages.get("noio") + ": " + (String)object3);
                    }
                    iterator = new WildcardFile((String)object3);
                    Iterator<String> iterator2 = ((WildcardFile)((Object)iterator)).getMatchingFiles().iterator();
                    while (iterator2.hasNext()) {
                        arrayList.add(new PostScriptFont(iterator2.next(), bl6));
                    }
                }
            }
            if (((String)object2).startsWith("afmfiles=")) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(((String)object2).substring(9), ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    object = stringTokenizer2.nextToken();
                    if (((String)object).length() <= 0) continue;
                    if (!this.m_throttle.isIOAllowed()) {
                        throw new MapyrusException(MapyrusMessages.get("noio") + ": " + (String)object);
                    }
                    object3 = new WildcardFile((String)object);
                    iterator = ((WildcardFile)object3).getMatchingFiles().iterator();
                    while (iterator.hasNext()) {
                        this.m_afmFiles.add((String)iterator.next());
                    }
                }
                continue;
            }
            if (((String)object2).startsWith("isolatinfonts=")) {
                StringTokenizer stringTokenizer3 = new StringTokenizer(((String)object2).substring(14), ",");
                while (stringTokenizer3.hasMoreTokens()) {
                    object = stringTokenizer3.nextToken();
                    if (((String)object).length() <= 0) continue;
                    this.m_encodeAsISOLatin1.add((String)object);
                }
                continue;
            }
            if (((String)object2).startsWith("resolution=")) {
                String string4 = ((String)object2).substring(11);
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MapyrusException(MapyrusMessages.get("invalidpageresolution") + ": " + string4);
                }
                if (n >= 1) continue;
                throw new MapyrusException(MapyrusMessages.get("invalidpageresolution") + ": " + string4);
            }
            if (((String)object2).startsWith("ttffiles=")) {
                StringTokenizer stringTokenizer4 = new StringTokenizer(((String)object2).substring(9), ",");
                while (stringTokenizer4.hasMoreTokens()) {
                    object = stringTokenizer4.nextToken();
                    if (((String)object).length() <= 0) continue;
                    if (!this.m_throttle.isIOAllowed()) {
                        throw new MapyrusException(MapyrusMessages.get("noio") + ": " + (String)object);
                    }
                    object3 = new WildcardFile((String)object);
                    for (String string4 : ((WildcardFile)object3).getMatchingFiles()) {
                        TrueTypeFont trueTypeFont = new TrueTypeFont(string4);
                        String string5 = trueTypeFont.getName();
                        this.m_TTFFonts.put(string5, trueTypeFont);
                        this.m_TTFFonts.put(string5.toLowerCase(), trueTypeFont);
                        this.m_TTFFonts.put(string5.toUpperCase(), trueTypeFont);
                    }
                }
                continue;
            }
            if (((String)object2).startsWith("turnpage=")) {
                String string6 = ((String)object2).substring(9);
                bl = string6.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("labelantialiasing=")) {
                String string7 = ((String)object2).substring(18);
                bl2 = string7.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("lineantialiasing=")) {
                String string8 = ((String)object2).substring(17);
                bl3 = string8.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("fractionalfontmetrics=")) {
                String string9 = ((String)object2).substring(22);
                bl4 = string9.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("update=") && this.m_outputType != 7 && this.m_outputType != 6) {
                String string10 = ((String)object2).substring(7);
                this.m_isUpdatingFile = string10.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("compress=")) {
                String string11 = ((String)object2).substring(9);
                bl5 = string11.equalsIgnoreCase("true");
                continue;
            }
            if (((String)object2).startsWith("imagemap=") && this.m_outputType == 2) {
                String string12 = ((String)object2).substring(9);
                if (!this.m_throttle.isIOAllowed()) {
                    throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string12);
                }
                this.m_imageMapWriter = new PrintWriter(new FileWriter(string12));
                continue;
            }
            if (((String)object2).startsWith("background=")) {
                String string13 = ((String)object2).substring(11);
                color = ColorDatabase.getColor(string13, 255, Color.BLACK);
                if (color != null) continue;
                throw new MapyrusException(MapyrusMessages.get("colornotfound") + ": " + string13);
            }
            if (((String)object2).startsWith("scriptfile=")) {
                string3 = ((String)object2).substring(11);
                if (this.m_throttle.isIOAllowed()) continue;
                throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string3);
            }
            if (!((String)object2).startsWith("minimumlinewidth=")) continue;
            String string14 = ((String)object2).substring(17);
            try {
                this.m_minimumLineWidth = Double.parseDouble(string14);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MapyrusException(MapyrusMessages.get("invalidlinewidth") + ": " + numberFormatException.getMessage());
            }
        }
        if (!(this.m_outputType != 4 && this.m_outputType != 5 && this.m_outputType != 6 && this.m_outputType != 2 && this.m_outputType != 7 || this.m_isUpdatingFile)) {
            this.m_isPipedOutput = string.startsWith("|");
            this.m_isStandardOutput = string.equals("-");
            if (this.m_isPipedOutput) {
                if (!this.m_throttle.isIOAllowed()) {
                    throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string);
                }
                object2 = string.substring(1).trim();
                String[] stringArray = Constants.getOSName().indexOf("WIN") >= 0 ? new String[]{object2} : new String[]{"sh", "-c", object2};
                this.m_outputProcess = Runtime.getRuntime().exec(stringArray);
                this.m_outputStream = this.m_outputProcess.getOutputStream();
            } else if (this.m_isStandardOutput) {
                this.m_outputStream = printStream;
            } else {
                if (!this.m_throttle.isIOAllowed()) {
                    throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string);
                }
                this.m_outputStream = new FileOutputStream(string);
            }
            if (bl5) {
                this.m_outputStream = new GZIPOutputStream(this.m_outputStream);
            }
        }
        object2 = new File(string);
        if (this.m_isUpdatingFile) {
            if (!this.m_throttle.isIOAllowed()) {
                throw new MapyrusException(MapyrusMessages.get("noio") + ": " + string);
            }
            if (!((File)object2).canWrite()) {
                throw new IOException(MapyrusMessages.get("readonly") + ": " + string);
            }
        }
        if (this.m_outputType == 4 || this.m_outputType == 5 || this.m_outputType == 6) {
            if (this.m_isUpdatingFile) {
                PostScriptFile postScriptFile = new PostScriptFile(string);
                if (postScriptFile.getNumberOfPages() > 1) {
                    throw new MapyrusException(MapyrusMessages.get("notpsfile") + ": " + string);
                }
                rectangle = postScriptFile.getBoundingBox();
                d = rectangle.getMaxX() / 72.0 * 25.4;
                d2 = rectangle.getMaxY() / 72.0 * 25.4;
                this.m_tempFile = File.createTempFile("Mapyrus", null, new File(string).getAbsoluteFile().getParentFile());
                this.m_outputStream = new FileOutputStream(this.m_tempFile);
            }
            this.m_writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.m_outputStream)));
            this.m_suppliedFontResources = new HashSet();
            if (this.m_outputType == 6) {
                this.writePDFHeader(string, d, d2, n, bl, arrayList, color);
            } else {
                this.writePostScriptHeader(d, d2, n, bl, arrayList, color);
            }
            this.m_neededFontResources = new HashSet();
            if (this.m_isUpdatingFile) {
                this.writeLine(this.m_writer, "save");
                this.writeLine(this.m_writer, "/showpage {} def");
                this.writeLine(this.m_writer, "%%BeginDocument: " + string);
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new FileReader(string));
                    while ((object = bufferedReader.readLine()) != null) {
                        this.writeLine(this.m_writer, (String)object);
                    }
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                this.writeLine(this.m_writer, "%%EndDocument");
                this.writeLine(this.m_writer, "restore");
            }
            if (this.m_outputType != 6) {
                this.writePostScriptScaling();
            }
        } else if (this.m_outputType == 7) {
            this.m_writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.m_outputStream)));
            this.writeSVGHeader(d, d2, string3, color);
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            this.m_graphics2D = (Graphics2D)bufferedImage.getGraphics();
        }
        if (this.m_outputType != 4 && this.m_outputType != 7 && this.m_outputType != 6) {
            if (this.m_outputType == 2 || this.m_outputType == 3 || this.m_outputType == 5) {
                if (this.m_isUpdatingFile && this.m_outputType == 2) {
                    this.m_image = ImageIOWrapper.read((File)object2, Color.BLACK);
                    if (this.m_image == null) {
                        throw new MapyrusException(MapyrusMessages.get("invalidformat") + ": " + string);
                    }
                    d = (double)this.m_image.getWidth() / ((double)n / 25.4);
                    d2 = (double)this.m_image.getHeight() / ((double)n / 25.4);
                } else {
                    int n2 = (int)Math.round(d / 25.4 * (double)n);
                    int n3 = (int)Math.round(d2 / 25.4 * (double)n);
                    int n4 = this.m_formatName.equals("jpg") || this.m_formatName.equals("jpeg") || this.m_formatName.equals("ppm") || this.m_formatName.equals("bmp") ? 5 : 2;
                    this.m_image = new BufferedImage(n2, n3, n4);
                }
            } else if (this.m_outputType == 1) {
                d = (double)this.m_image.getWidth() / ((double)n / 25.4);
                d2 = (double)this.m_image.getHeight() / ((double)n / 25.4);
            }
            this.m_graphics2D = (Graphics2D)this.m_image.getGraphics();
            this.setupBufferedImage(n, color, bl3, bl2, bl4);
        }
        if (this.m_imageMapWriter != null) {
            this.m_imageMapWriter.println("<!-- HTML Imagemap created by Mapyrus for image " + string + " -->");
            this.m_imageMapWriter.println("<!-- Surround contents of this file with <map name=\"foo\"> ... </map> and -->");
            this.m_imageMapWriter.println("<!-- combine it with the image using HTML like <img src=\"" + string + "\" usemap=\"#foo\"> -->");
        }
        this.m_filename = string;
        this.m_pageWidth = d;
        this.m_pageHeight = d2;
        this.m_resolution = 25.4 / (double)n;
        this.m_fontCache = new FontCache();
        this.m_justificationShiftX = 1;
        this.m_justificationShiftY = 32;
        this.m_fontOutlineWidth = 0.0;
        this.m_fontLineSpacing = 1.0;
        this.m_fontRotation = Double.MAX_VALUE;
        this.m_pageMask = null;
    }

    public void setImageMapWriter(PrintWriter printWriter) {
        this.m_imageMapWriter = printWriter;
    }

    public OutputFormat(String string, String string2, double d, double d2, String string3, PrintStream printStream, Throttle throttle) throws IOException, MapyrusException {
        this.m_formatName = string2.toLowerCase();
        this.m_throttle = throttle;
        if (this.m_formatName.equals("ps") || this.m_formatName.equals("postscript") || this.m_formatName.equals("application/postscript")) {
            this.m_formatName = "ps";
            this.m_outputType = 4;
        } else if (this.m_formatName.equals("eps")) {
            this.m_outputType = 4;
        } else if (this.m_formatName.equals("epsimage")) {
            this.m_outputType = 5;
        } else if (this.m_formatName.equals("pdf") || this.m_formatName.equals("application/pdf")) {
            this.m_outputType = 6;
        } else if (this.m_formatName.equals("svg") || this.m_formatName.equals("image/svg+xml")) {
            this.m_formatName = "svg";
            this.m_outputType = 7;
        } else if (this.m_formatName.equals("screen")) {
            this.m_outputType = 3;
        } else {
            if (this.m_formatName.equals("image/x-portable-pixmap")) {
                this.m_formatName = "ppm";
            } else if (this.m_formatName.startsWith("image/")) {
                this.m_formatName = this.m_formatName.substring(6);
            }
            if (!this.isSupportedImageFormat(this.m_formatName)) {
                throw new MapyrusException(MapyrusMessages.get("invalidformat") + ": " + string2);
            }
            this.m_outputType = 2;
        }
        try {
            this.setOutput(string, d, d2, string3, printStream);
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage());
        }
    }

    public OutputFormat(BufferedImage bufferedImage, String string) throws IOException, MapyrusException {
        this.m_outputType = 1;
        this.m_image = bufferedImage;
        this.m_formatName = "png";
        this.m_throttle = new Throttle();
        PrintStream printStream = new PrintStream(new ByteArrayOutputStream());
        try {
            this.setOutput("", 0.0, 0.0, string, printStream);
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.getClass().getName() + ": " + securityException.getMessage());
        }
    }

    public double getPageWidth() {
        return this.m_pageWidth;
    }

    public double getPageHeight() {
        return this.m_pageHeight;
    }

    public String getPageFormat() {
        return this.m_formatName;
    }

    public double getResolution() {
        return this.m_resolution;
    }

    public StringDimension getStringDimension(String string, String string2, double d, double d2) throws IOException, MapyrusException {
        String string3;
        StringDimension stringDimension = new StringDimension();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = d;
        int n = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            double d7;
            Object object;
            if (this.m_outputType == 4 || this.m_outputType == 6) {
                if (this.m_adobeFontMetrics == null) {
                    this.m_adobeFontMetrics = new AdobeFontMetricsManager(this.m_afmFiles, this.m_encodeAsISOLatin1);
                }
                double d8 = d / 25.4 * 72.0;
                object = this.m_adobeFontMetrics.getStringDimension(string2, d8, string3);
                d7 = ((StringDimension)object).getWidth();
                double d9 = ((StringDimension)object).getAscent();
                double d10 = ((StringDimension)object).getDescent();
                d7 = d7 / 72.0 * 25.4;
                d9 = d9 / 72.0 * 25.4;
                d10 = d10 / 72.0 * 25.4;
                if (d7 > d3) {
                    d3 = d7;
                }
                if (n == 0) {
                    d4 += d;
                    d5 = d9;
                } else {
                    d4 += d * d2;
                    d5 += d * d2;
                }
                d6 = d10;
            } else {
                FontRenderContext fontRenderContext = this.m_graphics2D.getFontRenderContext();
                Rectangle2D rectangle2D = this.m_baseFont.getStringBounds(string3, fontRenderContext);
                object = this.m_baseFont.createGlyphVector(fontRenderContext, string3).getVisualBounds();
                d7 = rectangle2D.getWidth();
                if (d7 > d3) {
                    d3 = d7;
                }
                if (n == 0) {
                    d4 += d;
                    d5 = -((RectangularShape)object).getMinY();
                } else {
                    d4 += d * d2;
                    d5 += d * d2;
                }
                d6 = -(((RectangularShape)object).getMinY() + ((RectangularShape)object).getHeight());
            }
            ++n;
        }
        if (d6 > d5) {
            d6 = d5;
        }
        stringDimension.setSize(d3, d4, d5, d6);
        return stringDimension;
    }

    public PageMask getPageMask() {
        if (this.m_pageMask == null) {
            this.m_pageMask = new PageMask((int)Math.round(this.m_pageWidth), (int)Math.round(this.m_pageHeight));
        }
        return this.m_pageMask;
    }

    private int writeLine(PrintWriter printWriter, String string) {
        printWriter.write(string);
        printWriter.write("\r\n");
        return string.length() + 2;
    }

    private void writePostScriptOrPDFImage(BufferedImage bufferedImage, double d, double d2, double d3, double d4, double d5) throws IOException, MapyrusException {
        int n;
        PrintWriter printWriter;
        String string = null;
        if (this.m_PDFImageObjects != null) {
            string = this.m_PDFImagePrefix + this.m_PDFImageObjects.size();
        }
        StringWriter stringWriter = null;
        if (this.m_outputType == 6) {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
        } else {
            printWriter = this.m_writer;
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (n2 <= 16 || n3 <= 16) {
            n = 1;
        } else {
            double d6 = d3 / this.m_resolution;
            double d7 = d4 / this.m_resolution;
            n = 1;
            while ((double)(n3 / (n + 1)) > d7 && (double)(n2 / (n + 1)) > d6) {
                ++n;
            }
        }
        int n4 = (n2 + n - 1) / n;
        int n5 = (n3 + n - 1) / n;
        Color color = this.getSingleImageColor(bufferedImage);
        if (this.m_outputType == 6) {
            this.writeLine(this.m_PDFGeometryWriter, "q");
            this.writeLine(this.m_PDFGeometryWriter, "1 0 0 1 " + this.m_coordinateDecimal.format(d) + " " + this.m_coordinateDecimal.format(d2) + " cm % translate");
            double d8 = Math.sin(d5);
            double d9 = Math.cos(d5);
            this.writeLine(this.m_PDFGeometryWriter, this.m_coordinateDecimal.format(d9) + " " + this.m_coordinateDecimal.format(d8) + " " + this.m_coordinateDecimal.format(-d8) + " " + this.m_coordinateDecimal.format(d9) + " 0 0 cm % rotate " + this.m_coordinateDecimal.format(d5));
            this.writeLine(this.m_PDFGeometryWriter, this.m_coordinateDecimal.format(d3) + " 0 0 " + this.m_coordinateDecimal.format(d4) + " 0 0 cm % scale");
            this.writeLine(this.m_PDFGeometryWriter, "1 0 0 1 -0.5 -0.5 cm % translate");
            if (color != null) {
                float[] fArray = color.getColorComponents(null);
                this.writeLine(this.m_PDFGeometryWriter, this.m_coordinateDecimal.format(fArray[0]) + " " + this.m_coordinateDecimal.format(fArray[1]) + " " + this.m_coordinateDecimal.format(fArray[2]) + " rg");
            }
            this.writeLine(this.m_PDFGeometryWriter, "/" + string + " Do");
            this.writeLine(this.m_PDFGeometryWriter, "Q");
        } else {
            this.writeLine(printWriter, "q");
            this.writeLine(printWriter, "/DeviceRGB setcolorspace");
            this.writeLine(printWriter, d + " " + d2 + " translate");
            this.writeLine(printWriter, d5 + " radtodeg rotate");
            this.writeLine(printWriter, d3 + " " + d4 + " scale");
            this.writeLine(printWriter, "-0.5 -0.5 translate");
            if (color != null) {
                float[] fArray = color.getColorComponents(null);
                this.writeLine(printWriter, this.m_coordinateDecimal.format(fArray[0]) + " " + this.m_coordinateDecimal.format(fArray[1]) + " " + this.m_coordinateDecimal.format(fArray[2]) + " RG");
            }
        }
        this.writeLine(printWriter, "% original image size " + n2 + "x" + n3 + " with reduction factor " + n);
        this.writeLine(printWriter, "<<");
        if (this.m_outputType == 6) {
            this.writeLine(printWriter, "/Type /XObject /Subtype /Image");
            if (color == null) {
                this.writeLine(printWriter, "/ColorSpace /DeviceRGB");
            }
        } else {
            this.writeLine(printWriter, "/ImageType 1");
        }
        this.writeLine(printWriter, "/Width " + n4);
        this.writeLine(printWriter, "/Height " + n5);
        if (color != null) {
            this.writeLine(printWriter, "/BitsPerComponent 1");
            this.writeLine(printWriter, "/Decode [0 1]");
            if (this.m_outputType == 6) {
                this.writeLine(printWriter, "/ImageMask true");
            }
        } else {
            this.writeLine(printWriter, "/BitsPerComponent 8");
            this.writeLine(printWriter, "/Decode [0 1 0 1 0 1]");
        }
        if (this.m_outputType == 6) {
            this.writeLine(printWriter, "/Filter [/ASCII85Decode /FlateDecode]");
        } else {
            this.writeLine(printWriter, "/ImageMatrix [" + n4 + " 0 0 " + -n5 + " 0 " + n5 + "]");
            this.writeLine(printWriter, "/DataSource currentfile /ASCII85Decode filter");
            this.writeLine(printWriter, ">>");
            if (color != null) {
                this.writeLine(printWriter, "imagemask");
            } else {
                this.writeLine(printWriter, "image");
            }
        }
        StringWriter stringWriter2 = null;
        PrintWriter printWriter2 = null;
        if (this.m_outputType == 6) {
            int n6 = n5 * n4 * 3 / 2;
            stringWriter2 = new StringWriter(n6 + 1);
            printWriter2 = new PrintWriter(stringWriter2);
        } else {
            printWriter2 = printWriter;
        }
        ASCII85Writer aSCII85Writer = new ASCII85Writer(printWriter2, this.m_outputType == 6);
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n3; i += n) {
            this.m_throttle.sleep();
            for (int j = 0; j < n2; j += n) {
                int n9;
                int n10 = bufferedImage.getRGB(j, i);
                if (color != null) {
                    n9 = n10 >> 24 == 0 ? 1 : 0;
                    n7 |= (n9 <<= 7 - n8);
                    if (++n8 != 8 && j + n < n2) continue;
                    aSCII85Writer.write(n7);
                    n8 = 0;
                    n7 = 0;
                    continue;
                }
                n9 = n10 & 0xFF;
                int n11 = n10 >> 8 & 0xFF;
                int n12 = n10 >> 16 & 0xFF;
                aSCII85Writer.write(n12);
                aSCII85Writer.write(n11);
                aSCII85Writer.write(n9);
            }
        }
        aSCII85Writer.close();
        this.writeLine(printWriter2, "~>");
        if (this.m_outputType == 6) {
            printWriter2.flush();
            String string2 = stringWriter2.toString();
            this.writeLine(printWriter, "/Length " + (string2.length() + 2));
            this.writeLine(printWriter, ">>");
            this.writeLine(printWriter, "stream");
            this.writeLine(printWriter, string2);
            this.writeLine(printWriter, "endstream");
            printWriter.flush();
            this.m_PDFImageObjects.put(string, stringWriter);
        } else {
            this.writeLine(printWriter, "Q");
        }
    }

    public void saveState() {
        if (this.m_outputType == 4) {
            this.writeLine(this.m_writer, "q");
        } else if (this.m_outputType == 6) {
            this.writeLine(this.m_PDFGeometryWriter, "q");
        } else if (this.m_outputType == 7) {
            this.writeLine(this.m_writer, "<g>");
            this.m_SVGOpenGTags.push(1);
        }
    }

    public boolean restoreState() {
        boolean bl;
        if (this.m_outputType == 4) {
            this.writeLine(this.m_writer, "Q");
            bl = true;
        } else if (this.m_outputType == 6) {
            this.writeLine(this.m_PDFGeometryWriter, "Q");
            bl = false;
        } else {
            if (this.m_outputType == 7) {
                int n = this.m_SVGOpenGTags.pop();
                for (int i = 0; i < n; ++i) {
                    this.writeLine(this.m_writer, "</g>");
                }
            }
            bl = false;
        }
        return bl;
    }

    public void closeOutputFormat() throws IOException, MapyrusException {
        if (this.m_outputType == 4 || this.m_outputType == 5) {
            if (this.m_outputType == 5) {
                this.writePostScriptOrPDFImage(this.m_image, this.m_pageWidth / 2.0, this.m_pageHeight / 2.0, this.m_pageWidth, this.m_pageHeight, 0.0);
            }
            if (this.m_formatName.equals("ps")) {
                this.writeLine(this.m_writer, "showpage");
            }
            this.writeLine(this.m_writer, "%%Trailer");
            this.writeLine(this.m_writer, "%%DocumentNeededResources:");
            for (String string : this.m_neededFontResources) {
                if (this.m_suppliedFontResources.contains(string)) continue;
                this.writeLine(this.m_writer, "%%+ font " + string);
            }
            this.writeLine(this.m_writer, "%%EOF");
            if (this.m_isStandardOutput) {
                this.m_writer.flush();
            } else {
                this.m_writer.close();
            }
            if (this.m_writer.checkError()) {
                throw new MapyrusException(this.m_filename + ": " + MapyrusMessages.get("errorps"));
            }
            if (!(this.m_tempFile == null || new File(this.m_filename).delete() && this.m_tempFile.renameTo(new File(this.m_filename)))) {
                this.m_tempFile.delete();
                throw new MapyrusException(MapyrusMessages.get("readonly") + ": " + this.m_filename);
            }
        } else if (this.m_outputType == 6) {
            int n;
            Serializable serializable;
            Object object;
            this.writePDFResources();
            this.m_PDFGeometryWriter.flush();
            StringBuffer stringBuffer = this.m_PDFGeometryStringWriter.getBuffer();
            int n2 = stringBuffer.length();
            StringWriter stringWriter = new StringWriter(n2);
            ASCII85Writer aSCII85Writer = new ASCII85Writer(stringWriter, true);
            for (int i = 0; i < n2; ++i) {
                aSCII85Writer.write(stringBuffer.charAt(i));
            }
            aSCII85Writer.close();
            stringWriter.write("~>");
            StringBuffer stringBuffer2 = stringWriter.getBuffer();
            int n3 = stringBuffer2.length() + 2;
            int n4 = this.m_PDFFileOffsets.size();
            int n5 = this.writeLine(this.m_writer, n4 + " 0 obj % Geometry Object");
            ++n4;
            n5 += this.writeLine(this.m_writer, "<< /Length " + n3);
            n5 += this.writeLine(this.m_writer, "/Filter [/ASCII85Decode /FlateDecode] >>");
            n5 += this.writeLine(this.m_writer, "stream");
            n5 += this.writeLine(this.m_writer, stringBuffer2.toString());
            n5 += this.writeLine(this.m_writer, "endstream");
            Integer n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
            this.m_PDFFileOffsets.add(new Integer(n6 + (n5 += this.writeLine(this.m_writer, "endobj"))));
            n5 = this.writeLine(this.m_writer, n4 + " 0 obj % Graphics States");
            ++n4;
            n5 += this.writeLine(this.m_writer, "<<");
            Object[] objectArray = this.m_PDFExtGStateObjects.keySet().toArray();
            Arrays.sort(objectArray);
            int n7 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].toString();
                n5 += this.writeLine(this.m_writer, "/" + string + " " + (n4 + n7 + 4) + " 0 R");
                ++n7;
            }
            ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
            for (int i = 0; i < this.m_PDFIncludedFiles.size(); ++i) {
                PDFFile pDFFile = this.m_PDFIncludedFiles.get(i);
                object = this.m_PDFIncludedPages.get(i);
                for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                    Integer n8 = ((ArrayList)object).get(j);
                    serializable = pDFFile.getExtGState(n8, n4 + n7 + 4);
                    if (serializable == null || ((ArrayList)serializable).isEmpty()) continue;
                    n5 += this.writeLine(this.m_writer, ((ArrayList)serializable).get(0).toString());
                    for (int k = 1; k < ((ArrayList)serializable).size(); ++k) {
                        arrayList.add((StringBuffer)((ArrayList)serializable).get(k));
                        ++n7;
                    }
                }
            }
            n5 += this.writeLine(this.m_writer, ">>");
            n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
            this.m_PDFFileOffsets.add(new Integer(n6 + (n5 += this.writeLine(this.m_writer, "endobj"))));
            n5 = this.writeLine(this.m_writer, n4 + " 0 obj % ColorSpace");
            ++n4;
            n5 += this.writeLine(this.m_writer, "<<");
            ArrayList<StringBuffer> arrayList2 = new ArrayList<StringBuffer>();
            for (int i = 0; i < this.m_PDFIncludedFiles.size(); ++i) {
                object = this.m_PDFIncludedFiles.get(i);
                ArrayList<Integer> arrayList3 = this.m_PDFIncludedPages.get(i);
                for (int j = 0; j < arrayList3.size(); ++j) {
                    serializable = arrayList3.get(j);
                    ArrayList<StringBuffer> arrayList4 = ((PDFFile)object).getColorSpace((Integer)serializable, n4 + n7 + 3);
                    if (arrayList4 == null || arrayList4.isEmpty()) continue;
                    n5 += this.writeLine(this.m_writer, arrayList4.get(0).toString());
                    for (int k = 1; k < arrayList4.size(); ++k) {
                        arrayList2.add(arrayList4.get(k));
                        ++n7;
                    }
                }
            }
            n5 += this.writeLine(this.m_writer, ">>");
            n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
            this.m_PDFFileOffsets.add(new Integer(n6 + (n5 += this.writeLine(this.m_writer, "endobj"))));
            n5 = this.writeLine(this.m_writer, n4 + " 0 obj % Pattern");
            ++n4;
            n5 += this.writeLine(this.m_writer, "<<");
            n5 += this.writeLine(this.m_writer, ">>");
            n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
            this.m_PDFFileOffsets.add(new Integer(n6 + (n5 += this.writeLine(this.m_writer, "endobj"))));
            n5 = this.writeLine(this.m_writer, n4 + " 0 obj % Shading");
            ++n4;
            n5 += this.writeLine(this.m_writer, "<<");
            n5 += this.writeLine(this.m_writer, ">>");
            n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
            this.m_PDFFileOffsets.add(new Integer(n6 + (n5 += this.writeLine(this.m_writer, "endobj"))));
            n5 = this.writeLine(this.m_writer, n4 + " 0 obj % Image Dictionary");
            ++n4;
            n5 += this.writeLine(this.m_writer, "<<");
            Object[] objectArray2 = this.m_PDFImageObjects.keySet().toArray();
            Arrays.sort(objectArray2);
            for (int i = 0; i < objectArray2.length; ++i) {
                String string = objectArray2[i].toString();
                n5 += this.writeLine(this.m_writer, "/" + string + " " + (n4 + n7) + " 0 R");
                ++n7;
            }
            ArrayList<StringBuffer> arrayList5 = new ArrayList<StringBuffer>();
            for (n = 0; n < this.m_PDFIncludedFiles.size(); ++n) {
                PDFFile pDFFile = this.m_PDFIncludedFiles.get(n);
                serializable = this.m_PDFIncludedPages.get(n);
                for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                    Integer n9 = (Integer)((ArrayList)serializable).get(i);
                    ArrayList<StringBuffer> arrayList6 = pDFFile.getXObject(n9, n4 + n7);
                    if (arrayList6 == null || arrayList6.isEmpty()) continue;
                    n5 += this.writeLine(this.m_writer, arrayList6.get(0).toString());
                    for (int j = 1; j < arrayList6.size(); ++j) {
                        arrayList5.add(arrayList6.get(j));
                        ++n7;
                    }
                }
            }
            n5 += this.writeLine(this.m_writer, ">>");
            n5 += this.writeLine(this.m_writer, "endobj");
            for (n = 0; n < objectArray.length; ++n) {
                n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
                this.m_PDFFileOffsets.add(new Integer(n6 + n5));
                Object object2 = objectArray[n];
                n5 = this.writeLine(this.m_writer, n4 + " 0 obj % " + object2);
                n5 += this.writeLine(this.m_writer, this.m_PDFExtGStateObjects.get(object2).toString());
                n5 += this.writeLine(this.m_writer, "endobj");
                ++n4;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
                this.m_PDFFileOffsets.add(new Integer(n6 + n5));
                String string = ((StringBuffer)arrayList.get(n)).toString();
                n5 = this.writeLine(this.m_writer, string);
                ++n4;
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
                this.m_PDFFileOffsets.add(new Integer(n6 + n5));
                String string = ((StringBuffer)arrayList2.get(n)).toString();
                n5 = this.writeLine(this.m_writer, string);
                ++n4;
            }
            for (n = 0; n < objectArray2.length; ++n) {
                n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
                this.m_PDFFileOffsets.add(new Integer(n6 + n5));
                Object object3 = objectArray2[n];
                n5 = this.writeLine(this.m_writer, n4 + " 0 obj % " + object3);
                n5 += this.writeLine(this.m_writer, this.m_PDFImageObjects.get(object3).toString());
                n5 += this.writeLine(this.m_writer, "endobj");
                ++n4;
            }
            for (n = 0; n < arrayList5.size(); ++n) {
                n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
                this.m_PDFFileOffsets.add(new Integer(n6 + n5));
                String string = ((StringBuffer)arrayList5.get(n)).toString();
                n5 = this.writeLine(this.m_writer, string);
                ++n4;
            }
            this.writeLine(this.m_writer, "xref");
            this.writeLine(this.m_writer, "0 " + (this.m_PDFFileOffsets.size() + 1));
            this.writeLine(this.m_writer, "0000000000 65535 f");
            Iterator<Integer> iterator = this.m_PDFFileOffsets.iterator();
            while (iterator.hasNext()) {
                String string = ((Object)iterator.next()).toString();
                int n10 = 10 - string.length();
                StringBuffer stringBuffer3 = new StringBuffer();
                while (n10-- > 0) {
                    stringBuffer3.append('0');
                }
                stringBuffer3.append(string);
                stringBuffer3.append(" 00000 n");
                this.writeLine(this.m_writer, stringBuffer3.toString());
            }
            this.writeLine(this.m_writer, "trailer");
            this.writeLine(this.m_writer, "<<");
            this.writeLine(this.m_writer, "/Size " + (this.m_PDFFileOffsets.size() + 1));
            this.writeLine(this.m_writer, "/Root 1 0 R");
            this.writeLine(this.m_writer, "/Info 2 0 R");
            this.writeLine(this.m_writer, ">>");
            this.writeLine(this.m_writer, "startxref");
            n6 = this.m_PDFFileOffsets.get(this.m_PDFFileOffsets.size() - 1);
            this.writeLine(this.m_writer, Integer.toString(n6 + n5));
            this.writeLine(this.m_writer, "%%EOF");
            if (this.m_isStandardOutput) {
                this.m_writer.flush();
            } else {
                this.m_writer.close();
            }
            for (int i = 0; i < this.m_PDFIncludedFiles.size(); ++i) {
                PDFFile pDFFile = this.m_PDFIncludedFiles.get(i);
                pDFFile.close();
            }
            if (this.m_writer.checkError()) {
                throw new MapyrusException(this.m_filename + ": " + MapyrusMessages.get("errorps"));
            }
        } else if (this.m_outputType == 7) {
            int n = this.m_SVGOpenGTags.pop();
            for (int i = 0; i < n; ++i) {
                this.writeLine(this.m_writer, "</g>");
            }
            this.writeLine(this.m_writer, "</svg>");
            if (this.m_isStandardOutput) {
                this.m_writer.flush();
            } else {
                this.m_writer.close();
            }
            if (this.m_writer.checkError()) {
                throw new MapyrusException(this.m_filename + ": " + MapyrusMessages.get("errorsvg"));
            }
        } else if (this.m_outputType == 2) {
            if (this.m_isUpdatingFile) {
                this.m_outputStream = new FileOutputStream(this.m_filename);
            }
            ImageIOWrapper.write(this.m_image, this.m_formatName, this.m_outputStream);
            if (this.m_isStandardOutput) {
                this.m_outputStream.flush();
            } else {
                this.m_outputStream.close();
            }
        } else if (this.m_outputType == 3) {
            String string = "Mapyrus: " + this.m_filename;
            new MapyrusFrame(string, this.m_image);
        }
        this.m_image = null;
        this.m_graphics2D = null;
        if (this.m_outputType != 1 && this.m_isPipedOutput) {
            int n = 0;
            try {
                n = this.m_outputProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new MapyrusException(this.m_filename + ": " + interruptedException.getMessage());
            }
            if (n != 0) {
                throw new MapyrusException(MapyrusMessages.get("processerror") + ": " + n + ": " + this.m_filename);
            }
        }
        if (this.m_imageMapWriter != null) {
            this.m_imageMapWriter.close();
        }
    }

    public void setFontAttribute(String string, double d, double d2, double d3, double d4) throws IOException, MapyrusException {
        if (this.m_outputType == 4) {
            if (this.m_encodeAsISOLatin1.contains(string) && !this.m_reencodedFonts.contains(string)) {
                this.writeLine(this.m_writer, this.isoLatinEncode(string));
                this.m_reencodedFonts.add(string);
            }
            this.writeLine(this.m_writer, "/" + string + " " + d + " " + d2 + " " + d4 + " " + d3 + " font");
            this.m_neededFontResources.add(string);
        } else if (this.m_outputType != 6) {
            int n = 0;
            if (string.endsWith("-Bold")) {
                n = 1;
                string = string.substring(0, string.length() - 5);
            } else if (string.endsWith("-Italic")) {
                n = 2;
                string = string.substring(0, string.length() - 7);
            } else if (string.endsWith("-BoldItalic")) {
                n = 3;
                string = string.substring(0, string.length() - 11);
            }
            Font font = this.m_graphics2D.getFont();
            float f = (float)d;
            float f2 = font.getSize2D();
            String string2 = font.getName();
            if (f != f2 || n != font.getStyle() || !string.equals(string2) || d2 != this.m_fontRotation) {
                Object object;
                this.m_baseFont = this.m_fontCache.get(string, n, f, 0.0);
                if (this.m_baseFont == null) {
                    object = this.m_TTFFonts.get(string);
                    this.m_baseFont = object != null ? ((TrueTypeFont)object).getFont().deriveFont(n, f) : new Font(string, n, (int)f).deriveFont(f);
                    this.m_fontCache.put(string, n, f, 0.0, this.m_baseFont);
                }
                if ((object = this.m_fontCache.get(string, n, -f, d2)) == null) {
                    AffineTransform affineTransform = AffineTransform.getRotateInstance(d2);
                    affineTransform.scale(1.0, -1.0);
                    object = this.m_baseFont.deriveFont(affineTransform);
                    this.m_fontCache.put(string, n, -f, d2, (Font)object);
                }
                this.m_graphics2D.setFont((Font)object);
            }
        }
        this.m_fontRotation = d2;
        this.m_fontOutlineWidth = d3;
        this.m_fontLineSpacing = d4;
        this.m_fontName = string;
        this.m_fontSize = d;
    }

    public void setJustifyAttribute(int n) {
        this.m_justificationShiftX = (n & 1) != 0 ? 1 : ((n & 2) != 0 ? 2 : 4);
        this.m_justificationShiftY = (n & 0x20) != 0 ? 32 : ((n & 0x10) != 0 ? 16 : 8);
        if (this.m_outputType == 4) {
            this.writeLine(this.m_writer, this.m_justificationShiftX + " " + this.m_justificationShiftY + " ju");
        }
    }

    public void setColorAttribute(Color color) {
        if (this.m_outputType == 4 || this.m_outputType == 6) {
            float[] fArray = color.getRGBColorComponents(null);
            PrintWriter printWriter = this.m_outputType == 6 ? this.m_PDFGeometryWriter : this.m_writer;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_coordinateDecimal.format(fArray[0]));
            stringBuffer.append(' ');
            stringBuffer.append(this.m_coordinateDecimal.format(fArray[1]));
            stringBuffer.append(' ');
            stringBuffer.append(this.m_coordinateDecimal.format(fArray[2]));
            this.writeLine(printWriter, stringBuffer.toString() + " RG");
            if (this.m_outputType == 6) {
                this.writeLine(printWriter, stringBuffer.toString() + " rg");
                int n = color.getAlpha();
                String string = this.m_coordinateDecimal.format((double)n / 255.0);
                String string2 = this.m_PDFGstatePrefix + n;
                this.m_PDFExtGStateObjects.put(string2, "<< /Type /ExtGState /CA " + string + " /ca " + string + " >>");
                this.writeLine(printWriter, "/" + string2 + " gs");
            }
        } else {
            this.m_graphics2D.setColor(color);
        }
    }

    public void setBlendAttribute(String string) {
        string = string.toLowerCase().trim();
        if (this.m_outputType == 6) {
            if (string.equals("colordodge")) {
                string = "ColorDodge";
            } else if (string.equals("colorburn")) {
                string = "ColorBurn";
            } else if (string.equals("hardlight")) {
                string = "HardLight";
            } else if (string.equals("softlight")) {
                string = "SoftLight";
            } else if (string.length() > 0) {
                string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            }
            String string2 = this.m_PDFGstatePrefix + string;
            this.m_PDFExtGStateObjects.put(string2, "<< /Type /ExtGState /BM /" + string + " >>");
            this.writeLine(this.m_PDFGeometryWriter, "/" + string2 + " gs");
        } else if (this.m_outputType != 4) {
            Composite composite = BlendComposite.getBlendComposite(string);
            if (composite == null) {
                composite = AlphaComposite.SrcOver;
            }
            this.m_graphics2D.setComposite(composite);
        }
    }

    public void setLinestyleAttribute(BasicStroke basicStroke) {
        double d = basicStroke.getLineWidth();
        if (this.m_outputType == 4 || this.m_outputType == 6) {
            PrintWriter printWriter = this.m_outputType == 6 ? this.m_PDFGeometryWriter : this.m_writer;
            int n = basicStroke.getEndCap();
            n = n == 0 ? 0 : (n == 1 ? 1 : 2);
            int n2 = basicStroke.getLineJoin();
            n2 = n2 == 0 ? 0 : (n2 == 1 ? 1 : 2);
            if (d < this.m_minimumLineWidth) {
                d = this.m_minimumLineWidth;
            }
            this.writeLine(printWriter, this.m_coordinateDecimal.format(d) + " w " + n + " J " + n2 + " j " + this.m_coordinateDecimal.format(basicStroke.getMiterLimit()) + " M");
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                StringBuffer stringBuffer = new StringBuffer("[");
                for (int i = 0; i < fArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(this.m_coordinateDecimal.format(fArray[i]));
                }
                stringBuffer.append("] ");
                stringBuffer.append(basicStroke.getDashPhase());
                stringBuffer.append(" d");
                this.writeLine(printWriter, stringBuffer.toString());
            } else {
                this.writeLine(printWriter, "[] 0 d");
            }
        } else {
            if (d < this.m_minimumLineWidth) {
                float[] fArray = basicStroke.getDashArray();
                basicStroke = fArray == null ? new BasicStroke((float)this.m_minimumLineWidth, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit()) : new BasicStroke((float)this.m_minimumLineWidth, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), fArray, basicStroke.getDashPhase());
            }
            this.m_graphics2D.setStroke(basicStroke);
        }
    }

    public void setClipAttribute(ArrayList arrayList) {
        if (this.m_outputType != 4 && this.m_outputType != 6 && this.m_outputType != 7) {
            boolean bl;
            this.m_graphics2D.setClip(null);
            boolean bl2 = bl = arrayList != null && arrayList.size() > 0;
            if (bl) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    GeometricPath geometricPath = (GeometricPath)arrayList.get(i);
                    this.m_graphics2D.clip(geometricPath.getShape());
                }
            }
        }
    }

    private void writeShape(Shape shape, int n, PrintWriter printWriter, String string) {
        String string2;
        PathIterator pathIterator = n == 8 ? shape.getPathIterator(null, this.m_resolution) : shape.getPathIterator(null);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = (float)(this.m_resolution * this.m_resolution);
        int n2 = 4;
        boolean bl = false;
        int n3 = 0;
        while (!pathIterator.isDone()) {
            n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    f3 = f = fArray[0];
                    f4 = f2 = fArray[1];
                    ++n3;
                    if (n == 7) {
                        this.writeLine(printWriter, "M " + this.m_coordinateDecimal.format(f) + " " + this.m_coordinateDecimal.format(this.m_pageHeight - (double)f2));
                    } else if (n == 8) {
                        if (n3 == 1) {
                            this.m_imageMapWriter.print("<area shape=\"polygon\" coords=\"");
                        } else {
                            this.m_imageMapWriter.print(",");
                        }
                        this.m_imageMapWriter.println(Math.round((double)f / this.m_resolution) + "," + Math.round((this.m_pageHeight - (double)f2) / this.m_resolution));
                    } else {
                        this.writeLine(printWriter, this.m_coordinateDecimal.format(f) + " " + this.m_coordinateDecimal.format(f2) + " m");
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    f5 = fArray[0];
                    f6 = fArray[1];
                    float f8 = (f - f5) * (f - f5) + (f2 - f6) * (f2 - f6);
                    if (f8 >= f7) {
                        if (n == 7) {
                            string2 = this.m_coordinateDecimal.format(f5);
                            String string3 = this.m_coordinateDecimal.format(this.m_pageHeight - (double)f6);
                            if (f5 == f) {
                                this.writeLine(printWriter, "V " + string3);
                            } else if (f6 == f2) {
                                this.writeLine(printWriter, "H " + string2);
                            } else {
                                this.writeLine(printWriter, "L " + string2 + " " + string3);
                            }
                        } else if (n == 8) {
                            this.m_imageMapWriter.println("," + Math.round((double)f5 / this.m_resolution) + "," + Math.round((this.m_pageHeight - (double)f6) / this.m_resolution));
                        } else {
                            this.writeLine(printWriter, this.m_coordinateDecimal.format(f5) + " " + this.m_coordinateDecimal.format(f6) + " l");
                        }
                        f = f5;
                        f2 = f6;
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 4: {
                    if (bl) {
                        if (n == 7) {
                            this.writeLine(printWriter, "L " + this.m_coordinateDecimal.format(f5) + " " + this.m_coordinateDecimal.format(this.m_pageHeight - (double)f6));
                        } else if (n == 8) {
                            if (n3 > 0) {
                                this.m_imageMapWriter.println("," + Math.round((double)f5 / this.m_resolution) + "," + Math.round((this.m_pageHeight - (double)f6) / this.m_resolution));
                            }
                        } else {
                            this.writeLine(printWriter, this.m_coordinateDecimal.format(f5) + " " + this.m_coordinateDecimal.format(f6) + " l");
                        }
                    }
                    if (n == 7) {
                        this.writeLine(printWriter, "z");
                    } else if (n == 8) {
                        if (n3 > 0) {
                            this.m_imageMapWriter.println("," + Math.round((double)f3 / this.m_resolution) + "," + Math.round((this.m_pageHeight - (double)f4) / this.m_resolution));
                        }
                    } else {
                        this.writeLine(printWriter, "h");
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if (n == 7) {
                        this.writeLine(printWriter, "C " + this.m_coordinateDecimal.format(fArray[0]) + " " + this.m_coordinateDecimal.format(this.m_pageHeight - (double)fArray[1]) + " " + this.m_coordinateDecimal.format(fArray[2]) + " " + this.m_coordinateDecimal.format(this.m_pageHeight - (double)fArray[3]) + " " + this.m_coordinateDecimal.format(fArray[4]) + " " + this.m_coordinateDecimal.format(this.m_pageHeight - (double)fArray[5]));
                    } else {
                        this.writeLine(printWriter, this.m_coordinateDecimal.format(fArray[0]) + " " + this.m_coordinateDecimal.format(fArray[1]) + " " + this.m_coordinateDecimal.format(fArray[2]) + " " + this.m_coordinateDecimal.format(fArray[3]) + " " + this.m_coordinateDecimal.format(fArray[4]) + " " + this.m_coordinateDecimal.format(fArray[5]) + " " + "c");
                    }
                    f = fArray[4];
                    f2 = fArray[5];
                    bl = false;
                }
            }
            pathIterator.next();
        }
        if (bl) {
            if (n == 7) {
                this.writeLine(printWriter, "L " + this.m_coordinateDecimal.format(f5) + " " + this.m_coordinateDecimal.format(this.m_pageHeight - (double)f6));
            } else if (n == 8) {
                if (n3 > 0) {
                    this.m_imageMapWriter.println("," + Math.round((double)f5 / this.m_resolution) + "," + Math.round((this.m_pageHeight - (double)f6) / this.m_resolution));
                }
            } else {
                this.writeLine(printWriter, this.m_coordinateDecimal.format(f5) + " " + this.m_coordinateDecimal.format(f6) + " l");
            }
        }
        if (n == 8 && n3 > 0) {
            string2 = "\" " + string + " >";
            this.m_imageMapWriter.println(string2);
        }
    }

    private Color getSingleImageColor(BufferedImage bufferedImage) {
        Color color = Color.BLACK;
        boolean bl = false;
        boolean bl2 = false;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2 && !bl; ++i) {
            for (int j = 0; j < n && !bl; ++j) {
                int n3 = bufferedImage.getRGB(j, i);
                if ((n3 & 0xFF000000) == 0) continue;
                if (!bl2) {
                    bl2 = true;
                    color = new Color(n3 & 0xFFFFFF);
                    continue;
                }
                bl = n3 != color.getRGB();
            }
        }
        if (bl) {
            color = null;
        }
        return color;
    }

    public void drawIcon(ArrayList arrayList, BufferedImage bufferedImage, double d, double d2, double d3) throws IOException, MapyrusException {
        block11: {
            double d4;
            double d5;
            int n;
            int n2;
            block10: {
                n2 = bufferedImage.getWidth();
                n = bufferedImage.getHeight();
                if (d <= 0.0) {
                    d = (double)Math.max(n2, n) * (25.4 / (double)Constants.getScreenResolution());
                }
                d *= d3;
                if (n2 > n) {
                    d5 = d;
                    d4 = d * ((double)n / (double)n2);
                } else {
                    d4 = d;
                    d5 = d * ((double)n2 / (double)n);
                }
                if (this.m_outputType != 4 && this.m_outputType != 6) break block10;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Point2D point2D = (Point2D)arrayList.get(i);
                    double d6 = point2D.getX();
                    double d7 = point2D.getY();
                    if (!(d6 + d5 >= 0.0) || !(d6 - d5 <= this.m_pageWidth) || !(d7 + d4 >= 0.0) || !(d7 - d4 <= this.m_pageHeight)) continue;
                    this.writePostScriptOrPDFImage(bufferedImage, d6, d7, d5, d4, d2);
                }
                break block11;
            }
            if (this.m_outputType == 7) break block11;
            double d8 = 25.4 / (double)Constants.getScreenResolution();
            double d9 = d5 / d8 / (double)n2;
            double d10 = d4 / d8 / (double)n;
            int n3 = (int)Math.round(1.0 / d9);
            int n4 = 1;
            Image image = bufferedImage;
            while (n3 > 1) {
                n3 /= 2;
                n4 *= 2;
            }
            if (n4 > 2) {
                int n5 = n2 / n4;
                int n6 = n / n4;
                if (n5 > 0 && n6 > 0) {
                    image = bufferedImage.getScaledInstance(n5, n6, 4);
                    d9 *= (double)n2 / (double)n5;
                    d10 *= (double)n / (double)n6;
                    n2 = n5;
                    n = n6;
                }
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = (Point2D)arrayList.get(i);
                double d11 = point2D.getX();
                double d12 = point2D.getY();
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(d11, d12);
                affineTransform.scale(d8, d8 * -1.0);
                affineTransform.rotate(-d2);
                affineTransform.scale(d9, d10);
                affineTransform.translate((double)(-n2) / 2.0, (double)(-n) / 2.0);
                try {
                    this.m_graphics2D.drawImage(image, affineTransform, null);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    throw new OutOfMemoryError("Failed loading icon.");
                }
            }
        }
    }

    public void drawGeoImage(BufferedImage bufferedImage, double d, double d2, double d3, double d4) throws MapyrusException, IOException {
        if (this.m_outputType == 4 || this.m_outputType == 6) {
            this.writePostScriptOrPDFImage(bufferedImage, d + d3 / 2.0, d2 + d4 / 2.0, d3, d4, 0.0);
        } else {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2 + d4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.scale(d3 / (double)bufferedImage.getWidth(), d4 / (double)bufferedImage.getHeight());
            this.m_graphics2D.drawImage(bufferedImage, affineTransform, null);
        }
    }

    private void drawBoundingBoxes(ArrayList arrayList, double d, double d2) {
        GeneralPath generalPath = new GeneralPath();
        Color color = this.m_graphics2D.getColor();
        this.m_graphics2D.setColor(new Color(127, 127, 127, 127));
        for (int i = 0; i < arrayList.size(); ++i) {
            Point2D point2D = (Point2D)arrayList.get(i);
            double d3 = point2D.getX();
            double d4 = point2D.getY();
            double d5 = Math.cos(d2) * d / 2.0;
            double d6 = Math.sin(d2) * d / 2.0;
            generalPath.reset();
            generalPath.moveTo((float)(d3 - d5 + d6), (float)(d4 - d6 - d5));
            Point2D point2D2 = generalPath.getCurrentPoint();
            generalPath.lineTo((float)(point2D2.getX() - d6 - d6), (float)(point2D2.getY() + d5 + d5));
            point2D2 = generalPath.getCurrentPoint();
            generalPath.lineTo((float)(point2D2.getX() + d5 + d5), (float)(point2D2.getY() + d6 + d6));
            point2D2 = generalPath.getCurrentPoint();
            generalPath.lineTo((float)(point2D2.getX() + d6 + d6), (float)(point2D2.getY() - d5 - d5));
            generalPath.closePath();
            this.fill(generalPath, null);
        }
        this.m_graphics2D.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEPS(ArrayList arrayList, String string, double d, double d2, double d3) throws IOException, MapyrusException {
        PostScriptFile postScriptFile = new PostScriptFile(string);
        Rectangle rectangle = postScriptFile.getBoundingBox();
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        if (d <= 0.0) {
            d = (double)Math.max(n, n2) * 0.35277777777777775;
        }
        d *= d3;
        if (this.m_outputType == 4) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = (Point2D)arrayList.get(i);
                double d4 = point2D.getX();
                double d5 = point2D.getY();
                if (!(d4 + d >= 0.0) || !(d4 - d <= this.m_pageWidth) || !(d5 + d >= 0.0) || !(d5 - d <= this.m_pageHeight)) continue;
                this.writeLine(this.m_writer, "save");
                this.writeLine(this.m_writer, d4 + " " + d5 + " translate");
                this.writeLine(this.m_writer, d2 + " radtodeg rotate");
                this.writeLine(this.m_writer, -(d / 2.0) + " " + -(d / 2.0) + " translate");
                double d6 = d / (double)Math.max(n, n2);
                this.writeLine(this.m_writer, d6 + " dup scale");
                this.writeLine(this.m_writer, -rectangle.getMinX() + " " + -rectangle.getMinY() + " translate");
                this.writeLine(this.m_writer, "/showpage {} def");
                this.writeLine(this.m_writer, "0 setgray 0 setlinecap 1 setlinewidth");
                this.writeLine(this.m_writer, "0 setlinejoin 10 setmiterlimit [] 0 setdash newpath");
                this.writeLine(this.m_writer, "%%BeginDocument: (" + string + ")");
                LineNumberReader lineNumberReader = null;
                try {
                    String string2;
                    lineNumberReader = new FileOrURL(string).getReader();
                    while ((string2 = ((BufferedReader)lineNumberReader).readLine()) != null) {
                        this.writeLine(this.m_writer, string2);
                    }
                    this.writeLine(this.m_writer, "%%EndDocument");
                    this.writeLine(this.m_writer, "restore");
                    continue;
                }
                finally {
                    if (lineNumberReader != null) {
                        lineNumberReader.close();
                    }
                }
            }
        } else {
            this.drawBoundingBoxes(arrayList, d, d2);
        }
    }

    public void drawSVG(ArrayList arrayList, String string, double d, double d2, double d3) throws IOException, MapyrusException {
        SVGFile sVGFile = new SVGFile(string);
        Rectangle2D rectangle2D = sVGFile.getBoundingBox();
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        if (d <= 0.0) {
            d = (double)Math.max(n, n2) * 0.35277777777777775;
        }
        d *= d3;
        if (this.m_outputType == 7) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = (Point2D)arrayList.get(i);
                double d4 = point2D.getX();
                double d5 = point2D.getY();
                if (!(d4 + d >= 0.0) || !(d4 - d <= this.m_pageWidth) || !(d5 + d >= 0.0) || !(d5 - d <= this.m_pageHeight)) continue;
                this.writeLine(this.m_writer, "<!-- begin " + string + " -->");
                this.writeLine(this.m_writer, "<g");
                this.writeLine(this.m_writer, sVGFile.getSVGAttributes());
                this.writeLine(this.m_writer, "transform=\"translate(" + d4 + "," + (this.m_pageHeight - d5) + ")");
                this.writeLine(this.m_writer, "rotate(" + Math.toDegrees(-d2) + ")");
                this.writeLine(this.m_writer, "translate(" + this.m_coordinateDecimal.format(-d / 2.0) + "," + this.m_coordinateDecimal.format(-d / 2.0) + ")");
                double d6 = d / (double)Math.max(n, n2);
                this.writeLine(this.m_writer, "scale(" + d6 + ")\">");
                this.writeLine(this.m_writer, sVGFile.toString());
                this.writeLine(this.m_writer, "<!-- end " + string + " -->");
                this.writeLine(this.m_writer, "</g>");
            }
        } else {
            this.drawBoundingBoxes(arrayList, d, d2);
        }
    }

    public void addSVGCode(String string) throws IOException, MapyrusException {
        if (this.m_outputType == 7) {
            this.writeLine(this.m_writer, "<!-- svgcode -->");
            this.writeLine(this.m_writer, string);
        }
    }

    public void drawPDF(ArrayList arrayList, String string, int n, double d, double d2, double d3) throws IOException, MapyrusException {
        Integer n2;
        Object object;
        Object object2 = null;
        int n3 = 0;
        if (this.m_outputType == 6) {
            while (n3 < this.m_PDFIncludedFiles.size() && object2 == null) {
                object = this.m_PDFIncludedFiles.get(n3);
                if (((PDFFile)object).getFilename().equals(string)) {
                    object2 = object;
                    continue;
                }
                ++n3;
            }
        }
        if (object2 == null) {
            object2 = new PDFFile(string);
            if (this.m_outputType == 6) {
                this.m_PDFIncludedFiles.add((PDFFile)object2);
                this.m_PDFIncludedPages.add(new ArrayList());
                n3 = this.m_PDFIncludedFiles.size() - 1;
            }
        }
        if (n < 1 || n > ((PDFFile)object2).getPageCount()) {
            throw new MapyrusException(MapyrusMessages.get("invalidpagenumber") + ": " + ((PDFFile)object2).getFilename() + ": " + n);
        }
        if (this.m_outputType == 6 && !((ArrayList)(object = this.m_PDFIncludedPages.get(n3))).contains(n2 = new Integer(n))) {
            ((ArrayList)object).add((Integer)n2);
        }
        object = ((PDFFile)object2).getMediaBox(n);
        reference var13_11 = object[2] - object[0];
        reference var14_12 = object[3] - object[1];
        if (d <= 0.0) {
            d = (double)Math.max((int)var13_11, (int)var14_12) * 0.35277777777777775;
        }
        d *= d3;
        if (this.m_outputType == 6) {
            byte[] byArray = ((PDFFile)object2).getContents(n);
            for (int i = 0; i < arrayList.size(); ++i) {
                Point2D point2D = (Point2D)arrayList.get(i);
                double d4 = point2D.getX();
                double d5 = point2D.getY();
                if (!(d4 + d >= 0.0) || !(d4 - d <= this.m_pageWidth) || !(d5 + d >= 0.0) || !(d5 - d <= this.m_pageHeight)) continue;
                this.writeLine(this.m_PDFGeometryWriter, "% " + string);
                this.writeLine(this.m_PDFGeometryWriter, "q");
                this.setColorAttribute(Color.BLACK);
                this.writeLine(this.m_PDFGeometryWriter, "1 0 0 1 " + this.m_coordinateDecimal.format(d4) + " " + this.m_coordinateDecimal.format(d5) + " cm");
                double d6 = Math.cos(d2);
                double d7 = Math.sin(d2);
                this.writeLine(this.m_PDFGeometryWriter, d6 + " " + d7 + " " + -d7 + " " + d6 + " 0 0 cm");
                this.writeLine(this.m_PDFGeometryWriter, "1 0 0 1 " + -(d / 2.0) + " " + -(d / 2.0) + " cm");
                double d8 = d / (double)Math.max((int)var13_11, (int)var14_12);
                this.writeLine(this.m_PDFGeometryWriter, d8 + " 0 0 " + d8 + " 0 0 cm");
                this.writeLine(this.m_PDFGeometryWriter, "1 0 0 1 " + (int)(-object[0]) + " " + (int)(-object[1]) + " cm");
                for (int j = 0; j < byArray.length; ++j) {
                    this.m_PDFGeometryWriter.write(byArray[j]);
                }
                this.writeLine(this.m_PDFGeometryWriter, " Q");
            }
        } else {
            this.drawBoundingBoxes(arrayList, d, d2);
        }
    }

    public void stroke(Shape shape, String string) {
        if (this.m_outputType == 4 || this.m_outputType == 7 || this.m_outputType == 6) {
            if (shape.intersects(0.0, 0.0, this.m_pageWidth, this.m_pageHeight)) {
                if (this.m_outputType == 7) {
                    int n;
                    this.writeLine(this.m_writer, "<path d=\"");
                    this.writeShape(shape, this.m_outputType, this.m_writer, null);
                    this.writeLine(this.m_writer, "\"");
                    Color color = this.m_graphics2D.getColor();
                    BasicStroke basicStroke = (BasicStroke)this.m_graphics2D.getStroke();
                    float f = basicStroke.getLineWidth();
                    int n2 = basicStroke.getEndCap();
                    int n3 = basicStroke.getLineJoin();
                    float[] fArray = basicStroke.getDashArray();
                    float f2 = basicStroke.getDashPhase();
                    String string2 = n2 == 0 ? "butt" : (n2 == 2 ? "square" : "round");
                    String string3 = n3 == 2 ? "bevel" : (n3 == 0 ? "miter" : "round");
                    this.writeLine(this.m_writer, "  style=\"stroke:" + ColorDatabase.toHexString(color) + ";stroke-width:" + f + ";stroke-linecap:" + string2 + ";stroke-linejoin:" + string3);
                    if (fArray != null) {
                        StringBuffer stringBuffer = new StringBuffer(";stroke-dasharray:");
                        for (int i = 0; i < fArray.length; ++i) {
                            if (i > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(this.m_coordinateDecimal.format(fArray[i]));
                        }
                        this.writeLine(this.m_writer, stringBuffer.toString());
                        this.writeLine(this.m_writer, ";stroke-dashoffset:" + f2);
                    }
                    if ((n = color.getAlpha()) != 255) {
                        this.writeLine(this.m_writer, ";stroke-opacity:" + (float)n / 255.0f);
                    }
                    this.writeLine(this.m_writer, ";fill:none\"");
                    Composite composite = this.m_graphics2D.getComposite();
                    if (composite instanceof BlendComposite) {
                        BlendComposite blendComposite = (BlendComposite)composite;
                        this.writeLine(this.m_writer, "filter=\"url(#" + blendComposite.getName() + ")\"");
                    }
                    if (string != null) {
                        this.writeLine(this.m_writer, string);
                    }
                    this.writeLine(this.m_writer, "/>");
                } else {
                    PrintWriter printWriter = this.m_outputType == 6 ? this.m_PDFGeometryWriter : this.m_writer;
                    this.writeShape(shape, this.m_outputType, printWriter, null);
                    this.writeLine(printWriter, "S");
                }
            }
        } else {
            this.m_graphics2D.draw(shape);
        }
    }

    public void fill(Shape shape, String string) {
        if (this.m_outputType == 4 || this.m_outputType == 7 || this.m_outputType == 6) {
            if (shape.intersects(0.0, 0.0, this.m_pageWidth, this.m_pageHeight)) {
                if (this.m_outputType == 7) {
                    this.writeLine(this.m_writer, "<path d=\"");
                    this.writeShape(shape, this.m_outputType, this.m_writer, null);
                    this.writeLine(this.m_writer, "\"");
                    Color color = this.m_graphics2D.getColor();
                    int n = color.getAlpha();
                    StringBuffer stringBuffer = new StringBuffer("  style=\"fill:");
                    stringBuffer.append(ColorDatabase.toHexString(color));
                    if (n != 255) {
                        stringBuffer.append(";fill-opacity:" + (float)n / 255.0f);
                    }
                    stringBuffer.append(";stroke:none\" ");
                    Composite composite = this.m_graphics2D.getComposite();
                    if (composite instanceof BlendComposite) {
                        BlendComposite blendComposite = (BlendComposite)composite;
                        this.writeLine(this.m_writer, "filter=\"url(#" + blendComposite.getName() + ")\"");
                    }
                    if (string != null) {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append("/>");
                    this.writeLine(this.m_writer, stringBuffer.toString());
                } else {
                    PrintWriter printWriter = this.m_outputType == 6 ? this.m_PDFGeometryWriter : this.m_writer;
                    this.writeShape(shape, this.m_outputType, printWriter, null);
                    this.writeLine(printWriter, "f");
                }
            }
        } else {
            this.m_graphics2D.fill(shape);
        }
    }

    public void setEventScript(Shape shape, String string) {
        if (this.m_imageMapWriter != null) {
            this.writeShape(shape, 8, this.m_writer, string);
        } else if (this.m_outputType == 7) {
            this.writeLine(this.m_writer, "<path d=\"");
            this.writeShape(shape, this.m_outputType, this.m_writer, string);
            this.writeLine(this.m_writer, "\"");
            this.writeLine(this.m_writer, string);
            this.writeLine(this.m_writer, "/>");
        }
    }

    public void gradientFill(Shape shape, boolean bl, Color color, Color color2) {
        if (this.m_outputType == 7 && shape.intersects(0.0, 0.0, this.m_pageWidth, this.m_pageHeight)) {
            String string = "gradient" + this.m_gradientCounter++;
            this.writeLine(this.m_writer, "<defs>");
            this.writeLine(this.m_writer, "<linearGradient id=\"" + string + "\"");
            if (bl) {
                this.writeLine(this.m_writer, "x1=\"0%\" y1=\"100%\" x2=\"0%\" y2=\"0%\"");
            }
            this.writeLine(this.m_writer, ">");
            this.writeLine(this.m_writer, "<stop offset=\"0%\" stop-color=\"" + ColorDatabase.toHexString(color) + "\"/>");
            this.writeLine(this.m_writer, "<stop offset=\"100%\" stop-color=\"" + ColorDatabase.toHexString(color2) + "\"/>");
            this.writeLine(this.m_writer, "</linearGradient>");
            this.writeLine(this.m_writer, "</defs>");
            this.writeLine(this.m_writer, "<path d=\"");
            this.writeShape(shape, this.m_outputType, this.m_writer, null);
            this.writeLine(this.m_writer, "\"");
            Composite composite = this.m_graphics2D.getComposite();
            if (composite instanceof BlendComposite) {
                BlendComposite blendComposite = (BlendComposite)composite;
                this.writeLine(this.m_writer, "filter=\"url(#" + blendComposite.getName() + ")\"");
            }
            this.writeLine(this.m_writer, "  fill=\"url(#" + string + ")\" stroke=\"none\"/>");
        }
    }

    public void clip(Shape shape) {
        if (this.m_outputType == 4 || this.m_outputType == 6) {
            PrintWriter printWriter = this.m_outputType == 6 ? this.m_PDFGeometryWriter : this.m_writer;
            if (shape.intersects(0.0, 0.0, this.m_pageWidth, this.m_pageHeight)) {
                this.writeShape(shape, this.m_outputType, printWriter, null);
            } else {
                this.writeShape(new Rectangle2D.Float(-1.0f, -1.0f, 0.1f, 0.1f), this.m_outputType, printWriter, null);
            }
            this.writeLine(printWriter, "W n");
        } else if (this.m_outputType == 7) {
            ++this.m_clipPathCounter;
            this.writeLine(this.m_writer, "<clipPath id=\"" + this.m_SVGClipPathPrefix + this.m_clipPathCounter + "\">");
            this.writeLine(this.m_writer, "<path d=\"");
            this.writeShape(shape, this.m_outputType, this.m_writer, null);
            this.writeLine(this.m_writer, "\"/>");
            this.writeLine(this.m_writer, "</clipPath>");
            this.writeLine(this.m_writer, "<g clip-path=\"url(#" + this.m_SVGClipPathPrefix + this.m_clipPathCounter + ")\">");
            Integer n = this.m_SVGOpenGTags.pop();
            this.m_SVGOpenGTags.push(n + 1);
        }
    }

    private int writePostScriptString(PrintWriter printWriter, String string, String string2) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string).append(' ');
        }
        stringBuffer.append("(");
        for (int i = 0; i < string2.length(); ++i) {
            char c;
            if (stringBuffer.length() > 72) {
                stringBuffer.append('\\');
                n += this.writeLine(printWriter, stringBuffer.toString());
                stringBuffer.setLength(0);
            }
            if ((c = string2.charAt(i)) == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c == '(' || c == ')' || c == '%' || c < ' ' || c > 'z') {
                int n2 = c;
                int n3 = n2 / 64;
                int n4 = (n2 -= n3 * 64) / 8;
                int n5 = n2 -= n4 * 8;
                stringBuffer.append('\\');
                stringBuffer.append(n3);
                stringBuffer.append(n4);
                stringBuffer.append(n5);
                continue;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append(")");
        return n += this.writeLine(printWriter, stringBuffer.toString());
    }

    public void label(ArrayList<Point2D> arrayList, String string) throws IOException, MapyrusException {
        double d = 0.0;
        double d2 = 0.0;
        FontRenderContext fontRenderContext = null;
        Stroke stroke = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, Constants.LINE_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList2.add(stringTokenizer.nextToken());
        }
        if (this.m_outputType != 4 && this.m_outputType != 6) {
            fontRenderContext = this.m_graphics2D.getFontRenderContext();
            if (this.m_fontOutlineWidth > 0.0) {
                stroke = this.m_graphics2D.getStroke();
                BasicStroke basicStroke = new BasicStroke((float)this.m_fontOutlineWidth, 0, 0, 2.0f);
                this.m_graphics2D.setStroke(basicStroke);
            }
        }
        double d3 = 0.0;
        if (this.m_justificationShiftY == 8) {
            d3 = -this.m_fontSize;
        } else if (this.m_justificationShiftY == 16) {
            d3 = (double)arrayList2.size() * this.m_fontSize + (double)(arrayList2.size() - 1) * this.m_fontSize * (this.m_fontLineSpacing - 1.0);
            d3 = d3 / 2.0 - this.m_fontSize;
        } else {
            d3 = (double)(arrayList2.size() - 1) * this.m_fontSize * this.m_fontLineSpacing;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            double d4;
            Point2D point2D = arrayList.get(i);
            double d5 = point2D.getX();
            double d6 = point2D.getY();
            if (this.m_outputType == 6) {
                d2 = 0.0;
                d = 0.0;
                this.writeLine(this.m_PDFGeometryWriter, "q");
                double d7 = Math.cos(this.m_fontRotation);
                d4 = Math.sin(this.m_fontRotation);
                this.writeLine(this.m_PDFGeometryWriter, this.m_coordinateDecimal.format(d7) + " " + this.m_coordinateDecimal.format(d4) + " " + this.m_coordinateDecimal.format(-d4) + " " + this.m_coordinateDecimal.format(d7) + " " + this.m_coordinateDecimal.format(d5) + " " + this.m_coordinateDecimal.format(d6) + " cm");
                this.writeLine(this.m_PDFGeometryWriter, "BT");
                int n = 0;
                int n2 = -1;
                while (n < PDF_FONTS.length && n2 < 0) {
                    if (PDF_FONTS[n].equals(this.m_fontName)) {
                        n2 = n;
                        continue;
                    }
                    ++n;
                }
                if (n2 < 0) {
                    for (int j = 0; j < this.m_PDFFonts.size() && n2 < 0; ++j) {
                        AdobeFontMetrics adobeFontMetrics = this.m_PDFFonts.get(j);
                        if (!adobeFontMetrics.getFontName().equals(this.m_fontName)) continue;
                        n2 = j + PDF_FONTS.length;
                    }
                    if (n2 < 0) {
                        n2 = 4;
                    }
                }
                this.writeLine(this.m_PDFGeometryWriter, "/" + this.m_PDFFontPrefix + n2 + " " + this.m_coordinateDecimal.format(this.m_fontSize) + " Tf");
                if (this.m_fontOutlineWidth > 0.0) {
                    this.writeLine(this.m_PDFGeometryWriter, "1 Tr " + this.m_coordinateDecimal.format(this.m_fontOutlineWidth) + " w " + 2 + " M 2 J 0 j [] 0 d");
                } else {
                    this.writeLine(this.m_PDFGeometryWriter, "0 Tr");
                }
            }
            Iterator iterator = arrayList2.iterator();
            double d8 = 0.0;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (this.m_outputType == 4) {
                    this.writeLine(this.m_writer, this.m_coordinateDecimal.format(d5) + " " + this.m_coordinateDecimal.format(d6) + " m");
                    this.writeLine(this.m_writer, this.m_coordinateDecimal.format(d8));
                    this.writeLine(this.m_writer, Integer.toString(arrayList2.size()));
                    this.writePostScriptString(this.m_writer, null, string2);
                    this.writeLine(this.m_writer, "t");
                } else if (this.m_outputType == 6) {
                    StringDimension stringDimension = this.getStringDimension(string2, this.m_fontName, this.m_fontSize, 1.0);
                    d4 = 0.0;
                    if (this.m_justificationShiftX == 4) {
                        d4 = -stringDimension.getWidth();
                    } else if (this.m_justificationShiftX == 2) {
                        d4 = -stringDimension.getWidth() / 2.0;
                    }
                    double d9 = d3 - d8 * this.m_fontSize * this.m_fontLineSpacing;
                    this.writeLine(this.m_PDFGeometryWriter, this.m_coordinateDecimal.format(d4 - d) + " " + this.m_coordinateDecimal.format(d9 - d2) + " Td");
                    d = d4;
                    d2 = d9;
                    this.writePostScriptString(this.m_PDFGeometryWriter, null, string2);
                    this.writeLine(this.m_PDFGeometryWriter, "Tj");
                } else if (this.m_outputType == 7) {
                    Object object;
                    Composite composite;
                    double d10;
                    double d11;
                    String string3 = this.m_justificationShiftX == 4 ? "end" : (this.m_justificationShiftX == 1 ? "start" : "middle");
                    Color color = this.m_graphics2D.getColor();
                    int n = color.getAlpha();
                    Font font = this.m_graphics2D.getFont();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (font.isBold()) {
                        stringBuffer.append(" font-weight=\"bold\" ");
                    }
                    if (font.isItalic()) {
                        stringBuffer.append(" font-style=\"italic\" ");
                    }
                    if (this.m_fontOutlineWidth > 0.0) {
                        stringBuffer.append(" stroke=\"");
                        stringBuffer.append(ColorDatabase.toHexString(color));
                        stringBuffer.append("\" stroke-width=\"");
                        stringBuffer.append(this.m_fontOutlineWidth);
                        stringBuffer.append("\" stroke-miterlimit=\"2\" ");
                        if (n != 255) {
                            stringBuffer.append(" stroke-opacity=\"");
                            stringBuffer.append((float)n / 255.0f);
                            stringBuffer.append("\" ");
                        }
                    } else {
                        stringBuffer.append(" fill=\"");
                        stringBuffer.append(ColorDatabase.toHexString(color));
                        stringBuffer.append("\" ");
                        if (n != 255) {
                            stringBuffer.append(" fill-opacity=\"");
                            stringBuffer.append((float)n / 255.0f);
                            stringBuffer.append("\" ");
                        }
                    }
                    double d12 = d6 + d3 - d8 * this.m_fontSize * this.m_fontLineSpacing;
                    if (this.m_fontRotation != 0.0) {
                        this.writeLine(this.m_writer, "<g transform=\"translate(" + this.m_coordinateDecimal.format(d5) + ", " + this.m_coordinateDecimal.format(this.m_pageHeight - d12) + ") rotate(" + this.m_coordinateDecimal.format(Math.toDegrees(-this.m_fontRotation)) + ")\">");
                        d11 = 0.0;
                        d10 = 0.0;
                    } else {
                        d10 = d5;
                        d11 = this.m_pageHeight - d12;
                    }
                    this.writeLine(this.m_writer, "<text x=\"" + this.m_coordinateDecimal.format(d10) + "\" y=\"" + this.m_coordinateDecimal.format(d11) + "\" text-anchor=\"" + string3 + "\"");
                    String string4 = font.getName();
                    if (string4.equalsIgnoreCase("sansserif") || string4.equalsIgnoreCase("dialog")) {
                        string4 = "Courier";
                    }
                    if ((composite = this.m_graphics2D.getComposite()) instanceof BlendComposite) {
                        object = (BlendComposite)composite;
                        stringBuffer.append(" filter=\"url(#");
                        stringBuffer.append(((BlendComposite)object).getName());
                        stringBuffer.append(")\" ");
                    }
                    this.writeLine(this.m_writer, "  font-family=\"" + string4 + "\" " + "font-size=\"" + font.getSize2D() + "\" " + stringBuffer.toString());
                    object = new StringBuffer(string2.length() * 2);
                    for (int j = 0; j < string2.length(); ++j) {
                        char c = string2.charAt(j);
                        if (c == '&' || c == '<' || c == '>' || c == '\"' || c > '\u007f') {
                            ((StringBuffer)object).append("&#").append(Integer.toString(c)).append(";");
                            continue;
                        }
                        ((StringBuffer)object).append(c);
                    }
                    this.writeLine(this.m_writer, ">" + ((StringBuffer)object).toString() + "</text>");
                    if (this.m_fontRotation != 0.0) {
                        this.writeLine(this.m_writer, "</g>");
                    }
                } else {
                    Point2D point2D2;
                    if (this.m_justificationShiftX != 1 || this.m_justificationShiftY != 32 || arrayList2.size() > 1 || this.m_fontRotation != 0.0) {
                        Rectangle2D rectangle2D = this.m_baseFont.getStringBounds(string2, fontRenderContext);
                        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d5, d6);
                        affineTransform.rotate(this.m_fontRotation);
                        d4 = 0.0;
                        if (this.m_justificationShiftX == 4) {
                            d4 = -rectangle2D.getWidth();
                        } else if (this.m_justificationShiftX == 2) {
                            d4 = -rectangle2D.getWidth() / 2.0;
                        }
                        point2D2 = new Point2D.Double(d4, d3 - d8 * this.m_fontSize * this.m_fontLineSpacing);
                        affineTransform.transform(point2D2, point2D2);
                    } else {
                        point2D2 = point2D;
                    }
                    float f = (float)point2D2.getX();
                    float f2 = (float)point2D2.getY();
                    if (this.m_fontOutlineWidth > 0.0) {
                        GlyphVector glyphVector = this.m_graphics2D.getFont().createGlyphVector(fontRenderContext, string2);
                        Shape shape = glyphVector.getOutline(f, f2);
                        this.m_graphics2D.draw(shape);
                    } else {
                        this.m_graphics2D.drawString(string2, f, f2);
                    }
                }
                d8 += 1.0;
            }
            if (this.m_outputType != 6) continue;
            this.writeLine(this.m_PDFGeometryWriter, "ET Q");
        }
        if (stroke != null) {
            this.m_graphics2D.setStroke(stroke);
        }
    }
}

