/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.dataset;

import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.mapyrus.Argument;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.Row;
import org.mapyrus.dataset.ConnectionPool;
import org.mapyrus.dataset.GeographicDataset;
import org.mapyrus.dataset.OracleGeometry;
import org.mapyrus.dataset.WKBGeometryParser;

public class JDBCDataset
implements GeographicDataset {
    private Connection m_connection = null;
    private Statement m_statement = null;
    private ResultSet m_resultSet = null;
    private String m_sql;
    private String m_url;
    private String m_jndiName = null;
    private String[] m_fieldNames;
    private int[] m_fieldTypes;

    public JDBCDataset(String string, String string2) throws MapyrusException {
        Object object;
        String string3 = null;
        Properties properties = new Properties();
        this.m_sql = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf(61);
            if (n <= 0) continue;
            String string5 = string4.substring(0, n);
            String string6 = string4.substring(n + 1);
            if (string5.equals("driver")) {
                string3 = string6;
                continue;
            }
            if (string5.equals("url")) {
                this.m_url = string6;
                continue;
            }
            if (string5.equals("jndiname")) {
                this.m_jndiName = string6;
                continue;
            }
            properties.put(string5, string6);
        }
        try {
            if (string3 != null) {
                Class.forName(string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MapyrusException(MapyrusMessages.get("nojdbcclass") + ": " + classNotFoundException.getMessage() + ": " + string3);
        }
        try {
            if (this.m_jndiName != null) {
                InitialContext initialContext = new InitialContext();
                object = (Context)initialContext.lookup("java:comp/env");
                DataSource dataSource = (DataSource)object.lookup(this.m_jndiName);
                this.m_connection = dataSource.getConnection();
            } else {
                this.m_connection = ConnectionPool.get(this.m_url, properties);
            }
        }
        catch (SQLException sQLException) {
            String string7 = sQLException.getSQLState();
            string7 = string7 != null ? ": " + string7 : "";
            if (this.m_url == null) {
                this.m_url = "";
            }
            throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string7 + ": " + this.m_url);
        }
        catch (NamingException namingException) {
            throw new MapyrusException(namingException.getMessage() + ": " + this.m_jndiName);
        }
        try {
            this.m_statement = this.m_connection.createStatement();
            try {
                this.m_statement.setQueryTimeout(30);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_resultSet = this.m_statement.executeQuery(this.m_sql);
            ResultSetMetaData resultSetMetaData = this.m_resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.m_fieldNames = new String[n];
            this.m_fieldTypes = new int[n];
            for (int i = 0; i < n; ++i) {
                boolean bl;
                this.m_fieldNames[i] = resultSetMetaData.getColumnName(i + 1);
                char c = this.m_fieldNames[i].charAt(0);
                boolean bl2 = bl = Character.isLetter(c) || c == '$';
                if (bl) {
                    for (int j = 1; bl && j < this.m_fieldNames[i].length(); ++j) {
                        c = this.m_fieldNames[i].charAt(j);
                        bl = c == '.' || c == '_' || Character.isLetterOrDigit(c);
                    }
                }
                if (!bl) {
                    throw new MapyrusException(MapyrusMessages.get("invalidfieldname") + ": " + this.m_fieldNames[i]);
                }
                this.m_fieldTypes[i] = resultSetMetaData.getColumnType(i + 1);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.close(false);
            }
            catch (MapyrusException mapyrusException) {
                // empty catch block
            }
            object = sQLException.getSQLState();
            object = object != null ? ": " + (String)object : "";
            throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + (String)object + ": " + this.m_sql);
        }
        catch (MapyrusException mapyrusException) {
            try {
                this.close(false);
            }
            catch (MapyrusException mapyrusException2) {
                // empty catch block
            }
            throw mapyrusException;
        }
    }

    public String getProjection() {
        return null;
    }

    public Hashtable getMetadata() {
        return null;
    }

    public String[] getFieldNames() {
        return this.m_fieldNames;
    }

    public Rectangle2D.Double getWorlds() {
        return new Rectangle2D.Double(-180.0, -90.0, 180.0, 90.0);
    }

    public Row fetch() throws MapyrusException {
        Row row;
        block38: {
            try {
                if (this.m_resultSet.next()) {
                    row = new Row();
                    for (int i = 0; i < this.m_fieldTypes.length; ++i) {
                        Argument argument;
                        block37: {
                            Object[] objectArray;
                            Object object;
                            if (this.m_fieldTypes[i] == -6) {
                                argument = new Argument(this.m_resultSet.getByte(i + 1));
                            } else if (this.m_fieldTypes[i] == 5) {
                                argument = new Argument(this.m_resultSet.getShort(i + 1));
                            } else if (this.m_fieldTypes[i] == 4) {
                                argument = new Argument(this.m_resultSet.getInt(i + 1));
                            } else if (this.m_fieldTypes[i] == -5) {
                                argument = new Argument(this.m_resultSet.getLong(i + 1));
                            } else if (this.m_fieldTypes[i] == 7) {
                                argument = new Argument(this.m_resultSet.getFloat(i + 1));
                            } else if (this.m_fieldTypes[i] == 6 || this.m_fieldTypes[i] == 8) {
                                argument = new Argument(this.m_resultSet.getDouble(i + 1));
                            } else if (this.m_fieldTypes[i] == 3 || this.m_fieldTypes[i] == 2) {
                                argument = new Argument(this.m_resultSet.getDouble(i + 1));
                            } else if (this.m_fieldTypes[i] == -7) {
                                boolean bl = this.m_resultSet.getBoolean(i + 1);
                                argument = bl ? Argument.numericOne : Argument.numericZero;
                            } else if (this.m_fieldTypes[i] == 1 || this.m_fieldTypes[i] == 12 || this.m_fieldTypes[i] == -1 || this.m_fieldTypes[i] == 2005) {
                                object = this.m_resultSet.getString(i + 1);
                                argument = object == null ? Argument.emptyString : new Argument(1, (String)object);
                            } else if (this.m_fieldTypes[i] == -2 || this.m_fieldTypes[i] == -3 || this.m_fieldTypes[i] == -4 || this.m_fieldTypes[i] == 2004) {
                                object = this.m_resultSet.getBytes(i + 1);
                                if (object == null) {
                                    argument = Argument.emptyGeometry;
                                } else {
                                    objectArray = WKBGeometryParser.parse((byte[])object);
                                    argument = new Argument((int)objectArray[0], (double[])objectArray);
                                }
                            } else if (this.m_fieldTypes[i] == 91 || this.m_fieldTypes[i] == 92 || this.m_fieldTypes[i] == 93) {
                                object = this.m_resultSet.getString(i + 1);
                                argument = object == null ? Argument.emptyString : new Argument(1, (String)object);
                            } else if (this.m_fieldTypes[i] == 1111) {
                                object = this.m_resultSet.getBytes(i + 1);
                                if (object == null || ((Object)object).length == 0) {
                                    argument = Argument.emptyString;
                                } else {
                                    try {
                                        objectArray = this.parseHexDigits((byte[])object);
                                        if (objectArray != null) {
                                            double[] dArray = WKBGeometryParser.parse((byte[])objectArray);
                                            argument = new Argument((int)dArray[0], dArray);
                                            break block37;
                                        }
                                        argument = new Argument(1, new String((byte[])object));
                                    }
                                    catch (MapyrusException mapyrusException) {
                                        argument = new Argument(1, new String((byte[])object));
                                    }
                                }
                            } else if (this.m_fieldTypes[i] == 2002) {
                                object = this.m_resultSet.getObject(i + 1);
                                argument = object == null ? Argument.emptyString : OracleGeometry.parseGeometry(object);
                            } else {
                                throw new MapyrusException(MapyrusMessages.get("unknownfieldtype") + ": " + this.m_fieldTypes[i]);
                            }
                        }
                        row.add(argument);
                    }
                    break block38;
                }
                row = null;
            }
            catch (SQLException sQLException) {
                String string = sQLException.getSQLState();
                string = string != null ? ": " + string : "";
                throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string + ": " + this.m_sql);
            }
        }
        return row;
    }

    private byte[] parseHexDigits(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i];
            if (n2 >= 48 && n2 <= 57) {
                n2 -= 48;
            } else if (n2 >= 65 && n2 <= 70) {
                n2 = n2 - 65 + 10;
            } else if (n2 >= 97 && n2 <= 102) {
                n2 = n2 - 97 + 10;
            } else {
                return null;
            }
            if (i % 2 != 0) {
                byArray2[i / 2] = (byte)(n << 4 | n2);
            }
            n = n2;
        }
        return byArray2;
    }

    private void close(boolean bl) throws MapyrusException {
        try {
            if (this.m_statement != null) {
                this.m_statement.close();
            }
        }
        catch (SQLException sQLException) {
            String string = sQLException.getSQLState();
            string = string != null ? ": " + string : "";
            throw new MapyrusException(sQLException.getErrorCode() + ": " + sQLException.getMessage() + string);
        }
        finally {
            if (this.m_connection != null) {
                if (this.m_jndiName != null) {
                    try {
                        this.m_connection.close();
                    }
                    catch (SQLException sQLException) {}
                } else {
                    ConnectionPool.put(this.m_url, this.m_connection, bl);
                }
            }
            this.m_connection = null;
            this.m_statement = null;
        }
    }

    public void close() throws MapyrusException {
        this.close(true);
    }
}

