/*
 * Decompiled with CFR 0.152.
 */
package org.mapyrus.font;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.mapyrus.MapyrusException;
import org.mapyrus.MapyrusMessages;
import org.mapyrus.font.StringDimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdobeFontMetrics {
    private static final int FULL_CHAR_SIZE = 1000;
    private String m_fontName;
    private short[] m_charWidths;
    private short[] m_charAscents;
    private short[] m_charDescents;
    private int m_firstChar;
    private int m_lastChar;
    private boolean m_isFixedPitch;
    private int m_italicAngle;
    private int m_capHeight;
    private int m_ascender;
    private int m_descender;
    private Rectangle m_fontBBox;
    private int m_flags;
    private static HashMap<String, Integer> mISOLatin1CharIndexes = new HashMap(256);

    public AdobeFontMetrics(BufferedReader bufferedReader, String string, HashSet<String> hashSet) throws IOException, MapyrusException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.m_charWidths = new short[256];
        this.m_charAscents = new short[256];
        this.m_charDescents = new short[256];
        this.m_isFixedPitch = false;
        this.m_firstChar = Integer.MAX_VALUE;
        this.m_lastChar = Integer.MIN_VALUE;
        this.m_flags = 32;
        try {
            String string2 = bufferedReader.readLine();
            if (string2 == null || !string2.startsWith("StartFontMetrics")) {
                throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string);
            }
            while (!bl2 && string2 != null) {
                int n;
                int n2;
                int n3;
                StringTokenizer stringTokenizer;
                if (bl && string2.startsWith("C")) {
                    Integer n4;
                    stringTokenizer = new StringTokenizer(string2);
                    n3 = -1;
                    n2 = 1000;
                    n = 1000;
                    short s = 0;
                    String string3 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (string4.equals("C")) {
                            n3 = Integer.parseInt(stringTokenizer.nextToken());
                        } else if (string4.equals("WX")) {
                            n2 = Short.parseShort(stringTokenizer.nextToken());
                        } else if (string4.equals("N")) {
                            string3 = stringTokenizer.nextToken();
                        } else if (string4.equals("B")) {
                            stringTokenizer.nextToken();
                            s = (short)Math.round(Double.parseDouble(stringTokenizer.nextToken()));
                            stringTokenizer.nextToken();
                            n = (short)Math.round(Double.parseDouble(stringTokenizer.nextToken()));
                        }
                        string4 = stringTokenizer.nextToken();
                        while (!string4.equals(";") && stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken();
                        }
                    }
                    if (bl3 && (n3 < 0 || n3 > 127) && (n4 = mISOLatin1CharIndexes.get(string3)) != null) {
                        n3 = n4;
                    }
                    if (n3 >= 0 && n3 < this.m_charWidths.length) {
                        this.m_charWidths[n3] = n2;
                        this.m_charAscents[n3] = n;
                        this.m_charDescents[n3] = s;
                        if (n3 < this.m_firstChar) {
                            this.m_firstChar = n3;
                        }
                        if (n3 > this.m_lastChar) {
                            this.m_lastChar = n3;
                        }
                    }
                } else if (string2.startsWith("FontName")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.m_fontName = stringTokenizer.nextToken();
                    bl3 = hashSet.contains(this.m_fontName);
                } else if (string2.startsWith("IsFixedPitch") && string2.toLowerCase().indexOf("true") >= 0) {
                    this.m_isFixedPitch = true;
                    this.m_flags |= 1;
                } else if (string2.startsWith("ItalicAngle")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.m_italicAngle = (int)Math.round(Double.parseDouble(stringTokenizer.nextToken()));
                } else if (string2.startsWith("CapHeight")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.m_capHeight = Integer.parseInt(stringTokenizer.nextToken());
                } else if (string2.startsWith("Ascender")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.m_ascender = Integer.parseInt(stringTokenizer.nextToken());
                } else if (string2.startsWith("Descender")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 2) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    this.m_descender = Integer.parseInt(stringTokenizer.nextToken());
                } else if (string2.startsWith("FontBBox")) {
                    stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() < 5) {
                        throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + string2);
                    }
                    stringTokenizer.nextToken();
                    int n5 = Integer.parseInt(stringTokenizer.nextToken());
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    this.m_fontBBox = new Rectangle(n5, n3, n2 - n5, n - n3);
                } else if (string2.startsWith("Weight")) {
                    stringTokenizer = new StringTokenizer(string2);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        if (!string5.equalsIgnoreCase("italic")) continue;
                        this.m_flags |= 0x40;
                    }
                } else if (string2.startsWith("StartCharMetrics")) {
                    bl = true;
                } else if (string2.startsWith("EndCharMetrics")) {
                    bl = false;
                    bl2 = true;
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MapyrusException(MapyrusMessages.get("notaafmfile") + ": " + string + ": " + numberFormatException.getMessage());
        }
    }

    public String getFontName() {
        return this.m_fontName;
    }

    public int getFirstChar() {
        return this.m_firstChar;
    }

    public int getLastChar() {
        return this.m_lastChar;
    }

    public int getCharWidth(int n) {
        return this.m_charWidths[n];
    }

    public int getItalicAngle() {
        return this.m_italicAngle;
    }

    public int getCapHeight() {
        return this.m_capHeight;
    }

    public Rectangle getFontBBox() {
        return this.m_fontBBox;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public int getAscender() {
        return this.m_ascender;
    }

    public int getDescender() {
        return this.m_descender;
    }

    public String toString() {
        return "Adobe Font Metrics for " + this.m_fontName;
    }

    public StringDimension getStringDimension(String string, double d) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        double d2 = 0.0;
        double d3 = 1000.0;
        StringDimension stringDimension = new StringDimension();
        for (n = 0; n < n3; ++n) {
            char c = string.charAt(n);
            if (c >= '\u0000' && c < this.m_charWidths.length) {
                n2 += this.m_charWidths[c];
                if ((double)this.m_charAscents[c] > d2) {
                    d2 = this.m_charAscents[c];
                }
                if (!((double)this.m_charDescents[c] < d3)) continue;
                d3 = this.m_charDescents[c];
                continue;
            }
            n2 += 1000;
        }
        double d4 = (double)n2 / 1000.0 * d;
        d2 = d2 / 1000.0 * d;
        d3 = d3 / 1000.0 * d;
        if (this.m_isFixedPitch) {
            n = 32;
            d4 = (double)string.length() * ((double)this.m_charWidths[n] / 1000.0) * d;
        }
        stringDimension.setSize(d4, d, d2, d3);
        return stringDimension;
    }

    static {
        mISOLatin1CharIndexes.put("Aacute", 193);
        mISOLatin1CharIndexes.put("Acircumflex", 194);
        mISOLatin1CharIndexes.put("Adieresis", 196);
        mISOLatin1CharIndexes.put("Agrave", 192);
        mISOLatin1CharIndexes.put("Aring", 197);
        mISOLatin1CharIndexes.put("Atilde", 195);
        mISOLatin1CharIndexes.put("Ccedilla", 199);
        mISOLatin1CharIndexes.put("Eacute", 201);
        mISOLatin1CharIndexes.put("Ecircumflex", 202);
        mISOLatin1CharIndexes.put("Edieresis", 203);
        mISOLatin1CharIndexes.put("Egrave", 200);
        mISOLatin1CharIndexes.put("Eth", 0);
        mISOLatin1CharIndexes.put("Iacute", 205);
        mISOLatin1CharIndexes.put("Icircumflex", 206);
        mISOLatin1CharIndexes.put("Idieresis", 207);
        mISOLatin1CharIndexes.put("Igrave", 204);
        mISOLatin1CharIndexes.put("Oacute", 211);
        mISOLatin1CharIndexes.put("Ocircumflex", 212);
        mISOLatin1CharIndexes.put("Odieresis", 214);
        mISOLatin1CharIndexes.put("Ograve", 210);
        mISOLatin1CharIndexes.put("Oslash", 216);
        mISOLatin1CharIndexes.put("Otilde", 213);
        mISOLatin1CharIndexes.put("Thorn", 222);
        mISOLatin1CharIndexes.put("Uacute", 218);
        mISOLatin1CharIndexes.put("Ucircumflex", 219);
        mISOLatin1CharIndexes.put("Udieresis", 220);
        mISOLatin1CharIndexes.put("Ugrave", 217);
        mISOLatin1CharIndexes.put("Yacute", 221);
        mISOLatin1CharIndexes.put("acircumflex", 226);
        mISOLatin1CharIndexes.put("acute", 225);
        mISOLatin1CharIndexes.put("adieresis", 228);
        mISOLatin1CharIndexes.put("agrave", 224);
        mISOLatin1CharIndexes.put("aring", 229);
        mISOLatin1CharIndexes.put("atilde", 227);
        mISOLatin1CharIndexes.put("breve", 150);
        mISOLatin1CharIndexes.put("brokenbar", 166);
        mISOLatin1CharIndexes.put("caron", 159);
        mISOLatin1CharIndexes.put("ccedilla", 231);
        mISOLatin1CharIndexes.put("cedilla", 184);
        mISOLatin1CharIndexes.put("cent", 162);
        mISOLatin1CharIndexes.put("circumflex", 147);
        mISOLatin1CharIndexes.put("copyright", 169);
        mISOLatin1CharIndexes.put("currency", 164);
        mISOLatin1CharIndexes.put("degree", 176);
        mISOLatin1CharIndexes.put("dieresis", 168);
        mISOLatin1CharIndexes.put("divide", 247);
        mISOLatin1CharIndexes.put("dotaccent", 151);
        mISOLatin1CharIndexes.put("dotlessi", 144);
        mISOLatin1CharIndexes.put("eacute", 233);
        mISOLatin1CharIndexes.put("ecircumflex", 234);
        mISOLatin1CharIndexes.put("edieresis", 235);
        mISOLatin1CharIndexes.put("egrave", 232);
        mISOLatin1CharIndexes.put("eth", 240);
        mISOLatin1CharIndexes.put("exclamdown", 161);
        mISOLatin1CharIndexes.put("germandbls", 223);
        mISOLatin1CharIndexes.put("grave", 145);
        mISOLatin1CharIndexes.put("guillemotleft", 171);
        mISOLatin1CharIndexes.put("guillemotright", 187);
        mISOLatin1CharIndexes.put("hungarumlaut", 157);
        mISOLatin1CharIndexes.put("hyphen", 173);
        mISOLatin1CharIndexes.put("iacute", 237);
        mISOLatin1CharIndexes.put("icircumflex", 238);
        mISOLatin1CharIndexes.put("idieresis", 239);
        mISOLatin1CharIndexes.put("igrave", 236);
        mISOLatin1CharIndexes.put("logicalnot", 172);
        mISOLatin1CharIndexes.put("macron", 175);
        mISOLatin1CharIndexes.put("mu", 0);
        mISOLatin1CharIndexes.put("multiply", 215);
        mISOLatin1CharIndexes.put("ntilde", 241);
        mISOLatin1CharIndexes.put("oacute", 243);
        mISOLatin1CharIndexes.put("ocircumflex", 244);
        mISOLatin1CharIndexes.put("odieresis", 246);
        mISOLatin1CharIndexes.put("ogonek", 158);
        mISOLatin1CharIndexes.put("ograve", 242);
        mISOLatin1CharIndexes.put("onehalf", 189);
        mISOLatin1CharIndexes.put("onequarter", 188);
        mISOLatin1CharIndexes.put("onesuperior", 185);
        mISOLatin1CharIndexes.put("ordfeminine", 170);
        mISOLatin1CharIndexes.put("ordmasculine", 186);
        mISOLatin1CharIndexes.put("oslash", 248);
        mISOLatin1CharIndexes.put("otilde", 245);
        mISOLatin1CharIndexes.put("paragraph", 182);
        mISOLatin1CharIndexes.put("periodcentered", 183);
        mISOLatin1CharIndexes.put("plusminus", 177);
        mISOLatin1CharIndexes.put("questiondown", 191);
        mISOLatin1CharIndexes.put("registered", 174);
        mISOLatin1CharIndexes.put("ring", 154);
        mISOLatin1CharIndexes.put("section", 167);
        mISOLatin1CharIndexes.put("sterling", 163);
        mISOLatin1CharIndexes.put("thorn", 254);
        mISOLatin1CharIndexes.put("threequarters", 190);
        mISOLatin1CharIndexes.put("threesuperior", 179);
        mISOLatin1CharIndexes.put("tilde", 148);
        mISOLatin1CharIndexes.put("twosuperior", 178);
        mISOLatin1CharIndexes.put("uacute", 250);
        mISOLatin1CharIndexes.put("ucircumflex", 251);
        mISOLatin1CharIndexes.put("udieresis", 252);
        mISOLatin1CharIndexes.put("ugrave", 249);
        mISOLatin1CharIndexes.put("yacute", 253);
        mISOLatin1CharIndexes.put("ydieresis", 255);
        mISOLatin1CharIndexes.put("yen", 165);
    }
}

